#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/repl/parsslot.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.3
 | File mod date:    1997.11.29 23:10:32
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  repl
 |
 `------------------------------------------------------------------------|#


;;;
;;;  note: this code is also used by the cross compiler `rsc'
;;;

(define *slots-sealed-by-default?* #f)

(define (parse-slot-descriptor supers name options envt d-envt)
  (let ((init-mode 'required)
	(init-val #f)
	(type #f)
	(getter #f)
	(setter #f)
	(alloc #f)
	(init-kwd #f)
	(sealed? *slots-sealed-by-default?*))
    (for-each-keyword
     ;; if this procedure returns #f, an error is reported
     ;; ("unrecognized keyword")
     (lambda (keyword value)
       (case keyword
	 ((type:) (set! type (parse-type-expr value envt d-envt))
		  #t)
	 ((getter:) (set! getter value)
		    #t)
	 ((setter:) (set! setter value)
		    #t)
	 ((allocation:) (if (memq value '(constant internal))
			    (set! alloc value)
			    (error/syntax 
			     "`allocation: ~s' is not supported" value)))
	 ((init-value:) (if (eq? init-mode 'required)
			    (set! init-mode 'optional))
			(set! init-val (parse-const-expr value envt d-envt))
			#t)
	 ((init-function:) (if (eq? init-mode 'required)
			       (set! init-mode 'function))
			   ;; this expression evaluates to a function
			   (let ((proc (target-expr-value value envt d-envt)))
			     (set! init-val proc)
			     (if (not (procedure? (actual-value proc)))
				 (error "init-function: expr `~s' doesn't\nevaluate to a procedure" value))
			     #t))
	 ((init-keyword:) (if value
			      (if (keyword? value)
				  (set! init-kwd value)
				  (error/syntax 
				   "init-keyword not a keyword: ~s"
				   value))
			      (set! init-mode 'prohibited)))
	 ((:sealed) (set! sealed? #t) #t)
	 ((:open) (set! sealed? #f) #t)
	 (else #f)))
     options)
    ;;
    (if setter
	(if alloc
	    (error/syntax 
	     "`allocation: ~s' is inconsistent with `setter: ~s'"
	     alloc
	     setter))
	(if (not alloc)
	    (set! setter
		  (string->symbol (string-append 
				   "set-" 
				   (symbol->string name)
				   "!")))))
    ;;
    (if (not getter)
	(set! getter name))
    ;;
    (if (eq? alloc 'internal)
	(begin
	  (set! setter #f)
	  (set! getter #f))
	(if (eq? alloc 'constant)
	    (set! setter #f)))
    ;;
    (make <slot-descriptor>
	  name: name
	  initialization-mode: init-mode
	  init-value: init-val
	  type-restriction: (or type
				(xform (well-known '<object>)
				       'value))
	  index: 0
	  getter: getter
	  setter: setter 
	  properties: (if sealed?
			  '((sealed? . #t))
			  '())
	  init-keyword: (or init-kwd (symbol->keyword name)))))
