;;; $Id: emacspeak-remote.el,v 7.0 1997/11/13 15:32:30 raman Exp $
;;; $Author: raman $ 
;;; Description: Auditory interface to remote speech server
;;; Keywords: Emacspeak, Speak, Spoken Output, remote server
;;{{{  LCD Archive entry: 

;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@adobe.com 
;;; A speech interface to Emacs |
;;; $Date: 1997/11/13 15:32:30 $ |
;;;  $Revision: 7.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:

;;; Copyright (c) 1997 by T. V. Raman Adobe Systems Incorporated 
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;{{{  Required modules

(require 'cl)
(require 'backquote)
(declaim  (optimize  (safety 0) (speed 3)))
(eval-when (compile)
  (require 'emacspeak-speak)
  (require 'emacspeak-keymap)
  (require 'emacspeak-sounds))

(eval-when (compile)
  (require 'emacspeak-fix-interactive))
(require 'emacspeak-eterm)

;;}}}
;;{{{  Introduction

;;; In a running emacspeak session,
;;;nuke the running driver and start talking to a remote speech server,
;;;after prompting for host and port

;;}}}
;;{{{  User customizations

(defvar emacspeak-remote-hooks nil
  "List of hook functions that are run after
emacspeak is set to run as a remote application.
Use this to add actions you typically perform after you enter remote mode.")

;;; Here is what I currently use:
;;; It switches to using C-r as the emacspeak prefix key
(add-hook 'emacspeak-remote-hooks
          (function
           (lambda ()
             (emacspeak-keymap-choose-new-emacspeak-prefix
              (format "%c" 18))
             (setq emacspeak-auditory-icon-function 'emacspeak-serve-auditory-icon))))

;;}}}
;;{{{  Connect to  remote server

(defun  emacspeak-remote-connect-to-server (host port)
  "Connect to and start using remote speech server running on host host
and listening on port port.  Host is the hostname of the remote
server, typically the desktop machine.  Port is the tcp port that that
host is listening on for speech requests."
  (interactive
   (list
    (completing-read "Remote host: "
                     emacspeak-eterm-remote-hosts-table)
    (read-from-minibuffer "Remote port: ""2222")))
  (declare (special dtk-speaker-process
                    emacspeak-eterm-remote-hosts-table))
  (let ((old-process dtk-speaker-process)
        (new-process(start-process "remote-speaker" nil
                                   "telnet"
                                   host port)))
    (unless (intern-soft host emacspeak-eterm-remote-hosts-table)
      (emacspeak-eterm-cache-remote-host host))
    (cond
     ((eq 'run (process-status new-process))
      (setq dtk-speaker-process new-process)
      (kill-process old-process)
      (run-hooks 'emacspeak-remote-hooks)
      (message "Connecting to server on host %s  port %s"
               host port ))
     (t (error "Failed to connect to speech server on host %s port %s"
               host port )))))


(emacspeak-fix-interactive-command-if-necessary 'emacspeak-remote-connect-to-server)

;;}}}
;;{{{ start up local server
(defvar emacspeak-remote-local-server-process nil
  "Process handle for speech server")
(defun emacspeak-remote-server-filter-function (process string)
  (dtk-speak string))


(defun emacspeak-remote-startup-local-server()
  "Starts up local speech server for use by a remote Emacspeak session."
  (interactive)
  (declare (special emacspeak-remote-local-server-process
                     dtk-program dtk-tcl emacspeak-dir))
        (when (and emacspeak-remote-local-server-process
             (eq 'run (process-status
                       emacspeak-remote-local-server-process)))
    (kill-process emacspeak-remote-local-server-process))
        (let ((port (read-from-minibuffer "Listen on port: " "2222")))
          (setq emacspeak-remote-local-server-process
        (start-process "Speech-Server" nil
                       dtk-tcl
                       (concat emacspeak-dir "/" "speech-server")
                       port
                       (concat emacspeak-dir "/" dtk-program)))
          (set-process-filter emacspeak-remote-local-server-process 'emacspeak-remote-server-filter-function)
               (when (eq 'run (process-status
                  emacspeak-remote-local-server-process))
    (message "Successfuly started speech server on port %s. " port))))

  

;;}}}
(provide 'emacspeak-remote )
;;{{{ end of file 

;;; local variables:
;;; folded-file: t
;;; end: 

;;}}}
