/* gEdit
 * Copyright (C) 1998 Alex Roberts and Evan Lawrence
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
 
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <gtk/gtk.h>

#include "main.h"
#include "gE_prefs.h"
#include "menus.h"

gE_window *main_window;
char home[STRING_LENGTH_MAX];
char *homea;
char rc[STRING_LENGTH_MAX];
char fname[STRING_LENGTH_MAX];

void  destroy_window (GtkWidget *widget, GtkWidget **window)
{
   *window = NULL;
   gtk_exit(0);
}


void file_quit_cmd_callback (GtkWidget *widget, gpointer data)
{
   /* g_print ("%s\n", (char *) data);*/
   gtk_exit(0);

}

/*
void file_newwindow_cmd_callback (GtkWidget *widget, gpointer data)
{
  gE_window_new();
}

*/

void prog_init(char *file)
{
 /* Improved function, now the tab doesn't show the './' before the filename
    AND it doesn't crash when you try to open a file that doesn't exist
		- Alex */

	if (file != NULL)
	  {
	   strcpy(fname, "");
	   /* strcpy(fname, "./"); */
	   #ifdef DEBUG
	   g_print("fname= %s\n", fname);
	   #endif
	   strcat(fname, file);
	   #ifdef DEBUG
	   g_print("fname= %s\n", fname);
	   #endif

	   main_window = gE_window_new();	   
	   gE_file_open(gE_document_current(main_window), fname);
	   /*gtk_label_set (GTK_LABEL(gE_document_current(main_window)->tab_label), fname);*/
	   /* gE_document_current(main_window)->filename = fname;*/
	  }
         else
	  {
	   main_window = gE_window_new();
	  }
}

int main (int argc, char *argv[])
{
 int x;


  /* gtk_set_locale (); */

  gtk_init (&argc, &argv);
  
  for (x = 1; x < argc; x++)
     {
    if (strcmp (argv[x], "--help") == 0)
      {
       g_print("gEdit\nUsage: gedit [--help] [--version] [file...]\n");
       
       exit(0);
      }
   
    else if (strcmp (argv[x], "--version") == 0)
      {
 	// g_print ("gEdit\n\n");
 	gE_show_version();
 	exit(0);
      }
     }


	gE_get_rc_file();
	gE_rc_parse();
   
  
 prog_init(argv[1]);
  
  gtk_main ();
  

  
  return 0;
}
		      		      
