/**********************************************************************/
/* JERED.H : Definition pour l'editeur JERED                          */
/**********************************************************************/

/*
    Copyright (C) 1996, 1997 Free Software Foundation, Inc.
    Ce programme fait partie du package JERED et est soumis, comme le
    reste du package JERED, a la Gnu General Public License version 2
    ou superieure dont voici un extrait et dont vous pouvez lire
    la totalite en consultant le fichier COPYING.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef _JE_
#define _JE_

#include <time.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <time.h>
#include <sys/stat.h>
#include <curses.h>

typedef struct _JEREDCOLOR_
        {
                int color1;
                int color2;
                chtype attr1;
                chtype attr2;
        }
        JEREDCOLOR;
        
typedef struct _LIGNE_
        {
                struct _LIGNE_ *precedente;
                struct _LIGNE_ *suivante;
                int debut_marque;
                int fin_marque;
                char *texte;
        }
        LIGNE;

typedef struct _FICHIER_
        {
                char *filename;
                LIGNE *premiere;
                LIGNE *derniere;
                LIGNE *courante;
                LIGNE *debut_ecran;
                int statmode;
                int numcourante;
                int numdebecr;
                int saved;
                int nblignes;
                int first;
                int ligne;
                int colonne;
                int premier_caractere;
                void (*affiche_ligne)(LIGNE *, int, char *, int);
        }
        FICHIER;
        
typedef struct _FILELIST_
        {
                FICHIER *fichier;               /* FICHIER <> FILE */
                struct _FILELIST_ *suivant;     /* suivant <> next */
        }
        FILELIST;

typedef struct _FUNCMAP_
        {
                char *funcname;
                int (*function)(FICHIER *fichier, char *buffer, int position);
                int funcdesc;
        }
        FUNCMAP;

typedef struct _KEYMAP_
        {
                FUNCMAP *func;
                char *text;
                char *macro;
        }
        KEYMAP;
        
#define LOCK_NONE               0
#define LOCK_READONLY           1
#define LOCK_STRICT             2

#define INSERE_LIGNE            1
#define REMONTE_LIGNE           2
#define DESCEND_LIGNE           3
#define SAUVE                   4
#define DETRUIT_LIGNE           5
#define QUITTE                  6
#define REMONTE_PAGE            7
#define DESCEND_PAGE            8
#define SHELL                   9
#define CHERCHE                 10
#define COMMANDE                11
#define MARQUER_BLOC            12
#define DEMARQUER_BLOC          13
#define COPIER_BLOC             14
#define DEPLACER_BLOC           15
#define SUPPRIMER_BLOC          16
#define FICHIERSUIVANT          17
#define REMONTE_PARAGRAPHE      18
#define DESCEND_PARAGRAPHE      19
#define MAJUSCULE_BLOC          20
#define MINUSCULE_BLOC          21
#define ALIGNE_BLOC             22
#define WRAP_BLOC               23

#define ASKCONFIRMATION         1
#define DONTASKCONFIRMATION     0
#define SZBUF                   2048
#define XMIN                    0
#define YMIN                    1
#define NBCOULEURS              25
#define NOTMARKED               -1
#define OUI                     1
#define NON                     0
#define YES                     (OUI)
#define NO                      (NON)

#define ATTENDSTOUCHE           1
#define NATTENDSPAS             0
#define INSERT                  2
#define REPLACE                 1

#define ENGLISH                 0
#define FRENCH                  1
#define FINNISH                 2
#define GERMAN                  3
#define RUSSIAN                 4

#define NORMALMODE              0
#define DIALOGMODE              1

#define NOTFOUND                -1
#define NOMACRO                 0
#define RECORDING               1
#define PLAYING                 2
#define RECORDED                3
#define MACROFILE               "macro.jem"

#define COULEUR_STATUS          1       /* couleur de la barre d'etat */
#define COULEUR_AIDE            2       /* couleur de la barre d'aide */
#define COULEUR_MOTCLE          3       /* couleur des mots clefs du langage */
#define COULEUR_CHAINE          4       /* couleur des chaines entre guillemets du langage */
#define COULEUR_COMMENT         5       /* couleur des commentaires du langage */
#define COULEUR_ALERTE1         6       /* couleurs des boites d'alerte */
#define COULEUR_ALERTE2         7       /* couleur du bouton selectionne */
#define COULEUR_NORMALE         8       /* couleur du reste */
#define COULEUR_BLOC            9       /* couleur des blocs marques */
#define COULEUR_CHAR           10       /* couleur des constantes caracteres */
#define COULEUR_SURBRILLANCE   11       /* couleur pour rehausser les couleurs de la barre d'aide */  
#define NBJEREDCOLORS          11 


        /* quelques lignes pour un peu plus de portabilite !!! */
#if HAVE_LIBNCURSES == 0        /* curses.h n'est pas Ncurses.h */
#ifndef COLOR_BLACK             /* si les couleurs ne sont pas definies */
#define         COLOR_BLACK             (chtype)A_NORMAL
#define         COLOR_RED               (chtype)A_NORMAL
#define         COLOR_GREEN             (chtype)A_NORMAL
#define         COLOR_YELLOW            (chtype)A_NORMAL
#define         COLOR_BLUE              (chtype)A_NORMAL
#define         COLOR_MAGENTA           (chtype)A_NORMAL
#define         COLOR_CYAN              (chtype)A_NORMAL
#define         COLOR_WHITE             (chtype)A_NORMAL
#define         has_colors()            FALSE
#define         start_color()
#define         init_pair(a, b, c)
#define         COLOR_PAIR(a)           (chtype)A_NORMAL
#endif /* COLOR_BLACK */
#endif /* HAVE_LIBNCURSES */

#define         min(a, b)       ((a < b) ? a : b)
#define         max(a, b)       ((a > b) ? a : b)

#define KEY_TAB         '\t'
#define KEY_RETURN      '\r'
#define KEY_LINEFEED    '\n'
#define KEY_ESPACE      ' '
#define KEY_ESCAPE      0x001b
#define Ctrl_A          1
#define Ctrl_B          2
#define Ctrl_C          3
#define Ctrl_D          4
#define Ctrl_E          5
#define Ctrl_F          6
#define Ctrl_G          7
#define Ctrl_H          8
#define Ctrl_I          9
#define Ctrl_J          10
#define Ctrl_K          11
#define Ctrl_L          12
#define Ctrl_M          13
#define Ctrl_N          14
#define Ctrl_O          15
#define Ctrl_P          16
#define Ctrl_Q          17
#define Ctrl_R          18
#define Ctrl_S          19
#define Ctrl_T          20
#define Ctrl_U          21
#define Ctrl_V          22
#define Ctrl_W          23
#define Ctrl_X          24
#define Ctrl_Y          25
#define Ctrl_Z          26

#define Shift_TAB       Ctrl_T

void supprime_ligne(FICHIER *fichier, LIGNE *courante);
LIGNE *insere_ligne(FICHIER *fichier, char *buf, LIGNE *avant, LIGNE *apres);
int edite_autre_fichier(char *filename);
void aligne_ligne(char *string, int col);
int remonter_ligne(FICHIER *fichier);
int descendre_ligne(FICHIER *fichier);

void debute_ecran(void);
void termine_ecran(void);
int allume_curseur(int type);
void eteint_curseur(void);
void restaure_curseur(void);

int alerte(int bouton, char *titre, char *txtboutons);

int set_refresh(int on_off);
int get_refresh(void);
int get_txt(int x, int y, int xmax, int ymax, chtype *dest);
int put_txt(int x, int y, int xmax, int ymax, chtype *src);

void beautify_filename(char *string, char *filename);
void put_ligne(LIGNE *courante, int y, char *texte, int decalage);
void print_ligne(LIGNE *courante, int y, char *texte, int decalage);
void put_statligne(int x, int y, char *texte, chtype attrib);
void put_helpline(int x, int y, char *texte, chtype attrib);

void clr_scr(void);

void scrollup(int ymin, int ymax);
void scrolldown(int ymin, int ymax);
void restart_screen_again(void);

int fread_key(void);

int terminal_type(void);

int bloc_dans_ce_fichier(FICHIER *fichier);
void demarquer_bloc(void);
void marquer_bloc(FICHIER *fichier);
int copier_bloc(FICHIER *fichier);
void deplacer_bloc(FICHIER *fichier);
void supprimer_bloc(int ask);
void uppercaseblock(FICHIER *fichier);
void lowercaseblock(FICHIER *fichier);
void alignblock(FICHIER *fichier);
void wrapblock(FICHIER *fichier);
void test_and_correct_block(FICHIER *fichier);

void erreur(char *fmt, char *mess);
void inverse_insert_mode(void);
chtype *sauve_ecran(void);
void restaure_ecran(chtype *buffer, int waitakey);
void affiche_status_line(FICHIER *fichier, int colonne);
void affiche_help_line(void);
int cfamily(char *filename);
int question(void);

chtype hg(void);
chtype hm(void);
chtype hd(void);
chtype mg(void);
chtype mm(void);
chtype md(void);
chtype bg(void);
chtype bm(void);
chtype bd(void);
chtype hgd(void);
chtype hmd(void);
chtype hdd(void);
chtype mgd(void);
chtype mmd(void);
chtype mdd(void);
chtype bgd(void);
chtype bmd(void);
chtype bdd(void);
chtype ht(void);
chtype bt(void);
chtype gt(void);
chtype dt(void);
chtype htd(void);
chtype btd(void);
chtype gtd(void);
chtype dtd(void);

void initialise_profile(char *filename);
void test_config(char *line);
void init_helpbars(char *hb, char *eschb);
void set_jered_colors(void);

int confirmation(char *question);

int handle_escape_key(FICHIER *fichier, char *buffer, int position);
int handle_normal_key(int key, FICHIER *fichier, char *buffer, int position);
void build_default_keymap(void);
FUNCMAP *findfunction(char *funcname);
void mapkeynametofuncmactxt(char *esckeyname, char *funcmactxtname);
void mapkeyindextofuncmactxt(int kindex, char *funcmactxtname);
int ismapped(int key);
void remap_a_key(char *mapping);
void demap_a_key(KEYMAP *pk);
void demap_keymax(void);
void demap_all_keys(void);
int lookup_keymap(char *fname, int esc);
char *get_keymap(int key);

int handle_normal_char(int key, FICHIER *fichier, char *buffer, int position);
int type_text(char *text, FICHIER *fichier, char *buffer, int position);
void droite(FICHIER *fichier, char *buf, int affiche, int end);
void gauche(FICHIER *fichier, char *buf, int affiche, int home);
void affiche_ecran(FICHIER *fichier, int decalage, LIGNE *ignore);
int realloue_texte(LIGNE *plig, char *texte);
char *inserespace(char *chaine, int position, int nombre);
void destruction_ligne(FICHIER *fichier);
void set_default_macro(char *macname);
void current_word(char *buf, int pos, char *dest);
void launch_external_command(char *cmdline, int wait);

int key_index(char *keyname);
char *key_name(int index);

#ifndef _JE_TABCOUL_

extern int inputmode;
extern int language;
extern int macro;
extern FILE *fmacro;
extern int XMAX;
extern int YMAX;
extern chtype couleur[NBCOULEURS];

#endif          /* _JE_TABCOUL_ */

#endif          /* _JE_ */
/**********************************************************************/
