#include "phalanx.h"

#ifndef REHASH
#	define REHASH 3
#endif

thashentry *HT;
unsigned SizeHT = 70000;
unsigned short Age = 0;

/**
*** short int representation of move.  To be used in the binary
*** opening book and hash table.
**/
unsigned short smove(tmove *m)
{
	unsigned short sm;
	sm = ( m->from << 8 );
	if( m->special ) return sm | m->special;
	sm |= m->to;
	if( m->in1 != m->in2a ) switch( m->in2a )
	{	case WQ: sm -= 10; break;  case BQ: sm += 10; break;
		case WR: sm -= 20; break;  case BR: sm += 20; break;
		case WB: sm -= 30; break;  case BB: sm += 30; break;
		case WN: sm -= 40; break;  case BN: sm += 40; break;
	}
	return sm;
}


thashentry *seekHT(void)
{
register short i;
register thashentry *t;

for( i=0; i!=REHASH; i++ )
{
	t = HT + ( G[Counter].hashboard + i ) % SizeHT;
	if( G[Counter].hashboard == t->hashboard ) return t;
}

return NULL;
}



/************************************************************
 * We need a good replacement strategy!
 * Good cells to replace:
 * 1) empty (not used) or cell with the same board
 * 2) cell stored at previous search
 * 3) cell that stores results computed at a low depth
 * 4) beta_cut (fail high) cell
 *********************************************************/
void writeHT( short value, short Alpha, short Beta )
{
register short i;
register thashentry *t;
register thashentry *best = NULL;
tmove *m = & PV[Ply][Ply];

/* First pass: look for the same board or an empty cell */
for( i=0; i!=REHASH; i++ )
{
	t = HT + ( G[Counter].hashboard + i ) % SizeHT;
	if( G[Counter].hashboard == t->hashboard
	 || t->hashboard == 0 ) { best = t; break; }
}

/* Second pass: look for an oldest-aged cell */
if( best == NULL )
for( i=0; i!=REHASH; i++ )
{
	t = HT + ( G[Counter].hashboard + i ) % SizeHT;
	if( t->age < Age && ( best==NULL || best->age > t->age ) ) best = t;
}

/* Third pass: look for a cell with least depth */
if( best == NULL )
for( i=0; i!=REHASH; i++ )
{
	t = HT + ( G[Counter].hashboard + i ) % SizeHT;
	if( best==NULL || best->depth > t->depth
	 || ( best->depth==t->depth
	   && best->result!=beta_cut && t->result==beta_cut ) ) best = t;
}

if( best->hashboard == G[Counter].hashboard
 && best->depth > Depth && best->result!=beta_cut ) return;

if( value > CHECKMATE-100 ) best->value = value+Ply;
else if( value < -CHECKMATE+100 ) best->value = value-Ply;
else best->value = value;

if( value <= Alpha ) best->result = alpha_cut;
else
if( value >= Beta ) best->result = beta_cut;
else
best->result = no_cut;

/* alpha_cut brings no killer information */
if( best->result != alpha_cut ) best->move = smove(m);
else if( best->hashboard != G[Counter].hashboard ) best->move = 0;

best->hashboard = G[Counter].hashboard;
best->age = Age;
best->depth = Depth;

}



/*
 * Full recomputation of hash board.
 */
unsigned hashboard(void)
{

register short i;
unsigned result = 0;
for ( i=A1; i!=H9; i++ ) if ( B[i] != 3 && B[i] != 0 )
{
/*
	short square = i%10-1 + 8*(i/10-2);
	short piece = B[i];
	piece = piece/8 - ( color(piece)==WHITE ? 1 : 2 );
*/
	result ^= H[ HP[ B[i] ] ][ HS[i] ];
}

if( Color == BLACK ) result ^= HASH_COLOR;

#undef debug
#ifdef debug
/* just showing the result */
printf ("Debug: Hashboard = %08X\n",result);
printf ("Hit ENTER to continue "); getchar();
#endif

return result;
}





/********************************************************
 *    The rest contains random numbers
 *    to be used for hashing.
 ********************************************************/

unsigned H[12][64]=
{
	{
		0x8C78407C, 0xC3667B4A, 0x22AD4CED, 0x0BCAE627, 
		0x5BE2A9A3, 0xC4940655, 0x274C9DCB, 0xB55EB368, 
		0xE6C71E6E, 0x9A9E7EEE, 0xC425FD27, 0xCC007EED, 
		0x476192E5, 0x89E3D3A5, 0xEA78FAFB, 0x27665BD0, 
		0x9E46E105, 0xCD8B82C2, 0x2EA87ABA, 0x54462C94, 
		0xB3449DD5, 0x42666A5D, 0x3F657968, 0x4DCF2DE5, 
		0x09290438, 0x3E95D957, 0xD2E53D4F, 0x8E16CDF2, 
		0xCE6DFEA2, 0x75640BA3, 0xED9F39A4, 0x3AC65C2C, 
		0xBBDD20E3, 0x98132489, 0x5F7FBA11, 0x28C05E8D, 
		0x930D52BE, 0x5B21D077, 0x09710190, 0x0D45D752, 
		0x645D0413, 0x2E22DBD7, 0xA1B7583F, 0x37034473, 
		0xA247F1CA, 0x6DFBBAF5, 0x45389FEF, 0xF841DCB1, 
		0x7040F197, 0xEF9CE22F, 0xF775B834, 0x9AA89DA4, 
		0x8D53D2F0, 0x379D964D, 0x1D29DAB7, 0xD9507BBF, 
		0x9670F36B, 0x459B60B9, 0x99A710A3, 0x3BF21F7E, 
		0x0813320E, 0xFD99DBF7, 0x32CCF151, 0x6FDD5C05
	},

	{
		0xF31F74FC, 0x5B939226, 0xD9D53A93, 0x3A273431, 
		0xEF296980, 0xF5412E1B, 0x4DF02F5B, 0xA4179950, 
		0x731CCC54, 0x4FF36FB0, 0x68459C3C, 0xD6B84245, 
		0x3B3C6C3F, 0x6D697176, 0xE9FBDA0D, 0xA03D888C, 
		0x4909A463, 0xAD14FFCF, 0x505ED35C, 0xC21FC657, 
		0x3DC31765, 0x92AAC442, 0xD341CC0F, 0x6C5BBAB1, 
		0xB8502A8B, 0x18A67A16, 0x8E2EB8B1, 0x78ACCA56, 
		0xD9A341F6, 0xE72BD561, 0x889A3CE9, 0xAE76C9C2, 
		0x8AE93753, 0xF9A98412, 0x933EF928, 0x3314A922, 
		0xF279492F, 0x4AE1499F, 0x1A1F4A53, 0x4B2BDD5B, 
		0x1FC5C7E7, 0x1EEAB635, 0xE9190AFA, 0x1B05337B, 
		0x78DC1ECF, 0xD07AD6A0, 0xC98650B7, 0xA7FFB330, 
		0x4EBA9C85, 0xD99CE128, 0xBC94E705, 0x4E829926, 
		0xA84ED58B, 0x874DD802, 0xF47628A3, 0x9CA58BB0, 
		0x0FA76581, 0xCC490CAC, 0xC391C24C, 0xA1DF2A2B, 
		0x038FCCBD, 0xFCD97DA4, 0xADE39237, 0xA004F9FF
	},

	{
		0x50EC499A, 0x57244DD1, 0x989DAB7C, 0x39943899, 
		0x0506EA3E, 0x62B98D9F, 0xD2602F70, 0x9BFB7CC1, 
		0x7E1DEC6D, 0xEA1614B0, 0x9A47DAB5, 0x2863A26D, 
		0x2E177B72, 0xDABC13E1, 0xE61AB6C9, 0x18D42B25, 
		0xCA795ACC, 0x664E849D, 0x9B597A60, 0x73F03242, 
		0xCB576344, 0x31253FEB, 0x173CE93B, 0x5E7238CA, 
		0xC0521EF1, 0x67767816, 0xF8F0AB0C, 0x860D3784, 
		0xE86BB2C3, 0x4754DDC7, 0x4E013AA1, 0xDC7E3630, 
		0xD7FA7EF2, 0x3ED76494, 0x897DF05F, 0xAF6D0BAF, 
		0xDF277D17, 0xD73D7EB6, 0xCE29640A, 0x1556B57A, 
		0x4CE3D7A2, 0xA0AA143B, 0x4E7036D0, 0x18FE8ABC, 
		0x3E8E47D1, 0xB42C78FD, 0x56516DC9, 0x6A2366E0, 
		0x454863EE, 0xEADC1C32, 0x06FDF69B, 0xBDC94E8B, 
		0x54144F7D, 0x454E3D51, 0x459683C2, 0xB55F7DBB, 
		0x1FAAFFB0, 0x097045AF, 0xEC1A0D56, 0x499B69A1, 
		0xE8B4269A, 0x78FA53DA, 0xFA3F866C, 0x36FAB278
	},

	{
		0x9A348CF3, 0xDE7E448B, 0xCF27554C, 0x2CFA638F, 
		0xCEA9243C, 0x27E2BB7E, 0x997E6C9E, 0x7EA514B9, 
		0xA8B716B9, 0x45E49D60, 0xF1FC5321, 0xA937BCF5, 
		0xC496971C, 0xC4B80B3B, 0x3206D1FB, 0x5670616B, 
		0xCA2DB3C3, 0x01EAFE8A, 0xBD174755, 0x0DD3D042, 
		0xB8591C80, 0x15B6F0FB, 0x23D3A6F7, 0x1DE910AA, 
		0x2F1A056A, 0x9714E13A, 0x0F17DE0E, 0xC8C48954, 
		0xE75A5034, 0x32D7A560, 0x72CB9C52, 0x62794B32, 
		0x98DE2EEE, 0x1140E617, 0x4CC1C405, 0x2C319BB2, 
		0x622AF9E9, 0x9D6ECA20, 0x7DD528A7, 0x6272DA54, 
		0x0EDBCF46, 0x4911DD6E, 0x89D4673F, 0x171F78B4, 
		0xBF20922B, 0xEB4FF37A, 0x069DF251, 0x377C8E42, 
		0xE5892067, 0x77FF3A2C, 0x9E4B9142, 0xAEED36BC, 
		0xD27C3989, 0xC01C2F8C, 0x59127E91, 0x214F868E, 
		0x0945B82A, 0x797203E6, 0xE3F125DF, 0x2A7FD03D, 
		0xC3E5D603, 0xF7CB6AAA, 0xCDD12B04, 0x8669DBCC
	},

	{
		0x69590D31, 0x16D9B0F1, 0x674B7BF3, 0xD76F69A7, 
		0xA66766B1, 0x7FEF1874, 0xF5B204C3, 0xDF548D7F, 
		0x41167C52, 0x321D609E, 0xAB6ED1D7, 0x027178D4, 
		0x89ADF27B, 0xB8E2B6DF, 0x19F76ABE, 0x41F7A411, 
		0xBD30CD84, 0x55D73E2E, 0x9EA86CD3, 0x4E3C73E9, 
		0xCD75DF37, 0x4C8180FE, 0xD90E1CD1, 0xD183DA5E, 
		0x52103498, 0x7A924A14, 0x74343213, 0x3EDC35CC, 
		0x63E7DD1C, 0x65364446, 0x05861C2B, 0xF2C67748, 
		0x2F58E1BB, 0x276DF71B, 0xA249122A, 0x67F0928B, 
		0x5E03001C, 0xEB9A0419, 0x9499CF06, 0xC6442C17, 
		0x983FE628, 0x2A7EF798, 0xB8306B58, 0xC10B4767, 
		0xA1EF9EBB, 0x5DA508B0, 0xE0698489, 0x502E2166, 
		0x1C0203E1, 0xED070148, 0x2FC4485E, 0x6FE5BB03, 
		0x426D5037, 0xC8B4F020, 0x029AEF51, 0xA3A66A3C, 
		0x5C117F3A, 0x14068942, 0x56DDD16C, 0xA7026955, 
		0xCB6BA5CE, 0xEB30E20B, 0x14EFDCEA, 0xB0E615EC
	},

	{
		0x5DEDF0A4, 0xB7D958A1, 0x5DE41621, 0xE6451281, 
		0x8988FBAB, 0xFFA12EF9, 0x4DD994BF, 0xB5AEA3D8, 
		0x45FD3758, 0x43552D82, 0xC63614C0, 0x4BB63A8E, 
		0x7E4FF025, 0xF1F1A3C4, 0x4363B994, 0x371DBCE8, 
		0x3BFFCA9C, 0x11A2FF9B, 0x5A694E9A, 0x033069E0, 
		0xF2E4CF8F, 0x5002250D, 0xE7911156, 0xAC1E0C0C, 
		0x4883A403, 0xF394E56E, 0x906FEE65, 0x66C4C893, 
		0x0DD9FCB5, 0x9347DDBB, 0x84E0477A, 0x087CD416, 
		0x8898C22D, 0x17030492, 0x290AEEE5, 0xD6E170C9, 
		0xCA1C9885, 0x7FCCCC08, 0x2E895D9F, 0x4D73C332, 
		0x0AB56CF9, 0x9F73F163, 0x2DC27FE5, 0xF917D52F, 
		0x0E965189, 0x124514A6, 0x3F504E11, 0x9F1EB4D9, 
		0x2D48917A, 0x7B9A80CE, 0xB19B3D07, 0xCD79E55F, 
		0x2EA71B3A, 0x365A6F84, 0x1CB15057, 0x72F0011C, 
		0xC049EB75, 0xE621EFBE, 0x842D9DBF, 0xA704E426, 
		0x9FE20D6E, 0x98524416, 0x3ECC79FC, 0x3B05F6A7
	},

	{
		0xB57B6D79, 0xD3DD2098, 0xAB159E6E, 0xDA63753B, 
		0x34C873EB, 0xFB55B708, 0x34CFFA24, 0x2D689DD9, 
		0x5F6A63FB, 0xAC862A1F, 0x111E4467, 0x6DDD5404, 
		0x20712442, 0xA291C35C, 0xF7C0C840, 0xF8B099AA, 
		0x2B428B60, 0xFC684FEB, 0x3DDE74F5, 0xD8101CD5, 
		0x0196DDC4, 0x2CF3F64F, 0x3927252D, 0x79FBDCDD, 
		0xE8555194, 0xA6B45FE7, 0x77355E02, 0xF007DC63, 
		0x1F01EAE1, 0x050B036D, 0x5B128D46, 0x0713409F, 
		0x4732CB7B, 0x00CF5262, 0x873B3BF5, 0x29CB2119, 
		0x9B1F6CEC, 0xC5F09BC5, 0xACFADC7B, 0x9AF997FE, 
		0xF3A80F72, 0x9AD8566A, 0x3A5846E4, 0xCE9957E7, 
		0x5A773A0D, 0x64D9DC1B, 0x14137768, 0xD5E2149D, 
		0xE11FAC72, 0xF141CB01, 0xD1DA5AC4, 0x876D6DF4, 
		0x3DA52A20, 0x79A1A38C, 0x52A8D32D, 0x4818FC2D, 
		0x72474A4D, 0x38C45617, 0x792ADBE2, 0x543EB6AF, 
		0xC967585B, 0xB9A99FB9, 0xB96BEAD2, 0x9DBF4552
	},

	{
		0x5F126D87, 0x209590FA, 0x90ED9298, 0xC5933CFC, 
		0xB1526FC5, 0x566FA246, 0x6F57234A, 0xFE0DA29C, 
		0x688DD003, 0xB35FDCFE, 0xD0046D83, 0x92277A7D, 
		0x6488800B, 0x15C8319F, 0x7449411C, 0xE1C619C5, 
		0x7A01905B, 0x19C28E70, 0xAA8C6CA1, 0xE016E8A3, 
		0x91BF3060, 0x6AD8A4BD, 0x36625121, 0x6D74365F, 
		0x95E0D370, 0x55AFED48, 0xEC9A0A00, 0xF3761CE3, 
		0x091D44C1, 0x83F6C456, 0xC28B4BDB, 0xF12FF37F, 
		0xCF3FA70A, 0xFDC369A6, 0x83C91DB0, 0x44D097C2, 
		0x0FBFB224, 0xF24ED416, 0x4F438995, 0x7B0FEAE6, 
		0x3943729E, 0x35F82C7A, 0x8A234F89, 0x80C91E1A, 
		0xEB1A1262, 0x978E78C6, 0x767B7DFB, 0x08F0DADE, 
		0x2DE99D20, 0x35FB22EB, 0x8BB0FD9F, 0x605EE2EA, 
		0xBEFF4C9D, 0x0FE77DA7, 0x500AE16A, 0x10D3482B, 
		0xA87187EB, 0x854027FC, 0x7C0FE08B, 0x34607ECF, 
		0xD0234C8C, 0xF6D73D2E, 0x0948578B, 0x74ACFEA8
	},

	{
		0x14454B76, 0x89C9C4FB, 0x4343E832, 0xEDFBCDAF, 
		0xD6AE6671, 0x31B22D7D, 0xDB9D415E, 0xD0D1E4FB, 
		0x73C35D86, 0x29695252, 0x99EE7F32, 0x232FEE60, 
		0x2B4FE03D, 0x59C92328, 0x43B7835A, 0x0AF1F352, 
		0x430D1D4B, 0x5F9E3619, 0x49D0BD47, 0xA3D6E289, 
		0x936636BD, 0x4FA1A859, 0x7A15317F, 0x93FBBE1C, 
		0x1FE45E6E, 0x4526CCDE, 0x07AA1600, 0x3F5DA670, 
		0xC05B6532, 0x9AF76BF2, 0x3A9A73F9, 0x13BD7268, 
		0x6BD8E37F, 0xFB96271E, 0x95014B60, 0xF4C7B5C3, 
		0x01D23DB6, 0x0B3F0A85, 0x4BCB4683, 0x597ED680, 
		0x53BFBB56, 0xB3D7D046, 0xF4B14E8A, 0xB60AE278, 
		0x4D29F5AE, 0x268AA1F4, 0xE28B5ACA, 0x29481E5A, 
		0x0BD29CE1, 0xC4ADD091, 0x21F11101, 0xAF182B94, 
		0x78C9DD4C, 0x0C59C5C6, 0xF484EAB5, 0x3AA65D4B, 
		0x387CF5A8, 0x7DEEEBE9, 0x92865FDC, 0x83650242, 
		0x83F4BBB4, 0x47CBDCCB, 0x1BB6C2EB, 0xD9DB0D93
	},

	{
		0x07E5E382, 0xAD974E9B, 0xF108F97A, 0xBC925B4C, 
		0x43FC2D0A, 0x2D2D16F4, 0xFC8E33C0, 0x5D905103, 
		0x09002E56, 0x342F3BA6, 0xC52F8051, 0xBCC7AFBD, 
		0xF44BCC8E, 0x9CF2BA63, 0x2AF62947, 0x6D32A4E2, 
		0x97CB4B7E, 0x7EB36969, 0x6C5A1BEF, 0x91DDABAF, 
		0xD19F38D1, 0x28168456, 0x18F5BFF7, 0xD942A200, 
		0xD74AC610, 0xA084BA17, 0x6209C788, 0x71298136, 
		0x2E478EB0, 0xC6FF24F1, 0x7FB12530, 0xB05DCEDD, 
		0x63CEE2B8, 0x9828CCA7, 0x74267745, 0xCE31CE0B, 
		0x7F5E241A, 0x9DD687D7, 0xF49A4001, 0x2079D26E, 
		0x77A7F9AB, 0xF018F8E6, 0x6732A7D8, 0x050FE733, 
		0x509F344C, 0xDDDAAA74, 0xBDE184D6, 0xCA198ED9, 
		0x0E013550, 0xF6AB7695, 0x81AB4084, 0x1E1FBE13, 
		0x74641C6F, 0xA42D6C69, 0x7A59A7DE, 0x97FE33E1, 
		0x22A5C0E7, 0x2DDAB736, 0x11E80476, 0xEB197C10, 
		0xEF2D5E0D, 0xA80ADF81, 0x01B6A52D, 0x3F60E848
	},

	{
		0x0591FA9E, 0xD84CCD30, 0xAF8645F3, 0xA8F14118, 
		0xEF4E2EB5, 0x1D7EBA58, 0xB1FC516B, 0x328E94D2, 
		0x98F01FE2, 0xA33BAE23, 0xFBFF78E2, 0x319FC7A0, 
		0xB4F9AD3D, 0x83354F5A, 0x822E27B5, 0x6E4D8FBF, 
		0x0DFD5C47, 0xED41261F, 0x7DF08357, 0xA54CF110, 
		0xBF7A0373, 0x3A899027, 0x679C2E1D, 0x902FB5D1, 
		0x937155EA, 0x0C11875D, 0x9AC4F3DD, 0xC0FCBCD2, 
		0xA317C764, 0x7D6106C2, 0x48931D7F, 0x8D38AD15, 
		0x1E5EEAF1, 0x799D6466, 0x120A0D78, 0xA358EF27, 
		0x8301E807, 0x41453072, 0x3DDDD84E, 0x67DAA5B7, 
		0xC4831F14, 0xB4FF3ECC, 0x54FBE1DF, 0xF487050B, 
		0xE23FC0CB, 0x4DA17492, 0xE21D074D, 0x78F519B4, 
		0x73641E6C, 0x471797DE, 0x0B9EF879, 0xCB34E343, 
		0x093C039B, 0x032C80AC, 0x8D71A4E8, 0x40EE5B0F, 
		0xFBDC92DD, 0x2C03A2BD, 0x4E40AB0C, 0x01AC0C5A, 
		0x3ADEC6DD, 0x450A4C28, 0xF246725D, 0x79CD91EB
	},

	{
		0x72ACDC1B, 0xF2014F34, 0xFA67FB76, 0x6C0951E3, 
		0xC84F7766, 0x0BF7F3E7, 0x5056038F, 0xB1773ABF, 
		0x40C2A3DD, 0xBC19DD18, 0x2DD4A6EC, 0x421E6F72, 
		0xDFE17CDB, 0xFE0B6A09, 0x3FA0C3EA, 0x1661B6A1, 
		0x40FEE764, 0x84B26A19, 0xF858D748, 0xCBF20F5F, 
		0xB83792BF, 0x83CE6144, 0x5B1C27E1, 0xBAD45539, 
		0xFC174283, 0xD8E4151B, 0x9C51B5A3, 0xA4CBB787, 
		0x829892B4, 0xB0DBB955, 0xAE9BF750, 0xD5EC9DE5, 
		0xBA425010, 0x5D401F05, 0xC1A67E17, 0xFF57C3B2, 
		0xD2F9FCF1, 0xFA92C983, 0xF4ECAC03, 0x01F39D8F, 
		0x85842BC7, 0x9AF22BFF, 0xA240C52A, 0xC92F7885, 
		0xCEC15E11, 0x9D12F7EC, 0x92912226, 0x622D12EC, 
		0xF1562785, 0x4DA4B897, 0x38B97ACC, 0xD7E70669, 
		0x5330B480, 0x821DC482, 0x446387E8, 0x26FFFE50, 
		0xF4B0E87A, 0x2BB8837C, 0x6839CEEA, 0xEA444EE6, 
		0x5635F0EE, 0x55CA3220, 0xDF276DDF, 0xBB90E015
	}
};

