*T1*
			Welcome to lesson T1.

In the T series of lessons, we will be learning to touch-type on the standard
keyboard.  I will introduce you to each letter on the keyboard, one at a time.
By the time you have completed this series, you will be able to type the entire
alphabet, the numbers, and most of the punctuation keys by touch.

If you have never taken any lessons in typing before, please be patient.  Typing
is not difficult but it does take a lot of practice.  Avoid the tendency to
look down at your fingers while typing.  This is a very bad habit and is hard
to break later.  If you hit the wrong key, I will let you know.  (But, I won't
tell anyone else, so don't worry about it.)

If you have always used the hunt-and-peck method, you will have an even harder
time keeping yourself from looking.  Don't be surprised if you find touch
typing slower than your old ways.  It may be slower when you first start.
But, touch typing is far faster once you get the hang of it.

If you can already touch type, you should be able to go through these lessons
fairly quickly.  Or, you may want to go directly to the S series.\T

			The HOME Keys.

In order to hit the correct keys by touch alone, you must always know where your
fingers are.  The way to do this is to have a special place for each finger.
This key is called the HOME position.

Place the first finger of your right hand on the J-key.  Now, place your second
finger on the K-key, your third finger on the L-key, and your fourth-finger on
the ;-key (the one with the : and ; on it).

Similarly place the four fingers of your left hand on the F, D, S, and A-keys.
Place your right thumb over the SPACE bar.  (Henceforth, always hit the SPACE
bar with this thumb.)  Now, lift all your fingers slightly so that they are
poised just over the keys.  Each finger should be just barely touching its home
key.  This is an electronic keyboard and does not take much pressure to ac-
cidentally press the key down.

Learn these positions well.  Whenever you are about to type a line, look at your
fingers and make sure they are in the HOME position.  Then don't look at them
again.\T

			DRILL PATTERNS

For the rest of this lesson, I will display a line of text in the middle of the
screen and instructions at the top of the screen.

All you have to do is type in the characters that you see in the middle of
the screen.  If you hit the correct key, I will not do anything.  If you make
a mistake, I will display a large X under the letter that you got wrong and 
beep the terminal. In either event, just keep going by typing the next letter.

When you have finished typing the line, hit the RETURN key.  To do this, extend
the little finger of your right hand over to the RETURN key.  Hit the key and
zip the finger back to its home position.  Be careful not to let your other
fingers move far from their home positions in the process.  Also, be careful
not to type an extra space at the end of the line.

If you made no mistakes on the line, I will display the next drill pattern.  If
you did make a mistake, I will beep at you and make you do the line again.  If
on the second try you made more than two mistakes, I will beep again and make
you try again, etc.  Don't forget to use your right thumb for the SPACE bar.\T
Hit the F-key four times with the first finger of your left hand.\I
ffff\D
Alternately, hit the F-key and the SPACE bar.\I
fff fff fff ff ff ff f f f\D
Don't look at your hands!\B
Hit the J-key with the first finger of your right hand.\I
jjj jjj jjj jj jj jj j j j\D
Use the left hand for the F and the right hand for the J.\I
fff jjj fff jj ff jj f j f j\D
Now intermix them.\I
ffjj jjff fjf fjf jfj jfj\D
Use the second finger of the left hand for the D-key.\I
ddd ddd ddd dd dd dd d d d\D
Use the second finger of the right hand for the K-key.\I
kkk kkk kkk kk kk kk k k k\D
\B
Now both.\I
ddd kkk dd kk dkd kdk ddd kkk\D
Use the third fingers of the each hand for the S and L-keys.\I
sss lll sss lll sss ss ll ss ll s l\D
Use the fourth fingers for the A and ;-keys.\I
aaa ;;; aaa ;;; aa ;; aa ;; a ;\D
That's enough keys for today.  Let's review them.\I
fff jjj ddd kkk sss lll aaa ;;;\D
Again.\I
fff jjj ddd kkk sss lll aaa ;;;\D
Try mixing them together.\I
asdf jkl; asdf jkl; asdf jkl;\D
And still more.\I
fjf kdk sls ;a;\D
Before, we finish, let's try some words.\I
sad add all; alas flask fad\D
How about a sentence.\I
ask a sad lad\D
Sentences are kind of limited with only one vowel!\I
dad asks a lad; a lass falls\D

*
*T2*
			     Lesson T2


In this lesson, we will review the letters that you have already practiced
and will add the letters E, G, and H and the period.

When you reach for any of these keys, be sure to return your finger to its
home position.  For example, to hit the H-key, move the first finger of your
right hand (the J-finger) slightly to the left.  Tap the H-key and immediately
bring your finger back over the J.

If you lose track of where your fingers are guess.  Don't look!\T
First let's review\I
fff jjj ddd kkk sss lll aaa ;;;\D
asdf jkl; fdsa ;lkj\
fjf jfj dkd kdk sls lsl a;a ;a;\
jkj jlj j;j fdf fsf faf\
a sad lass; ask dad;\D
Use your J-finger for the H key.\I
jjj jhj jjj jhj jjj jhj\D
jjj hhh jjj hhh jj hh j h j h\
jjj had jjj ash jjj has jjj\
jjj sash jjj hash jjj hall jjj\D
Use your F-finger for the G-key.\I
fff fgf fff fgf fff fgf\D
fff ggg fff ggg fff ggg\
fff gag fff lag fff flag fff\
fff sag fff slag fff hag fff\D
Use your D-finger for the E-key\I
ddd ded ddd ded ddd ded ddd\D
ddd eee ddd eee dd ee dd ee d e\
ddd fee ddd see ddd elf ddd\
lake asked fake gale egg\D
Use your K-finger for the comma.\I
kkk k,k kkk k,k kkk k,k\D
kkk ,,, kkk ,,, kkk ,,, kkk\D
Let's finish with some sentences.\I
a lad had a flask, dad had a keg\D
she had a fake egg, he had a salad\D
*
*T3*
				LESSON T3\B
Let's review first.\I
fff jjj ddd kkk sss lll aaa ;;;\D
fgf jhj ded k,k fgf jhj ded k,k\D
\B
Use your K-finger for the I key.\I
kkk kik kkk kik kkk iii kkk\D
kkk iii kkk iii kk ii kk ii\
kkk lid kkk hill kkk did kkk\
kkk kill kkk kid kkk like kkk\
kkk kiss kkk hide kkk fill kkk\D
Use your F-finger for the R key.\I
fff frf fff frf fff frf\D
fff rrr fff rrr ff rr ff rr\
fff rake fff rag fff her fff\
fff red fff read fff rage fff\
fff far fff red fff jar fff\D
fff fare fff rare fff rake fff\D
fff rid fff ire fff fair fff\D
Use your L-finger for the period.\I
lll l.l lll l.l lll l.l lll\D
lll ... lll ... ll .. ll .. l .\
lll adj. lll id. lll\
lll eg. lll i.e. lll\D
The next key we are going to practice is the right shift key.

Whenever you want to capitalize a key on the left side, you must use the
right shift-key.  To do so, follow these steps:

	a.)  Without moving your first finger from the J-key, swing the
	     fourth finger of your right hand over to the SHIFT-key and
	     hold it down.

	b.)  Strike the key that you want to type with your left hand.

	c.)  Immediately bring your fourth finger back to the ;-key.\T
Don't look at your fingers!\I
;;; ;A; ;;; ;F; ;;; ;D; ;;; ;S;\D
;;; Dear ;;; Sir ;;;\D
;;; Fred ;;; Gail ;;; Alf ;;; Dale ;;;\D
;;; Ada ;;; Al ;;; Greg ;;;\
jjj Dr. jjj Sr. jjj Fr. jjj\D
Let's try some (strange) sentences.\I
Sir, idle disks seek flags.\D
She sells seashells.\
Sailfish sail idle seas.\
She seeks a fig leaf.\
Red hair is like a fire.\D
Always double space after a period.\I
A free red jade is fake.  Girls like silk.\D
She seeks a safe reef, if she sails.  A gale is rare.\
Alf fed her egg salad.  Gail likes hash.\D
*
*T4*
				LESSON T4\B
First a quick review:\I
jkl; fdsa ded fgf jhj k,k kik frf l.l\D
\B
Use your L-finger for the O-key.\I
lll lol lll ooo lll lol\D
lll log lll rod lll for lll\
lll load lll roll lll oleo lll\
Use your ;-finger for the P-key.\I
;;; ;p; ;;; ppp ;;; ;p; ;;;\D
;;; pad ;;; peg ;;; ape ;;;\
;;; poke ;;; pear ;;; peek ;;;\
;;; opera ;;; hope ;;; drape ;;;\D
			The Left-Shift key.

To capitalize letters on the right-side of the keyboard:

	1.)  Move your A-finger to the LEFT-shift key and hold it down.

	2.)  Strike the key that you want to capitalize with your right hand.

	3.)  Immediately swing your A-finger back to its home position.\T
aaa Pi aaa Lord aaa Jill aaa\D
Try capitalizing each of the keys on the right-side:\I
Joe Kip Leif Peg Olaf Ira Heidi\D
Don't forget to use your right-shift key for letters on the left side:\I
a;a P.S. a;a I.R.S. a;a\D
Use your ;-finger for the ?-key.\I
;;; ;?; ;;; ??? ;;; ;?; ;;;\D
;;; He? ;;; She? ;;; I? ;;;\D
Let's try some sentences.\I
Dad fell off a ladder.  Is he safe?\D
Always double space after a question mark.\I
Is he here?  Sal said he fell hard.\D
Did she see his fall?  Jake heard he is OK.\
I hope people keep off high ladders.\D
*
*T5*
				 LESSON T5\B
As always, let's start with a review:\I
ade fgh ijk lop rs; ?.,\D
Again.\I
ade fgh ijk lop rs; ?.,\D
\B
Use your F-finger for the T-key.\I
fff ftf fff ttt fff ftf fff\D
ftf the ftf top ftf ate ftf\D
ftf three ftf often ftf there\D
The talk is that those three are threatening her.\D
Use your J-finger for the N-key.\I
jjj jnj jjj nnn jjj jnj jjj\D
jnj not jnj ton jnj one jnj\
jnj neither jnj opening jnj kneeling jnj\
No one has an interest in it.\D
Use your ;-finger for the :-key.\I
;;; ;:; ;;; ::: ;;; ;:; ;;;\D
Always double space after a colon.\I
Dear Sirs:  Dear John:  Dear Alfred:\D
Dear Dr. Stone:  To Heathkit:\D
			SPEED EXERCISES

From now on, I will be mixing speed exercises in with the lessons.  In the
drills that you have been doing, I make you keep practicing a line until
you get it right.  In a speed exercise, I will only display the text once.

What will be different is that I will be timing you.  From the time you type
the first letter of the line until you hit the final carriage return, my
stopwatch will be running.  When you finish, I will calculate your typing speed
and convert it to words per minute (WPM).  I will also count each of the
mistakes you make and display the total number of errors.

If you make a mistake, I will beep at you and light up the letter that you
should have typed in inverse video (a black letter on a white background).
Just keep going and try to make as few errors as possible.\T
Try this sentence:\I
Sarah has liked knitting all her life.\P
Try a little longer sentence.\I
She looked past her garden to the fields and longed to see the other side.\P
When you type a multi-line paragraph, you will have to hit the RETURN-key at
the end of each line.\I
All the sane people in this area sold their gold
right at the start.  The insane ones held their
gold and later it paid off.\P
One fine afternoon the king had an idea.  He
sent a letter to all the lords and ladies of
his land.  He asked for a great feast.  His
people prepared roasts.  His jester did a jig.
All the people left hoping to do it again.\P
*
*T6*
				LESSON T6\B
Let's review the letters we've already learned.\I
jkj fdf jlj fsf j;j faf kik ded frf\D
fgf jhj k,k l.l A;A F;F E;E\
lol ;p; JaJ :a: ftf jnj ;:;\
jug ton knot poison the neither often\D
\B
Use your F-finger for the B-key.\I
fff fbf fff bbb fff fbf fff\D
The B-key is the longest reach we've seen so far.  Let's try it again.\I
fff fbf fff bbb fff fbf fff\D
frf bar frf rib frf pub frf\
frf bring frf abort frf brother frf\
Use your J-finger for the U-key.\I
jjj juj jjj uuu jjj juj jjj\D
juj jug juj use juj hug juj\
juj tulip juj turn juj under juj\
Please pass the butter and salt, but not the pepper.\D
Use your ;-finger for the /-key.\I
;;; ;/; ;;; /// ;;; ;/; ;;;\D
;/; n/a ;/; and/or ;/; left/right\
In this era of E.R.A., I hope he/she likes his/her job.\
He/she should bring his/her spouse at about noon or just before.\
Should I be here alone?  Is Bernie and/or Julie going to be here, too?\D
Try your speed on some paragraphs:\I
All bills are to be paid in full.  If
there is no fee to be paid, return the
bill and put n/a in the total due part.\P
You should be aiming for 15 WPM.  (If you did better, work on accuracy.)\I
In baseball, bunting is a kind of hit.  But, bunting also
refers to a kind of bird and the stuff that is used in
flags.  English sure is a strange language.\P
*
*T7*
			     Lesson T7\B
First a review of the letters we've learned before:\I
juj ded kik frf lol fgf ;p; jhj\D
ftf jnj ftf jnj fbf juj ;?; l.l k,k\D
\B
Use your D-finger for the C-key.\I
ddd dcd ddd ccc ddd dcd\D
ddd cat ddd cup ddd can\
dcd duck dcd card dcd pack dcd\
dcd crate dcd scrap dcd trick dcd\D
Use your J-finger for the M-key\I
jjj jmj jjj mmm jjj jmj jjj\D
jjj met jjj rim jjj map jjj\
jmj man jmj men jmj ham jjj\
jmj Mr. jmj Mrs. jmj Ms. jmj\
jmj number jmj stream jmj mankind jmj\D
Use your ;-finger for the hyphen.\I
;;; ;-; ;;; --- ;;; ;-; ;;; ;-;\D
;;; one-third ;;; one-half ;;; three-fifths ;;;\
;;; part-time ;;; self-made ;;; all-American ;;;\D
Let's try some sentences:\I
Peter Piper picked a peck of pickled peppers.\D
Motion pictures often depict macabre scenes.\D
Once upon a time, marriages lasted longer than mortgages.\D
There are three uses of the hyphen.  It can be used to combine two words:\I
She had on a bluish-green dress.  But, no one noticed.\D
To divide a word:\I
At macrame class last night, I made a hanging basket for the philo-
dendron in our dining room.\P
Or, to form a dash:\I
Fifteen dollars a month--measured in current dollars--is a good rate.\D
Let's try a speed drill on these sentences:\I
The clock ran out, signaling the end of
the second-half.  The game had been lost.\P
The paper just made an announce-
ment about a commotion at the
college.  Someone has just
produced a micro-organism in the
DNA-research lab.  It is a
special kind of bacteria that
consumes crude oil.  The talk is
that it is being patented for use
on oil spills at sea.\P
Hit the return key twice for blank lines:\I
Dear Mr. Mandrake:

All of us appreciated the fine performance of those magic
tricks.  Please arrange to come to another of our meet-
ings, if possible.  Perhaps our Christmas meeting?

Thanks,

Mrs. Carmichael\P
*
*T8*
			  LESSON T8\B
As always, we will start with a quick review\I
jfj dkd lsl a;a dcd jmj ;-; fbf juj\D
\B
Let's try some long words.\I
meteorology camera bituminous chimera phosphates\D
Use your S-finger for the W-key.\I
sss sws sss www sss sws sss\D
sss wet sss who sss was sss\D
sws who sws what sws when sws where sws\
knowledge whatever Wimbleton know-it-all\D
How much wood could a woodchuck chuck if a
woodchuck could chuck wood?  A woodchuck
would chuck all the wood that a woodchuck
could chuck, if a woodchuck could chuck wood.\P
Use your J-finger for the Y-key.\I
jjj jyj jjj yyy jjj jyj jjj\D
jjj why jjj you jjj try jjj rye jjj\
jjj year jjj July jjj your jjj jury jjj\
Were your yard sales much better last year?\D
Try your speed on this sentence:\I
Why are you typing so slowly?\P
Use your F-finger for the V-key.\I
fff fvf fff vvv fff fvf fff\D
fff vat fff eve fff vow fff\D
fvf vine fvf dove fvf ever fvf very fvf\D
driven verticle advent ventrical\
What a fine vineyard you have.\
Do you intend to play adventure every night?\D
			THE BACKSPACE

Most of the programs that you use will allow you to correct your mistakes by
using the BACKSPACE and/or DELETE keys.  These keys will generally delete the
previous character that you typed.  (This feature is one of the principal
advantages of a word-processing system over a conventional typewriter.)

I refuse to accept either of these keys during a drill pattern.  (You should
keep practicing until you get it right!)  But, I will accept either a BACK-
SPACE or a DELETE during a speed drill.  (I will remove the white error
markers but I still count it as an error in my totals.)

If you do chose to use the DELETE or BACKSPACE keys, hit the key with your
;-finger and immediately return your fingers to the home position.\T
Let's try our speed on some nursery rhymes!\I
Mary had a little lamb
Its fleece was white as snow
And every where that Mary went
The lamb was sure to go.\P
Jack and Jill went up a hill to fetch a pail of water.
Jack fell down and broke his crown and Jill came tumbling after.\P
Little Miss Muffet sat on a tuffet
Eating her curds and whey.
Along came a spider
Who sat down beside her
And frightened Miss Muffet away.\P
Hey, diddle diddle--
The cat and the fiddle
The cow jumped over the moon.
The little dog laughed to see such sport,
And the dish ran away with the spoon.\P
*
*T9*
			    LESSON T9\B
First, a review.\I
a;a sls dkd fjf sws jyj fvf dcd jmj ;-;\D
\B
Notice that the only letters left to go are the Q, X, and Z!\I
abcdefghijklmnoprstuvwy\D
Use your A-finger for the Q-key.\I
aaa aqa aaa qqq aaa aqa aaa\D
aaa quit aaa quad aaa quip aaa\
lacquer inquiry squirt quart\
quail quiver inquest marquis\
Use your S-finger for the X-key.\I
sss sxs sss xxx sss sxs sss\D
sss ax sss ox sss vex sss wax xxx\
examine ex-wife excellent boxer sixteen\
exactly sphinx oxygen except thorax\
Use your A-finger for the Z-key.\I
aaa aza aaa zzz aaa aza aaa\D
aaa adz aaa azo aaa coz aaa\
quiz jazz quartz zinc dozen\
oxidize squeeze azimuth zoology\D
The big event!!!!!!!!!!!!!!!!!!\I
abcdefghijklmnopqrstuvwxyz\D
zyxwvutsrqponmlkjihgfedcba\
Let's try some sentences:\I
A dozen zebras were grazing quietly nearby.\D
The zeppelin zigzagged quickly from the horizon up to the zenith.\D
Never trust a quack doctor who cannot distinquish oxygen from nitrogen.\D
Imagine having a sextet of sexagenarian sextons?\D
Remember when queer used to mean zany?\
Quartz crystal watches were at one time extremely expensive.\D
Let's try a sentence that contains every letter of the alphabet.\I
A quick brown fox jumped over the lazy dogs.\D
Again,\I
A quick brown fox jumped over the lazy dogs.\D
See how fast you can type it this time:\I
A quick brown fox jumped over the lazy dogs.\P
Again,\I
A quick brown fox jumped over the lazy dogs.\P
*
*T10*
			      LESSON T10\B
Let's review the entire alphabet before starting the number keys.\I
abcd efg hijk lmnop qrs tuv wx yz\D
\B
Once more\I
abcdefghijklmnopqrstuvwxyz\D
Use the shift key for each letter (Do not use the CAPS LOCK key)\I
ABCDEFGHIJKLMNOPQRSTUVWXYZ\D
Now, review the punctuations that you've had.\I
l;l l:l k,k l.l ;/; ;?; :?: ;-;\D

			NUMERIC KEYS

The terminal has two sets of numeric keys.  One set--directly above the
alphabetic keys--conforms to the standard for typewriter keyboards.  The other
set--to your right--resembles a calculator keypad.  In this typing series we
will be concerned only with the standard numeric keys on the main keyboard.
(If you would like to learn to touch type on a numeric keypad, use the N-series
lessons instead.)

NOTE - not all terminals have the numeric keys in a separate keypad

The numeric keys, like all the keys you will be learning from now on, vary
somewhat from machine to machine.  The 2 through 0 keys are always in exactly
the same place on all typewriter keyboards.  (On keypunch machines and some
terminals, however, they are located over the U, I, O, J, K, L, M, comma and
period keys.  We will not be concerned with these layouts in this series.)
Even if a typewriter or terminal has the standard 2 through 0 keys, it may not
have a 1 key.  If it does, the 1 will always be next to the 2.  If it does not,
you will have to use the L-key.\T
Let's start by using the 1-key, since we have one.  (Use your A-finger.)\I
aaa a1a aaa 111 aaa a1a\D
a1q qa1 qz1 az1 aq1 a1z\
111 and 111 ate 111 any 111\
If 11 men each catch 11 fish in 11 days, how many fish were caught?\D
Use your S-finger for the 2-key.\I
sss s2s sss s2s sss s2s\D
sss s2w sss 2xw sss w2x sss\
222 saw 222 was 222 wet 222\
The 2 men were 2 late 2 catch the 2 PM train.\
Use your D-finger for the 3-key.\I
ddd d3d ddd d3d ddd d3d ddd\D
ddd d3e ddd d3c ddd e3c ddd\
333 did 333 cat 333 eat 333\
1 plus 2 is 3.  11 plus 22 is 33.  111 plus 222 is 333.\D
The last number we will practice today is the 4-key.  (Use your F-finger.)\I
fff f4f fff f4f fff f4f\D
fff f4r fff 4vr fff 4vr fff\
444 for fff rat 444 vet 444\
Flight 423 leaves from gate 42 at 4:24.\
As the 3 musketeers say: 1 4 all, and all 4 1.\
If 1/4 plus 2/3 is 11/12, what is 1/2 plus 1/3?\D
Try your speed on this line:\I
Our team won 1st, 2nd, and 3rd place at the 12th annual outing.\P
As we stated earlier, many typewriters do not have a 1 key.  Let's practice
using the L-key as a 1, so you can use any kind of typewriter.\I
One dozen is l2.  A gross is l2 dozen or l44.\D
In both octal and decimal, ll times ll is l2l.  And, 3 minus 4 is -l.\
But in octal, l2 is not divisible by 3.\D
*
*T11*
			       LESSON 11\B
Let's review the numbers that you have already learned.\I
a1a s2s d3d f4f 234 413\D
f4r d3e s2w a1q az1 sx2 dc3 fv4\D
\B
Use your J-finger for the 7-key\I
jjj j7j jjj j7j jjj j7j jjj\D
jjj j7u jjj 7um jjj u7m jjj\
777 map 777 jug 777 rum 777\
Is flight number 377 for Florida a 707, a 727 or a 747?\
It is a 727 with 4 stops.  With all those stops it takes almost 7 hours.\D
Use your K-finger for the 8-key.\I
kkk k8k kkk k8k kkk k8k kkk\D
kkk k8i kkk 8,i kkk ,i8 kkk\
888 kick 888 sink 888 keep 888\
Agent 88 was supposed to check in at 8:14.  She is 38 minutes late.\
Her team was assigned to zone 8 of quadrant 828.  Send 8 more agents.\D
Use your L-finger for the 9-key.\I
lll l9l lll l9l lll l9l lll\D
lll 9.o lll o9. lll l9. lll\
999 Jr. 999 log 999 old 999\
Oh, 99 bottles of beer on the wall, 99 bottles of beer.\
If 9 of us take 9 each, there will still be 18 left for the song.\D
Use your ;-finger for the 0-key.\I
;;; ;0; ;;; ;0; ;;; ;0; ;;;\D
;;; ;0p ;;; /0p ;;; 0/p ;;;\
000 a/c 000 pup 000 me? 000\
Dear Sirs:  The 10:00 meeting on March 10 has been postponed until 10:30.\
The 10:30 meeting was moved to 11:00 in Room 302.\
But, Room 302 can only hold 10 people.  We will need Conference Room 10.\D
Let's try some paragraphs.\I
Zip codes are arranged so that the first 3 digits
designate the regional office and the last 2
digits designate the local branch.  The numbering
is roughly east to west.  That is, numbers
starting with 0 are in New England, numbers
starting with 1 are the New York area, etc.
There are notable exceptions to this rule,
however.  The Virgin Islands are south of
Florida, but their Zip Codes start with 00.\P
The new nine digit zip codes have upset quite a
few people.  It was bad enough being referred to
as 73218.  But now, we will have to remember
numbers like 73218-4208.  The worst hit will be
the companies whose mailing list programs were
poorly designed.  Those unstructured programs
will be very difficult to change.\P
*
*T12*
			Lesson T12\B
Let's review the numbers that you have learned so far.\I
j7j f4f k8k d3d l9l s2s ;0; a1a\D
4f4 7j7 3d3 8k8 2s2 9l9 1a1 0;0\D
\B
Use your F-finger for the 5-key.\I
fff f5f fff 555 fff f5f fff\D
f5f f54 f5f t5g f5f t5r f5f\
f5f five f5f two f5f four f5f\
f5f 453 f5f 585 f5f 475 f5f\D
The 5 of us each carried 50 pound packs all 45 miles of the trip.\P
And now, the longest reach of all!  Use your J-finger for the 6-key.\I
jjj j6j jjj 666 jjj j6j jjj\D
j6j June j6j much j6j hum j6j\
j6j y6n j6j u6m j6j h76 j6j\
j6j 4567 j6j 7654 j6j 6754 j6j\D
The open parenthesis is the shift of the 9-key.  (Use your L-finger).\I
lll l(l lll ((( lll l(l lll\D
l(l (.l l(l 9(9 l(l\D
l(l loop l(l oil l(l only l(l\D
The close parenthesis is the shift of the 0-key.  (Use your ;-finger).\I
;;; ;); ;;; ;); ;;; ;);\D
;;; (.) ;;; (.) ;;; (,) ;;;\
;); pole ;); loop ;); pile ;);\D
You (the buyer) should ask him (the seller) for the price (of the goods).\D
If (X-5) / (X-6) is 56, then what is (X/5) - (X/6)?\D
1 2 3 4 5 6 7 8 9 10\D
Try your speed on this song.\I
1 little, 2 little, 3 little Indians,
4 little, 5 little, 6 little Indians,
7 little, 8 little, 9 little Indians,
10 little Indian boys.\P
If we want to catch the 6:15 flight to Phoenix (which is the
non-stop), we will have to leave by 5:00 at the latest (in
case we run into traffic).  Otherwise, we will have to take
the 6:45 flight (which makes 5 stops).\P
Use the main keyboard keys.  Don't cheat and use the auxilliary keypad!\B
Try entering straight numbers: \I
423 475 925 235 295 175 650\D
\B
598 693 602 672 315 604 587 307\D
12.00 67.50 99.95 38.75 19.99\D
Now let't try for some speed.\I
353 648 604 592 468 501 296\P
3574
1937
2586
1904
1837
9003
7283
6745\P
*
*T13*
			Lesson T13

There is no Lesson 13!  Don't you know that 13 is an unlucky number?

If you have completed Lessons T1 through T12, then you are now ready
to call yourself a touch typist.  You have learned to touch type all
of the keys which are standardized!  You can now begin the SPEED
series of lessons if you would like.  (If you come across a punctua-
tion symbol which you have not learned, simply look for it.  Use the
appropriate finger for the shifted numeric keys.  Use your ;-finger
for all the keys on the right-hand side.)

We will practice touch typing on the keyboard layout for the remaining
lessons.\T
*
*T14*
			    Lesson 14\B
Use your ;-finger for the apostrophe.\I
;;; ;'; ;;; ''' ;;; ;'; ;;;\D
\B
;'; it's ;'; 'till ;'; won't ;';\D
;'; 'tis ;'; isn't ;'; 'tis too ;';\
What's this I've got?  Isn't this yesterday's paper?  Where's today's?\
Can't you find anything?  It's right next to Dad's chair.\D
Shift the apostrophe for the quote key.\I
;;; ;"; ;;; """ ;;; ;"; ;;;\D
;"; "." ;"; ":" ;"; "," ;";\
"What was that I saw you take from the teacher desk?" asked Tom.\
"It's the answers to tomorrow's quiz", answered Suzy.\
"If you promise not to tell," she continued, "I'll give you a copy."\D
Use your A-finger for the exclamation point.\I
aaa a!a aaa !!! aaa a!a aaa\D
a!a Ah! a!a What! a!a Oh! a!a\D
Always double space after an exclamaion point.\I
Tomorrow's quiz!  What if we get caught?  We'll be expelled!\D
He'll never suspect a thing!  We'll get some answers wrong to fool him.\D
*
*T15*
			      Lesson T15\B


In this lesson we will be practicing the special symbols which you will need
for BASIC or other programming languages.  I won't give you too much practice
with these symbols right now.  (You should be able to get plenty of exercise by
simply typing in programs.)\T
\B
Use your ;-finger for the equals key.\I
;;; ;=; ;;; ;=; ;;; ;=; ;;;\D
;=; -=- ;=; '=' ;=; :=: ;=;\
;=; X=2 ;=; Y=3 ;=; Z=0 ;=;\D
Use your K-finger for the asterisk key.\I
kkk k*k kkk k*k kkk k*k kkk\D
k*k 3*2 k*k 5*6 k*k 9*7 k*k\
k*k i*i k*k *,* k*k 8*8 k*k\D
Use your ;-finger for the plus sign.\I
;;; ;+; ;;; ;+; ;;; ;+; ;;;\D
;+; 2+4 ;+; 7+5 ;+; 8+0 ;+;\
;+; +=+ ;+; -+- ;+; /+/ ;+;\D
Use your L-finger for the greater-than key.\I
lll l>l lll l>l lll l>l lll\D
l>l X>3 l>l Y>7 l>l Z>0 l>l\
l>l >>> l>l 9>9 l>l .>. l>l\D
Use your K-finger for the less-than key.\I
kkk k<k kkk k<k kkk k<k kkk\D
k<k X<0 k<k Y<2 k<k Z<8 k<k\
k<k <.> k<k >.< k<k <<< k<k\D
Use your J-finger for the up-arrow key.\I
jjj j^j jjj ^^^ jjj j^j jjj\D
j^j X^2 j^j Y^3 j^j Z^4 j^j\
j^j <^> j^j .^. j^j "^" j^j\D
Try entering this BASIC program:\I
10 LET x=10
20 LET y=20
30 PRINT x+y/3
40 PRINT y/x*5
50 STOP\P
And another:\I
10 REM Program to find square roots with using ^.5 feature
20 INPUT "What number do you want the square root of? ";s
30 x = 2
40 y = s/x
50 x = (x+y)/2
60 IF ABS(x^2 - s) > s/1000 THEN 40
70 PRINT "The square root of ";s;" is ";x
80 STOP\P
Press down the CAPS LOCK key to simplify typing in this BASIC program:\I
100 REM PROGRAM TO SOLVE QUADRATIC EQUATION
125 PRINT "ENTER THE VALUES OF A, B, AND C WHERE:"
150 PRINT
175 PRINT "AX^2 + BX + C = 0"
200 INPUT A,B,C
210 IF A = 0 THEN 400
225 D = B^2 - 4*A*C
250 IF D < 0 THEN 500
275 PRINT "ONE ROOT IS: ";-B+SQR(D)/2/A
300 PRINT "THE OTHER IS: ";-B-SQR(D)/2/A
325 STOP
400 PRINT "NOT A QUADRATIC.  TRY AGAIN."
425 GOTO 100
500 PRINT "COMPLEX ROOTS.  TRY AGAIN."
525 GOTO 125\P
*
*T16*
			      Lesson T16


In this lesson we will be practicing the shifted numeric keys on the
terminal keyboard.  I will only be giving you practice in the keystroke
motions.  Very few sentence drills or speed exercises are included, since these
keys are used so infrequently.

If you are typing something which includes one of these special characters and
you cannot remember where a key is, look.  But, always make sure to hit the key
with the correct finger.  (If you do use the key often, you will eventually
learn where it is without looking.)  Since these keys are used infrequently and
are in different places on most other keyboards or are totally missing, speed
is not important.\T
Use your S-finger for the at-sign.\I
sss s@s sss s@s sss s@s sss\D
s@s at@ s@s w@x s@s S@w s@s\
s@s wax s@s mix s@s @we s@s\D
Use your D-finger for the pound-sign (also called the number-sign).\I
ddd d#d ddd d#d ddd d#d ddd\D
d#d d#e d#d 3#c d#d #c# d#d\
d#d cat d#d dog d#d eat d#d\D
Use your F-finger for the dollar-sign.\I
fff f$f fff f$f fff f$f fff\D
f$f r$v f$f v$4 f$f 4$r f$f\
f$f rave f$f fare f$f $10.00 f$f\
Joe keeps cryptic inventory bills like:  4# @ $5.00/# or 6# @ $4.50/#.\D
Use your F-finger for the percent sign as well.\I
fff f%f fff f%f fff f%f fff\D
f%f 12% f%f 10% f%f 20% f%f\
f%f two f%f ran f%f bug f%f\
If a $25.00 item is sold at a 10% discount, it will cost $22.50.\
But, a 10% markup on a item selling for $22.50 is only $24.75!  How come?\D
Use your J-finger for the ampersand.\I
jjj j&j jjj j&j jjj j&j jjj\D
j&j 2&4 j&j 9&5 j&j 7&7 j&j\D
j&j you&me j&j he&she j&j M&M j&j\D
				THE END

You have now completed the T-series of these lessons.  If you have not already
done so, you should now start the N-series or S-series.

There are a few keys which we have not studied.  If you decide to touch-type
these keys, use the closest finger.  Thus, the ESC, TAB, CAPS LOCK, and SCROLL
keys use the A-finger.  And, the keys to the far right (BACKSPACE, DELETE, LINE
FEED, RETURN, }, {, etc.) use the ;-finger.  The upper keys (f1, f2, etc.) are
not usually touch typed as the reach is too far.  If you can, fine.

The CONTROL and REPEAT keys are difficult to touch type, but are treated like
the SHIFT keys whenever possible.  For example, to REPEAT an exclamation point,
hold the REPEAT key down with your ;-finger and then hit the ! with your A-
finger.  Certain command sequences, such as Control/S, are hard to do this way.
Many people simply hold the CONTROL-key down with their A-finger and then hit
the other key with whatever finger is convenient (usually the F-finger in this
case).\T
*
