/*
**
** INIT.C
**
*/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "oids.h"
#include "bitmaps.h"

struct linkage link = { 0 };

/*
** MAIN_MENU
**
*/
void main_menu()
{

	int slc, c, y, i;

	X_frontbuf();
	X_clear();

	slc = 1;

	do {

		X_color(BLUE);

		X_string("X  O  I  D  S  !", (int) (vdevice.sizeSy / 5));

		for (i=0;i<mm_num_items;i++) {
			if (i == slc) {
				X_color(WHITE);
			} else {
				X_color(RED);
			}
			y = (int) (vdevice.sizeSy / 3 + (vdevice.sizeSy / 20) * i);
			X_string(mm_items[i], y);
		}

		c = X_get_menu_keys();

		switch (c) {

		case UPARROW:
			if (--slc < 0) slc = mm_num_items - 1;
			break;
		case DOWNARROW:
			if (++slc > mm_num_items - 1) slc = 0;
			break;
		default:
			break;
		}

		if (c == ENTER && slc == 3) {
			options_menu();
			c = 0;
		}

		X_update(0);

	} while (c != ENTER);

	switch (slc) {

	case 0:
		num_players = 1;
		P->lives = 5;
		P->next = P->next_draw = NULL;
		coop = 0;
		break;
	case 1:
		num_players = 2;
		P->next = P->next_draw = &P[1];
		coop = 0;
		break;
	case 2:
		num_players = 2;
		P->next = P->next_draw = &P[1];
		coop = 1;
		P->x = (int) link.length * sin(link.ang) + link.x;
		P->y = (int) link.length * cos(link.ang) + link.y;
		P->next->x = link.x - (int) link.length * sin(link.ang);
		P->next->y = link.y - (int) link.length * cos(link.ang);
		break;
	case 3:
		break;
	case 4:
		X_exit();
		exit(0);
		break;
	default:
		break;
	}

	X_clear();
	X_backbuf();

} /* end MAIN_MENU */



/*
** OPTIONS_MENU
**
*/
void options_menu()
{

	int slc, c, y, i, goal;
	char spd_str[6], gs[50], *erase_str;

	X_frontbuf();
	X_clear();

	slc = 0;
	goal = goal_score;

	do {

		X_color(BLUE);

		X_string("O P T I O N S", (int) (vdevice.sizeSy / 5));
		X_string("(Use arrow keys and ENTER to select)", (int) (vdevice.sizeSy / 5 + 25));

		sprintf(spd_str, "%d%%", 100 - (int) (delay / 20));
		sprintf(gs, "%s", goal_str[goal]);

		for (i=0;i<om_num_items;i++) {
			if (i == slc) {
				X_color(WHITE);
			} else {
				X_color(RED);
			}
			y = (int) (vdevice.sizeSy / 3 + (vdevice.sizeSy / 10) * i);
			X_string(om_items[i], y);

			if (i == 0) X_string(spd_str, y + (int) (vdevice.sizeSy / 20));
			if (i == 1) X_string(gs, y + (int) (vdevice.sizeSy / 20));

		}

		c = X_get_menu_keys();

		switch (c) {

		case UPARROW:
			if (--slc < 0) slc = om_num_items - 1;
			break;
		case DOWNARROW:
			if (++slc > om_num_items - 1) slc = 0;
			break;
		case LEFTARROW:
			if (slc == 0 && delay < 2000) {
				delay += 20;
				erase_str = spd_str;
			}

			if (slc == 1) {
				if (--goal < 0) goal = 3;
				erase_str = gs;
			}

			break;
		case RIGHTARROW:
			if (slc == 0 && delay > 0) {
				delay -= 20;
				erase_str = spd_str;
			}

			if (slc == 1) {
				if (++goal > 3) goal = 0;
				erase_str = gs;
			}

			break;
		default:
			break;
		}

		if (slc < 2 && (c == LEFTARROW || c == RIGHTARROW)) {
			y = (int) (vdevice.sizeSy / 3 + (vdevice.sizeSy / 10) * slc);
			X_color(BLACK);
			X_string(erase_str, y + (int) (vdevice.sizeSy / 20));
		}

		X_update(0);

	} while (!(c == ENTER && slc == om_num_items-1));

	goal_score = goal;

	X_clear();

} /* end OPTIONS_MENU */


/*
** INIT_ALL_OBJECTS
**
*/
void init_all_objects(pass)
int pass;
{

	int i,j;


	/* Call the "random" number generator a few times */

	for (i=0;i<30;i++) r_num = random_num(0.0, 1.0);


	/* Starfield */

	init_starfield();

	/* Link */

	link.length = LINK_LENGTH;
	link.ang = PI / 4;
	link.ang_vec = 0.0;
	link.x = vdevice.sizeSy / 2;
	link.y = vdevice.sizeSx / 2;
	link.x_vec = 0.0;
	link.y_vec = 0.0;

	/* Shards */


	for (j=0;j<4;j++) {

		if (!pass) Shrd[j] = init_object(NUM_SHARDS, MAPS_PER_360, shard1_xpm);

		for (i=0;i<NUM_SHARDS;i++) {
			Shrd[j][i].x = random_num(0.0, (float) vdevice.sizeSx);
			Shrd[j][i].y = random_num(0.0, (float) vdevice.sizeSy);
			Shrd[j][i].rotation = i*2+1;
			Shrd[j][i].max_dying = (unsigned int) random_num((float) CARNAGE_LIFE, (float) (CARNAGE_LIFE - CARNAGE_LIFE / 2));
			Shrd[j][i].kill_func = kill_shard;
			Shrd[j][i].mass = 0.2;
			Shrd[j][i].burst_color = CYAN;
			if (j == 1) {
				Shrd[j][i].pixmap_data[0] = shard2_xpm;
				Shrd[j][i].burst_color = RED;
			} else if (j == 2) {
				Shrd[j][i].pixmap_data[0] = wreck1_xpm;
				Shrd[j][i].burst_color = GREEN;
			} else if (j == 3) {
				Shrd[j][i].pixmap_data[0] = bolt_xpm;
				Shrd[j][i].burst_color = BLUE;
			}
		}

		if (!pass) X_spin_pixmap360(Shrd[j]);

	}


	/* Player */


	if (!pass) P = init_object(MAX_PLAYERS, MAPS_PER_360, player1_xpm);

	for (i=0;i<MAX_PLAYERS;i++) {
		P[i].x = random_num(0.0, (float) vdevice.sizeSx);
		P[i].y = random_num(0.0, (float) vdevice.sizeSy);

		P[i].kill_func = explode_object;
		if (!pass) P[i].death_sprite = Shrd[i];
		P[i].num_death_sprites = NUM_SHARDS;
		P[i].max_exploding = CARNAGE_LIFE + 25;
		P[i].max_dying = DYING_TIME;
		P[i].max_speed = P_MAX_SPEED;
		if (!pass) P[i].S = init_shots();
		P[i].shot_color = P[i].burst_color = CYAN;
		P[i].value = 500;
		P[i].score = 0;
		P[i].shots_fired = 0;
		P[i].shots = 0;
		P[i].hits = 0;
		if (!pass) sprintf(P[i].name, "Player %d", i+1);
		

	}

	if (!pass) X_spin_pixmap360(P);

	P[1].pixmap_data[0] = player2_xpm;
	if (!pass) X_spin_pixmap360(P->next);
	P[1].shot_color = P[1].burst_color = YELLOW;
			

	/* Slurb */


	if (!pass) Slrb = init_object(1, MAPS_PER_360, slurb_xpm);

	Slrb[0].x = random_num(0.0, (float) vdevice.sizeSx);
	Slrb[0].y = random_num(0.0, (float) vdevice.sizeSy);

	Slrb[0].kill_func = explode_object;
	if (!pass) Slrb[0].death_sprite = Shrd[2];
	Slrb[0].num_death_sprites = NUM_SHARDS;
	Slrb[0].max_exploding = CARNAGE_LIFE + 25;
	Slrb[0].max_dying = DYING_TIME;
	Slrb[0].max_speed = P_MAX_SPEED;
	if (!pass) Slrb[0].S = init_shots();
	Slrb[0].shot_color = Slrb[0].burst_color = GREEN;
	Slrb[0].value = 500;
	Slrb[0].score = 0;
	Slrb[0].shots_fired = 0;
	Slrb[0].shots = 0;
	Slrb[0].hits = 0;
	Slrb[0].state = DEAD;
	if (!pass) sprintf(Slrb[0].name, "Slurb");
		
	if (!pass) X_spin_pixmap360(Slrb);


	/* Homer */

	if (!pass) Homer = init_object(1, MAPS_PER_360, homer_xpm);

	Homer[0].x = random_num(0.0, (float) vdevice.sizeSx);
	Homer[0].y = random_num(0.0, (float) vdevice.sizeSy);

	Homer[0].kill_func = destroy_homer;
	if (!pass) Homer[0].death_sprite = NULL;
	Homer[0].num_death_sprites = 0;
	Homer[0].max_exploding = 0;
	Homer[0].rotation = 0;
	Homer[0].max_dying = 0;
	Homer[0].max_speed = H_MAX_SPEED;
	if (!pass) Homer[0].S = NULL;
	Homer[0].shot_color = Homer[0].burst_color = RED;
	Homer[0].value = 800;
	Homer[0].score = 0;
	Homer[0].shots_fired = 0;
	Homer[0].shots = 0;
	Homer[0].hits = 0;
	Homer[0].state = DEAD;
	if (!pass) sprintf(Homer[0].name, "Homer");
		
	if (!pass) X_spin_pixmap360(Homer);


	/* Resurrector */

	if (!pass) Resur = init_object(1, MAPS_PER_360, resurr_xpm);

	Resur[0].x = random_num(0.0, (float) vdevice.sizeSx);
	Resur[0].y = random_num(0.0, (float) vdevice.sizeSy);

	Resur[0].kill_func = explode_object;
	if (!pass) Resur[0].death_sprite = Shrd[3];
	Resur[0].num_death_sprites = NUM_SHARDS;
	Resur[0].max_exploding = CARNAGE_LIFE + 25;
	Resur[0].rotation = 0;
	Resur[0].max_dying = 0;
	Resur[0].max_speed = P_MAX_SPEED;
	if (!pass) Resur[0].S = NULL;
	Resur[0].shot_color = Resur[0].burst_color = BLUE;
	Resur[0].value = 400;
	Resur[0].score = 0;
	Resur[0].shots_fired = 0;
	Resur[0].shots = 0;
	Resur[0].hits = 0;
	Resur[0].state = DEAD;
	if (!pass) sprintf(Resur[0].name, "Resurrector");
		
	if (!pass) X_spin_pixmap360(Resur);


	/* Flame */

	if (!pass) Flame = init_object(1, 2, flame1_xpm);

	Flame[0].kill_func = NULL;
	if (!pass) Flame[0].death_sprite = NULL;
	Flame[0].num_death_sprites = 0;
	Flame[0].max_exploding = 0;
	Flame[0].rotation = 0;
	Flame[0].max_dying = 0;
	Flame[0].max_speed = 0;
	if (!pass) Flame[0].S = NULL;
	Flame[0].shot_color = Flame[0].burst_color = BLACK;
	Flame[0].value = 0;
	Flame[0].score = 0;
	Flame[0].shots_fired = 0;
	Flame[0].shots = 0;
	Flame[0].hits = 0;
	Flame[0].state = NORMAL;
	if (!pass) sprintf(Flame[0].name, "Flame");
	Flame[0].pixmap_data[1] = flame2_xpm;


	/* Power Up */


	if (!pass) Power_Up = init_object(1, 2, laser1_xpm);

	Power_Up[0].x = random_num(0.0, (float) vdevice.sizeSx);
	Power_Up[0].y = random_num(0.0, (float) vdevice.sizeSy);

	Power_Up[0].kill_func = destroy_object;
	if (!pass) Power_Up[0].death_sprite = NULL;
	Power_Up[0].num_death_sprites = 0;
	Power_Up[0].max_exploding = 0;
	Power_Up[0].max_dying = 0;
	Power_Up[0].max_speed = P_MAX_SPEED;
	Power_Up[0].rotation = SML_OID_ROT;
	if (!pass) Power_Up[0].S = NULL;
	Power_Up[0].shot_color = Power_Up[0].burst_color = GREEN;
	Power_Up[0].value = 0;
	Power_Up[0].score = 0;
	Power_Up[0].shots_fired = 0;
	Power_Up[0].shots = 0;
	Power_Up[0].hits = 0;
	Power_Up[0].state = DEAD;
	if (!pass) sprintf(Power_Up[0].name, "Power Up");

	Power_Up[0].pixmap_data[1] = laser2_xpm;


	/* Metamorphosis */

	if (!pass) Meta = init_object(1, 1, meta_xpm);

	Meta[0].x = random_num(0.0, (float) vdevice.sizeSx);
	Meta[0].y = random_num(0.0, (float) vdevice.sizeSy);

	Meta[0].kill_func = destroy_object;
	if (!pass) Meta[0].death_sprite = NULL;
	Meta[0].num_death_sprites = 0;
	Meta[0].max_exploding = 0;
	Meta[0].max_dying = 0;
	Meta[0].max_speed = P_MAX_SPEED;
	Meta[0].rotation = 0;
	if (!pass) Meta[0].S = NULL;
	Meta[0].shot_color = Meta[0].burst_color = BLUE;
	Meta[0].value = 0;
	Meta[0].score = 0;
	Meta[0].shots_fired = 0;
	Meta[0].shots = 0;
	Meta[0].hits = 0;
	Meta[0].state = DEAD;
	if (!pass) sprintf(Meta[0].name, "Metamorphosis");



	/* Small Oids */


	for (j=0;j<MAX_BIG_OIDS * OID_DIVIDE;j++) {

		if (!pass) Sml_O[j] = init_object(OID_DIVIDE, OIDS_PER_360, sml_oid_xpm);

		for (i=0;i<OID_DIVIDE;i++) {

			Sml_O[j][i].y_vec = 4.0 * random_num(-2.0, 2.0);
			Sml_O[j][i].x_vec = 4.0 * random_num(-2.0, 2.0);

			Sml_O[j][i].rotation = SML_OID_ROT;
			Sml_O[j][i].max_speed = SO_MAX_SPEED;
			Sml_O[j][i].state = NORMAL;

			Sml_O[j][i].kill_func = destroy_oid;

			Sml_O[j][i].curr_map = (int) random_num(0.0, (float) OIDS_PER_360 - 2);
			Sml_O[j][i].mass = 1;

			Sml_O[j][i].value = 400;

			Sml_O[j][i].burst_color = WHITE;

		}

		if (!pass) X_spin_pixmap360(Sml_O[j]);

	}



	/* Medium Oids */


	for (j=0;j<MAX_BIG_OIDS;j++) {

		if (!pass) Med_O[j] = init_object(OID_DIVIDE, OIDS_PER_360, med_oid_xpm);

		for (i=0;i<OID_DIVIDE;i++) {

			Med_O[j][i].y_vec = 2.0 * random_num(-2.0, 2.0);
			Med_O[j][i].x_vec = 2.0 * random_num(-2.0, 2.0);

			Med_O[j][i].rotation = MED_OID_ROT;
			Med_O[j][i].max_speed = MO_MAX_SPEED;
			Med_O[j][i].state = NORMAL;

			Med_O[j][i].kill_func = destroy_oid;

			if (!pass) Med_O[j][i].death_sprite = Sml_O[j * OID_DIVIDE + i];
			Med_O[j][i].num_death_sprites = OID_DIVIDE;
			Med_O[j][i].max_exploding = 2000;
	
			Med_O[j][i].curr_map = (int) random_num(0.0, (float) OIDS_PER_360 - 2);
			Med_O[j][i].mass = 3;

			Med_O[j][i].value = 200;

			Med_O[j][i].burst_color = WHITE;

		}

		if (!pass) X_spin_pixmap360(Med_O[j]);

	}




	/* Big Oids */


	if (!pass) Big_O = init_object(MAX_BIG_OIDS, OIDS_PER_360, big_oid_xpm);


	for (i=0;i<MAX_BIG_OIDS;i++) {

		/* Don't want oids TOO close to player at start! */

		Big_O[i].x = random_num(0.0, (float) vdevice.sizeSx);
		Big_O[i].y = random_num(0.0, (float) vdevice.sizeSy);

		Big_O[i].y_vec = random_num(-2.0, 2.0);
		Big_O[i].x_vec = random_num(-2.0, 2.0);

		Big_O[i].rotation = BIG_OID_ROT;
		Big_O[i].max_speed = BO_MAX_SPEED;
		Big_O[i].state = NORMAL;

		Big_O[i].kill_func = destroy_oid;

		if (!pass) Big_O[i].death_sprite = Med_O[i];
		Big_O[i].num_death_sprites = OID_DIVIDE;
		Big_O[i].max_exploding = 2000;

		Big_O[i].curr_map = (int) random_num(0.0, (float) OIDS_PER_360 - 2);
		Big_O[i].mass = 5;

		Big_O[i].value = 100;

		Big_O[i].burst_color = WHITE;

	}

	for (i=INIT_BIG_OIDS;i<MAX_BIG_OIDS;i++) Big_O[i].state = DEAD;

	if (!pass) {
		X_spin_pixmap360(Big_O);
	}


} /* end INIT_ALL_OBJECTS */


/*
** INIT_OBJECT
**
**	Sets default properties of an object.
*/
Sprite *init_object(elems, n_maps, data)
int elems, n_maps;
char **data;
{

	int i;
	Sprite *obj_ptr;

	obj_ptr = (Sprite *) calloc(elems, sizeof(Sprite));

	for (i=0;i<elems;i++) {

		sscanf(data[0], "%d %d", &obj_ptr[i].width, &obj_ptr[i].height);

		obj_ptr[i].ho2 = obj_ptr[i].height / 2;
		obj_ptr[i].wo2 = obj_ptr[i].width / 2;

 		obj_ptr[i].pixmap_data = (char ***) calloc(n_maps, sizeof(char **));
		obj_ptr[i].pixmaps = (Pixmap *) calloc(n_maps, sizeof(Pixmap));
		obj_ptr[i].clipmasks = (Pixmap *) calloc(n_maps, sizeof(Pixmap));
		obj_ptr[i].pixmap_data[0] = data;
		obj_ptr[i].num_pixmaps = n_maps;

		obj_ptr[i].delta_angle = (2*PI) / obj_ptr[i].num_pixmaps;

		obj_ptr[i].num_members = elems;

		obj_ptr[i].mass = 1;

		obj_ptr[i].wpn = GUN;

		obj_ptr[i].max_speed = 50;

		obj_ptr[i].rot_dir = 2 * (int)(random_num(0.8, 2.2)) - 3;

		if (i>0) {
			obj_ptr[i-1].next = obj_ptr[i-1].next_draw = &obj_ptr[i];
		}

	}

	return(obj_ptr);

} /* end INIT_OBJECT */


/*
** INIT_SHOTS
**
*/
struct Shot **init_shots()
{
	int i;
	struct Shot **sh;

	sh = (struct Shot **) calloc(10, sizeof(struct Shot *));

	for (i=0;i<10;i++) {
		sh[i] = (struct Shot *) calloc(1, sizeof(struct Shot));
	}

	return(sh);

} /* end INIT_SHOTS */



/*
** INIT_STARFIELD
**
*/
void init_starfield()
{

	int i;

	for (i=0;i<NUM_STARS;i++) {
		starfield[i].x = (int) random_num(0.0, 600.0);
		starfield[i].y = (int) random_num(0.0, 400.0);
	}

} /* end INIT_STARFIELD */
