/*
  MLRawReader.h

  Copyright (C) 1997-1998  Stephane Rehel

  December 14 1997
*/

#ifndef __MLRawReader_h
#define __MLRawReader_h

#include <stdio.h>

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/////////////////////////////////////////////////////////////////////////////

class MLRawReader
{
public:
  struct Spectrum
    {
    float r, g, b;
    };

  struct Vertex
    {
    float x, y, z; // location
    float nx, ny, nz; // normal (normalized)
    Spectrum* lighting; // nPools long

    Vertex()
      {
      lighting= 0;
      }
    ~Vertex()
      {
      delete [] lighting;
      lighting= 0;
      }
    };

  struct Polygon
    {
    int nVertices;
    int* vertices;

    Polygon()
      {
      nVertices= 0;
      vertices= 0;
      }
    ~Polygon()
      {
      delete [] vertices;
      vertices= 0;
      }
    };

  struct Object
    {
    char* name;

    int nVertices;
    Vertex* vertices;

    int nPolygons;
    Polygon* polygons;

    Object()
      {
      name= 0;

      nVertices= 0;
      vertices= 0;

      nPolygons= 0;
      polygons= 0;
      }

    ~Object()
      {
      delete [] polygons;
      polygons= 0;

      delete [] vertices;
      vertices= 0;

      delete name;
      name= 0;
      }
    };

protected:
  int nObjects;
  int nPools;
  Object* objects;

  FILE* file;

  bool verbose;

public:
  MLRawReader( FILE* _file, bool _verbose = FALSE );

  ~MLRawReader();

  void clear();

protected:
  char* get_line();
  bool get_integer( int* i );

public:
  bool read();

protected:
  bool readObject( int object_index );

public:
  int getNObjects() const
    {
    return nObjects;
    }

  // 0 <= i < nObjects
  Object* getObject( int i ) const;
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLRawReader_h
