// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLImageReader.C

  Stephane Rehel

  August 12 1997
*/

#include <string.h>
#include <errno.h>

#include "MLImageReader.h"

#include "pnm/MLImageReaderPNM.h"
#include "gif/MLImageReaderGIF.h"
#include "tga/MLImageReaderTGA.h"
#include "rgb/MLImageReaderRGB.h"
#include "bmp/MLImageReaderBMP.h"
#include "jpg/MLImageReaderJPG.h"
#include "tif/MLImageReaderTIF.h"

/////////////////////////////////////////////////////////////////////////////

MLImageReader::MLImageReader()
{
  file= 0;
  error= "";
}

/////////////////////////////////////////////////////////////////////////////

MLImageReader::~MLImageReader()
{
  close();
}

/////////////////////////////////////////////////////////////////////////////

IBOOL MLImageReader::available() const
{
  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

void MLImageReader::close()
{
  if( file != 0 )
    {
    fclose(file);
    file= 0;
    }
}

/////////////////////////////////////////////////////////////////////////////

IBOOL MLImageReader::open( const OString& filename )
{
  close();
  error= "";

  file= fopen( filename.get(), "rb" );
  if( file == 0 )
    {
    error= strerror(errno);
    return IFALSE;
    }

  return ITRUE;
}

/////////////////////////////////////////////////////////////////////////////

IBOOL MLImageReader::read( MLImage* )
{
  error= "no reader available?!";

  return IFALSE;
}

/////////////////////////////////////////////////////////////////////////////

// static
MLImageReader* MLImageReader::getReader( MLImageFormat::FORMAT fmt )
{
  switch(fmt)
    {
    case MLImageFormat::PNM:
      return new MLImageReaderPNM;

    case MLImageFormat::GIF:
      return new MLImageReaderGIF;

    case MLImageFormat::TGA:
      return new MLImageReaderTGA;

    case MLImageFormat::RGB:
      return new MLImageReaderRGB;

    case MLImageFormat::BMP:
      return new MLImageReaderBMP;

    case MLImageFormat::JPG:
      return new MLImageReaderJPG;

    case MLImageFormat::TIF:
      return new MLImageReaderTIF;

    default:
      break;
    }

  return 0;
}

/////////////////////////////////////////////////////////////////////////////

// static
MLImageReader* MLImageReader::guessReader( const OString& filename )
{
  return getReader( MLImageFormat::getFromFilename(filename) );
}

/////////////////////////////////////////////////////////////////////////////
