// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLStatusBars.C

  Stephane Rehel

  December 8 1996
*/

#include "MLStatusBars.h"

#include "graphics/mlgl.h"
#include "graphics/SoftWindow.h"
#include "graphics/SystemWindow.h"
#include "graphics/MLEvent.h"

#include "MLStatusLine.h"

/////////////////////////////////////////////////////////////////////////////

MLStatusBars::MLStatusBars()
{
  window= 0;
  line1= line2= 0;
}

/////////////////////////////////////////////////////////////////////////////

MLStatusBars::~MLStatusBars()
{
  delete line2; line2= 0;
  delete line1; line1= 0;
  delete window;
  window= 0;
}

/////////////////////////////////////////////////////////////////////////////
#include "MLStatusLineText.h"
MLStatusLineText* text= 0;
void MLStatusBars::create( SystemWindow* root,
                           const IPoint& position, const IVector& size )
{
  if( window != 0 )
    return; // nimporte koi

  window= new SoftWindow;
  window->create( root, position.x(), position.y(), size.x(), size.y() );
  window->setEventHandler(this);

  int lineHeight= MLStatusLine::getHeight();

  line1= new MLStatusLine( window,
                           IPoint(2,2), size.x()-3 );

  line2= new MLStatusLine( window,
                           IPoint(2,2+lineHeight+1), size.x()-3 );

/*
text= new MLStatusLineText(line1,20,MLStatusLineItem::RIGHT,IFALSE);
text->setMessage("kiki",1);
text= new MLStatusLineText(line1,3,MLStatusLineItem::RIGHT,IFALSE);
text->setMessage("ABC",1);
text= new MLStatusLineText(line1,3,MLStatusLineItem::RIGHT,IFALSE);
text->setMessage("XYZ",1);
text= new MLStatusLineText(line1,3,MLStatusLineItem::RIGHT,IFALSE);
text->setMessage("JKP",1);

text= new MLStatusLineText(line1,20,MLStatusLineItem::LEFT,IFALSE);
text->setMessage("kiki",1);
text= new MLStatusLineText(line1,3,MLStatusLineItem::LEFT,IFALSE);
text->setMessage("ABC",1);
text= new MLStatusLineText(line1,3,MLStatusLineItem::LEFT,IFALSE);
text->setMessage("XYZ",1);
text= new MLStatusLineText(line1,3,MLStatusLineItem::LEFT,IFALSE);
text->setMessage("JKP",1);

text= new MLStatusLineText(line1,20,MLStatusLineItem::LEFT,1+IFALSE);
line1->finalize();
text->setMessage("coucou",0);
*/
}

/////////////////////////////////////////////////////////////////////////////

void MLStatusBars::map( IBOOL yes /* = ITRUE */ )
{
  if( window != 0 )
    window->map(yes);
}

/////////////////////////////////////////////////////////////////////////////

void MLStatusBars::postRedraw()
{
  if( window == 0 )
    return;
  if( ! window->mapped() )
    return;

  window->postRedraw();
  line1->postRedraw();
  line2->postRedraw();
}

/////////////////////////////////////////////////////////////////////////////

void MLStatusBars::draw()
{
  if( window == 0 )
    return;
  if( ! window->mapped() )
    return;

  const IVector& size= window->getSize();

  window->currentPixel();
  mlFront();

  mlDarkGray();
  mlRect( 1, 0, size.x()-1, size.y()-2 );
  int lineHeight= MLStatusLine::getHeight();
  mlLine( 1, 1+lineHeight, size.x()-1, 1+lineHeight );

  mlLightGray();
  mlLine( 0, size.y()-1, size.x()-1, size.y()-1 );
  mlLine( 0, 0, 0, size.y()-1 );
}

/////////////////////////////////////////////////////////////////////////////

IBOOL MLStatusBars::eventHandler( MLWindow* w, MLEvent& e )
{
  if( w != window || window == 0 )
    return IFALSE;

  if( e.type == MLEvent::REDRAW )
    {
    draw();
    return ITRUE;
    }

  return IFALSE;
}

/////////////////////////////////////////////////////////////////////////////
