// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  Popup.C

  Stephane Rehel
  August 12 1996
*/

#include <stdlib.h>

#include "koala/VDialog.h"
#include "koala/VCard.h"
#include "kw/KWDialog.h"

#include "Canvas.h"
#include "GWidget.h"
#include "PopupDlg.h"

/////////////////////////////////////////////////////////////////////////////

IBOOL Canvas::popupCallback( KWEvent& e )
{
  switch( e.type )
    {
    case KWEvent::SELECT:
      {
      switch( e.widget )
        {
        case PopupDlg::create:
          {
          const OString& widgetName= e.dialog->getText(PopupDlg::widgetsList);
          if( widgetName == "Label" ) { newLabel(); break; }
          if( widgetName == "Button" ) { newButton(); break; }
          if( widgetName == "CheckBox" ) { newCheckBox(); break; }
          if( widgetName == "Edit" ) { newEdit(); break; }
          if( widgetName == "ValueEdit" ) { newValueEdit(); break; }
          if( widgetName == "RadioButton" ) { newRadioButton(); break; }
          if( widgetName == "Vert Bar" ) { newVertBar(); break; }
          if( widgetName == "Horiz Bar" ) { newHorizBar(); break; }
          if( widgetName == "TextBox" ) { newTextBox(); break; }
          if( widgetName == "List" ) { newList(); break; }
          if( widgetName == "Horiz Line" ) { newHorizLine(); break; }
          if( widgetName == "Vert Line" ) { newVertLine(); break; }
          if( widgetName == "Group" ) { newGroup(); break; }
          if( widgetName == "Area" ) { newArea(); break; }
          if( widgetName == "Progress Bar" ) { newProgress(); break; }
          if( widgetName == "Range Bar" ) { newRangeBar(); break; }
          if( widgetName == "Value Bar" ) { newValueBar(); break; }
          if( widgetName == "Picture" ) { newPicture(); break; }
          if( widgetName == "Chooser" ) { newChooser(); break; }
          break;
          }

        case PopupDlg::newDialog:
          {
          dialogPosition= IPoint(100+100,50);
          dialogSize= IVector(400,300);

          frame= ITRUE;
          killButton= ITRUE;
          title= OString("DialogTitle");
          C_filename= "";
          h_filename= "";
          name= "";
          filename= OString("noname") + canvasExtension;

          validateCancel= ITRUE;
          validateID= 0;
          cancelID= 0;

          create();
          draw();
          break;
          }
        case PopupDlg::load: readCanvas(); break;
        case PopupDlg::save: writeCanvas(filename); draw(); break;
        case PopupDlg::saveAs: writeCanvas(); break;
        case PopupDlg::dialog: editDialogAction(); break;
        case PopupDlg::widget: editWidget(); break;
        case PopupDlg::centerAll: centerAllWidgets(); break;
        case PopupDlg::prefs: editPrefs(); break;
        case PopupDlg::alignWidget: editAlign(); break;
        case PopupDlg::available: availableWidgets(); break;
        case PopupDlg::duplicate: duplicateWidgets(); break;
        case PopupDlg::deleteWidget: deleteWidgets(); break;
        case PopupDlg::raiseWidget: raiseWidgets(ITRUE); break;
        case PopupDlg::lowerWidget: raiseWidgets(IFALSE); break;
        case PopupDlg::groupWidgets: groupWidgets(); draw(); break;
        case PopupDlg::ungroupWidgets: ungroupWidgets(); draw(); break;

        case PopupDlg::quit: exit(0); break;

        case PopupDlg::grid:
          granularity= e.dialog->getChecked(PopupDlg::grid)
                       ? defaultGranularity
                       : 1;
          break;

        case PopupDlg::card:
          {
          const OString& text= popup->getText(PopupDlg::card);

          if( text == getCardName(0) )
            {
            setActiveCard(0);
            draw();
            break;
            }

          SIListIterator<GWidget> li(widgets);
          while( ! li.eol() )
            {
            GWidget* gw= li.next();
            if( gw->widget == 0 || !gw->isCard )
              continue;
            VCard* c= (VCard*) gw->widget;
            if( text == getCardName(c) )
              {
              setActiveCard(c);
              draw();
              break;
              }
            }
          break;
          }

        case PopupDlg::newCard:
          {
          newCard();
          break;
          }
        case PopupDlg::insertCard:
          {
          if( activeCard != 0 )
            newCard(ITRUE);
          break;
          }
        case PopupDlg::editCard:
          {
          editCard();
          break;
          }
        case PopupDlg::deleteCard:
          {
          deleteCard();
          break;
          }
        };
      break;
      }
    default:
      break;
    }
  return IFALSE;
}

/////////////////////////////////////////////////////////////////////////////

void Canvas::createPopup()
{
  delete popup; popup= 0;

  popup= new KWDialog;

  popup->create( root, 20, 40, PopupDlg::data, (KWCallbackClass*)this );
  setGranularity(granularity);
  setActiveCard(0);
  popup->setInteger( PopupDlg::widgetsList, 1 );
}

/////////////////////////////////////////////////////////////////////////////

void Canvas::setGranularity( int g )
{
  if( popup != 0 )
    {
    if( g == 1 )
      popup->setChecked( PopupDlg::grid, IFALSE );
     else
      popup->setChecked( PopupDlg::grid, ITRUE );
    }

  granularity= g;
}

/////////////////////////////////////////////////////////////////////////////


void Canvas::setActiveCard( VCard* card )
{
  activeCard= card;

  if( popup != 0 )
    popup->setText( PopupDlg::card, getCardName(card) );

  if( dialog != 0 && card != 0 )
    dialog->setActiveCard(card);

  popup->setAvailable( PopupDlg::insertCard, card!=0 );
  popup->setAvailable( PopupDlg::deleteCard, card!=0 );
  popup->setAvailable( PopupDlg::editCard, card!=0 );
}

/////////////////////////////////////////////////////////////////////////////

void Canvas::sortCards()
{
  int n= popup->getListLength(PopupDlg::card);
  while( n-- )
    popup->deleteListText(PopupDlg::card,1);

  popup->appendListText(PopupDlg::card,getCardName(0));

  int x= cardsRectangle.p1().x()+1;

  SIListIterator<GWidget> li(widgets);
  while( ! li.eol() )
    {
    GWidget* gw= li.next();
    if( gw->widget == 0 || !gw->isCard )
      continue;
    VCard* c= (VCard*) gw->widget;

    // ooooh disguuusting:-;
    VCard* dummy= new VCard(dialog);
    dummy->create( 0, 0, 0, 0, gw->message );
    IVector size= dummy->getSize();
    delete dummy; dummy= 0;

    c->setWidgetPosition( IPoint(x,cardsRectangle.p1().y()) );
    c->setSize(size);
    c->changeMessage(c->getMessage());
    gw->position= c->getPosition();
    gw->size= c->getSize();
    x+= size.x();

    popup->appendListText(PopupDlg::card,getCardName(c));
    }

  setActiveCard(activeCard);
}

/////////////////////////////////////////////////////////////////////////////
