// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoCommand.h

  Stephane Rehel

  October 25 1997
*/

#ifndef __PhotoCommand_h
#define __PhotoCommand_h

#ifndef __OString_h
#include "tools/OString.h"
#endif

#ifndef __MLCommand_h
#include "interface/MLCommand.h"
#endif

class PhotoModule;

/////////////////////////////////////////////////////////////////////////////

class PhotoCommand: public MLCommand
{
public:
  static int BASE;

public:
  int index;

//  Vector v;
//  IntegerArray indices;

  OString string;

  PhotoCommand* undo;

public:
  PhotoCommand()
    {
    MLCommand::base= BASE;

    undo= 0;

    index= 0;
    }

  virtual ~PhotoCommand()
    {
    if( undo != 0 )
      {
      unref(undo);
      undo= 0;
      }
    }

  virtual PhotoCommand* createUndo( PhotoCommand* cmd = 0 );

  virtual MLCommand* getUndo()
    {
    return undo;
    }

  static void initPhotoCommands();

  // return ITRUE if implemented
  virtual IBOOL doit( PhotoModule* photo );
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __PhotoCommand_h
