// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  MLTextGenerate.h

  Stephane Rehel

  February 8 1998
*/

#ifndef __MLTextGenerate_h
#define __MLTextGenerate_h

#ifndef __IBOOL_h
#include "tools/IBOOL.h"
#endif

#ifndef __GLTTGlyphTriangulator_h
#include "GLTTGlyphTriangulator.h"
#endif

class OString;
class MLPolygonArray;
class GLTTFont;
class MeshRep;

/////////////////////////////////////////////////////////////////////////////

class MLTextGenerate
{
protected:
  int nVertices;
  int nTriangles;
  IBOOL count_triangles;

  int triangle_index;
  MLPolygonArray* polygons;

public:
  MLTextGenerate();

  virtual ~MLTextGenerate();

  IBOOL generate( MeshRep* mesh,
                  const OString& text,
                  GLTTFont& font,
                  double precision );

protected:
  void triangle( FTGlyphVectorizer::POINT* p1,
                 FTGlyphVectorizer::POINT* p2,
                 FTGlyphVectorizer::POINT* p3 );

  friend class MLGlyphTriangulator;
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __MLTextGenerate_h
