/*
	Copyright (c) 1997,1998 Eugene G. Crosser
	Copyright (c) 1998 Bruce D. Lightner (DOS/Windows support)

	You may do virtually what you wish with this software, as long
	as the explicit reference to its original author is retained.

	THIS SOFTWARE IS PROVIDED AS IS AND COME WITH NO WARRANTY OF ANY
	KIND, EITHER EXPRESSED OR IMPLIED.  IN NO EVENT WILL THE
	COPYRIGHT HOLDER BE LIABLE FOR ANY DAMAGES RESULTING FROM THE
	USE OF THIS SOFTWARE.
*/

#include "eph_io.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

static void deferrorcb(int errcode,char *errstr) {
	fprintf(stderr,"Error %d: %s\n",errcode,errstr);
}

static void *defrealloccb(void *old,size_t length) {
	if (old) return realloc(old,length);
	else return malloc(length);
}

static void defruncb(size_t count) {
	return;
}

eph_iob *eph_new(void (*errorcb)(int errcode,char *errstr),
		void *(*realloccb)(void *old,size_t length),
		void (*runcb)(size_t count),
		int (*storecb)(char *data,size_t size),
		int debug) {
	eph_iob *iob;

	iob=(eph_iob *)malloc(sizeof(eph_iob));
	if (!iob) return iob;
	if (errorcb) iob->errorcb=errorcb;
	else iob->errorcb=deferrorcb;
	if (realloccb) iob->realloccb=realloccb;
	else iob->realloccb=defrealloccb;
	if (runcb) iob->runcb=runcb;
	else iob->runcb=defruncb;
	if (storecb) iob->storecb=storecb;
	else iob->storecb=NULL;
	iob->debug=debug;
#if defined(MSWINDOWS)
	iob->fd=INVALID_HANDLE_VALUE;
	memset((char*)&iob->savedcb,0,sizeof(iob->savedcb));
	memset((char*)&iob->savetimeouts,0,sizeof(iob->savetimeouts));
#elif defined(UNIX)
	iob->fd=-1;
	memset((char*)&iob->savetios,0,sizeof(iob->savetios));
#elif defined(DOS)
	iob->fd=-1;
#else
#error "platform not defined"
#endif
	return iob;
}

void eph_free(eph_iob *iob) {
	free(iob);
}
