.TH sane-umax 5 "22 October 1997"
.IX sane-umax
.SH NAME
sane-umax - SANE backend for Umax scanners
.SH DESCRIPTION
The
.B sane-umax
library implements a SANE (Scanner Access Now Easy) backend that
provides access to some Umax scanners.  At present, the following
scanners are known positively to work with this backend, at least a bit:
.PP
.RS
Vendor   Product id:     Remark:
.br
-------- --------------  -----------
.br
UMAX     Vista-S6         all modes ok
.br
UMAX     Vista-S6E        RGB only in preview-mode
.br
UMAX     UMAX S-6E        RGB only in preview-mode
.br
UMAX     UMAX S-6EG       RGB only in preview-mode
.br
UMAX     Vista-S8         don't know, please mail
.br
UMAX     UMAX S-12        all modes ok
.br
UMAX     UMAX S-12G       all modes ok
.br
UMAX     Vista-T630       all modes ok
.br
UMAX     SuperVista S-12  all modes ok
.br
UMAX     PSD              all modes ok
.br
UMAX     PL-II            don't know, please mail
.br
UMAX     Astra 600S       rgb-mode doesn't work (?)
.br
UMAX     Astra 1200S      all modes ok
.br
UMAX     UC630            requires special firmware-version
.br
UMAX     UC840            requires special firmware-version
.br
UMAX     UG630            requires special firmware-version
.br
LinoHell Office           (LinoTypeHell Jade) all modes ok
.RE
.PP
If you own a Umax scanner other than the ones
listed above, it may or may not work with SANE!
If the scanner gives enough information to the driver,
there is only a warning printed and you may continue, BUT AT
YOUR OWN RISK! If the scanner does not give enough information
then it will not work and an error-message is printed!

.SH "FRONTEND OPTIONS"
This backend dynamically enabeles the options for the frontend,
that are supported by the scanner in dependence of the scanning-mode
and other options. Not supported options are disabled.
.br
The following otions are supported by the Umax-driver:
.br
analog gamma, highlight, shadow, contrast, brightness,
threshold, digital gamma curve,
quality calibration (WARNING: hangs driver and scsi-bus),
scan-speed (advanced), smearing (advanced), negative scan,
transparency adapter (UTA), automatic document feeder (ADF)

.SH "PATCHES"
Patches are listed under advanced options:
.br
rgb-preview-patch sets preview-bit in rgb-mode, e.g. for UMAX S6E
.br
start-scan-patch uses special format of the START_SCAN-command,
don't know if anyone needs it!

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.IR special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  The special device name must be a generic SCSI device or a
symlink to such a device.  Under Linux, such a device name could be
.IR /dev/sga
or
.IR /dev/sge ,
for example.
.SH CONFIGURATION
The configuration file for this backend resides in
.IR @CONFIGDIR@/umax.conf .
Its contents is a list of device names that correspond to UMAX
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
/dev/scanner
.br
# this is a comment
.br
/dev/sge
.RE
.SH SCSI ADAPTER TIPS
The SCSI-adapters that are shipped with some Umax-scanner are not
supported by Linux and most other platforms, so you typically need to
purchase another SCSI-adapter that is supported by your platform.  See
the relevant hardware FAQs and HOWTOs for your platform for more
information.
.PP
Also, we recommend to connect Umax scanners to their own SCSI
controller since otherwise, the devices on the same SCSI bus as the
scanner cannot be accessed while a scan is in progress.
.SH FILES
.TP
.I @CONFIGDIR@/umax.conf
The backend configuration file.
.TP
.I @LIBDIR@/libsane-umax.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-umax.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_DEBUG_UMAX
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity:
.br
0 print important errors and warnings (printed each time)
.br
1 print errors
.br
2 print warnings
.br
3-5 enable umax-lowlevel-routines output
.br
10 print called sane-routines
.br
15 sane-routine messages
.br
20 more sane-rotine messages
.br
25 reader_process messages
.br
50 sane-io-control messages
.br
E.g. just say:
.br
export SANE_DEBUG_UMAX=128
.SH "SEE ALSO"
sane-scsi(5)
.SH AUTHOR
Oliver Rauch, parts of the low-level-driver by Michael K. Johnson
.SH BUGS
May be a lot ;-(
.br
Quality calibration will hang the scanner and the SCSI-bus.
.br
UMAX Astra 600S is not supported in RGB- and Greyscale-mode.
