;;; ENGLISH: Site specific definitions, to be modified on installation
;;; DEUTSCH: Funktionen, die beim Transportieren zu ndern sind
;;; FRANCAIS: Fonctions dpendantes de l'installation

(in-package "LISP")
(mapcar #'fmakunbound '(machine-type machine-version machine-instance
                        short-site-name long-site-name
                        editor-name edit-file editor-tempfile))

(defun machine-type () "AT Clone")
(defun machine-version () "486/33")
(defun machine-instance () "Heimgert Bruno Haible")

(defun short-site-name () "Karlsruhe")
(defun long-site-name () "Augartenstrae 40, D-76137 Karlsruhe, Deutschland")

;; ENGLISH: The name of the editor:
;; DEUTSCH: Der Name des Editors:
;; FRANCAIS: Nom de l'diteur :
(defparameter *editor* "vi")
(defun editor-name () (or (sys::getenv "EDITOR") *editor*))

;; ENGLISH: (edit-file file) edits a file.
;; DEUTSCH: (edit-file file) editiert eine Datei.
;; FRANCAIS: (edit-file file) permet l'dition d'un fichier.
(defun edit-file (file)
  (open file :direction :probe :if-does-not-exist :create)
  (shell (format nil "~A ~A" (editor-name) (truename file)))
)

;; ENGLISH: The temporary file LISP creates for editing:
;; DEUTSCH: Das temporre File, das LISP beim Editieren anlegt:
;; FRANCAIS: Fichier temporaire cr par LISP pour l'dition :
(defun editor-tempfile ()
  (merge-pathnames "lisptemp.lsp" (user-homedir-pathname))
)

;; ENGLISH: The list of directories where programs are searched on LOAD etc.:
;; DEUTSCH: Die Liste von Directories, in denen Programme bei LOAD etc. gesucht
;;          werden:
;; FRANCAIS: Liste de rpertoires o chercher un fichier programme:
(defparameter *load-paths*
  '(#"./"           ; in the current directory
    "~/lisp/**/"    ; in all directories below $HOME/lisp
)  )

;; ENGLISH: This makes screen output prettier:
;; DEUTSCH: Dadurch sehen Bildschirmausgaben besser aus:
;; FRANCAIS: Pour que les sorties sur l'cran soient plus lisibles:
(setq *print-pretty* t)

