'\"
'\" Copyright (c) 1994 The Regents of the University of California.
'\" Copyright (c) 1994 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) clipboard.n 1.6 95/06/07 21:15:42
'\" 
.so man.macros
.TH clipboard n 4.0 Tk "Tk Selection Handling"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
clipboard \- Manipulate Tk clipboard
.SH SYNOPSIS
\fI$widget\fR->\fBclipboard\fIOption\fR?(\fIargs\fR)?
.BE

.SH DESCRIPTION
.PP
This command provides an interface to the Tk clipboard,
which stores data for later retrieval using the selection mechanism.
In order to copy data into the clipboard, \fBclipboardClear\fR must
be called, followed by a sequence of one or more calls to 
\fBclipboardAppend\fR.  To ensure that the clipboard is updated atomically, all
appends should be completed before returning to the event loop.
.PP
The following methods are currently supported:
.PP
.TP
\fI$widget\fR->\fBclipboardClear\fR
Claims ownership of the clipboard on \fI$widget\fR's display and removes
any previous contents.   Returns an empty string.
.TP
\fI$widget\fR->\fBclipboardAppend\fR(?\fB\-format\fR=>\fIformat\fR?,?\fB\-type\fR=>\fItype\fR?,?\fB\-\^\-\fR?,\fIdata\fR)
Appends \fIdata\fR to the clipboard on $widget\fR's
display in the form given by \fItype\fR with the representation given
by \fIformat\fR and claims ownership of the clipboard on $widget\fR's
display.
.RS
.PP
\fIType\fR specifies the form in which the selection is to be returned
(the desired ``target'' for conversion, in ICCCM terminology), and
should be an atom name such as STRING or FILE_NAME; see the
Inter-Client Communication Conventions Manual for complete details.
\fIType\fR defaults to STRING.
.RE
.RS
.PP
The \fIformat\fR argument specifies the representation that should be
used to transmit the selection to the requester (the second column of
Table 2 of the ICCCM), and defaults to STRING.  If \fIformat\fR is
STRING, the selection is transmitted as 8-bit ASCII characters. 
See the \fBSelection\fR manual entry for explanation of what happens
if \fIformat\fR is not STRING.
Note that arguments passed to
\fBclipboardAppend\fR are concatenated before conversion, so the
caller must take care to ensure appropriate spacing across string
boundaries.  All items appended to the clipboard with the same
\fItype\fR must have the same \fIformat\fR.
.PP
A \fB\-\^\-\fR argument may be specified to mark the end of options:  the
next argument will always be used as \fIdata\fR.
This feature may be convenient if, for example, \fIdata\fR starts
with a \fB\-\fR.
.RE

.SH KEYWORDS
clear, format, clipboard, append, selection, type
