'\"
'\" Copyright (c) 1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) palette.n 1.2 95/06/07 21:15:05
'\" 
.so man.macros
.TH setPalette n 4.0 Tk "Tk Generic Methods"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
setPalette, bisque \- Modify the Tk color palette
.SH SYNOPSIS
\fI$widget\fR->\fBsetPalette\fR(\fIbackground\fR)
.br
\fI$widget\fR->\fBsetPalette(\fIname\fR=>\fIvalue\fR?,\fIname\fR=>\fIvalue ...\fR?)
.br
\fI$widget\fR->\fBbisque\fR
.BE

.SH DESCRIPTION
.PP
The \fBsetPalette\fR method changes the color scheme for Tk.
It does this by modifying the colors of existing widgets and by changing
the option database so that future widgets will use the new color scheme.
If \fBsetPalette\fR is invoked with a single argument, the
argument is the name of a color to use as the normal background
color;  \fBsetPalette\fR will compute a complete color palette
from this background color.
Alternatively, the arguments to \fBsetPalette\fR may consist of any number
of \fIname\fR\-\fIvalue\fR pairs, where the first argument of the pair
is the name of an option in the Tk option database and the second
argument is the new value to use for that option.  The following
database names are currently supported:
.DS L
.ta 4c 8c
\fBactiveBackground\fR	\fBforeground\fR	\fBselectColor\fR
\fBactiveForeground\fR	\fBhighlightBackground\fR	\fBselectBackground\fR
\fBbackground\fR	\fBhighlightColor\fR	\fBselectForeground\fR
\fBdisabledForeground\fR	\fBinsertBackground\fR	\fBtroughColor\fR
.DE
\fBsetPalette\fR tries to compute reasonable defaults for any
options that you don't specify.  You can specify options other
than the above ones and Tk will change those options on widgets as
well.  This feature may be useful if you are using custom widgets with
additional color options.
.PP
Once it has computed the new value to use for each of the color options,
\fBsetPalette\fR scans the widget hierarchy to modify the options
of all existing widgets.  For each widget, it checks to see if any
of the above options is defined for the widget.  If so, and if the
option's current value is the default, then the value is changed;  if
the option has a value other than the default, \fBsetPalette\fR
will not change it.  The default for an option is the one provided by
the widget (\fB($w->configure('option'))[3]\fR) unless
\fBsetPalette\fR has been run previously, in which case it is the
value specified in the previous invocation of \fBsetPalette\fR.
.PP
After modifying all the widgets in the application, \fBsetPalette\fR
adds options to the option database to change the defaults for
widgets created in the future.  The new options are added at
priority \fBwidgetDefault\fR, so they will be overridden by options
from the .Xdefaults file or options specified on the command-line
that creates a widget.
.PP
The method \fBbisque\fR is provided for backward compatibility:
it restores the application's colors to the light brown (``bisque'')
color scheme used in Tk 3.6 and earlier versions.

.SH "BUGS"
.PP
The use of option database names rather than the configure names is 
understandable given the mechanism (copied from Tcl/Tk), but
is potentially confusing.
.PP
The interpolation of different 'shades' of color used for 3D effects
in 'RGB' space can lead to undesirable changes in 'hue'.
Interpolation in 'HSV' (as used in \fBTk::ColorEditor\fP) would be more 
robust and X11R5's color support probably even more so. 
.SH "SEE ALSO"
configure

.SH KEYWORDS
bisque, color, palette
