""" Demonstration of the Pmw RadioSelect megawidget.
"""

# Import Pmw from the sibling directory.
import sys
sys.path[:0] = ['../../..']

import Tkinter
import Pmw

class Demo:
    def __init__(self, parent):
	# Create and pack a horizontal RadioSelect widget.
	horiz = Pmw.RadioSelect(parent,
		labelpos = 'w',
		command = self.callback,
		label_text = 'Horizontal',
		frame_borderwidth = 2,
		frame_relief = 'ridge'
	)
	horiz.pack(fill = 'x', padx = 20, pady = 20)

	# Add some buttons to the horizontal RadioSelect.
	for text in ('Fruit', 'Vegetables', 'Cereals', 'Legumes'):
	    horiz.add(text)

	horiz.invoke('Cereals')

	# Create and pack a multiple selection vertical RadioSelect widget.
	self.vert = Pmw.RadioSelect(parent,
		orient = 'vertical',
		labelpos = 'w',
		command = self.multcallback,
		label_text = 'Multiple\nselection\nvertical',
		hull_borderwidth = 2,
		hull_relief = 'ridge',
		selectmode = 'multiple',
	)
	self.vert.pack(expand = 1, pady = 20)

	# Add some buttons to the vertical RadioSelect.
	for text in ('Apricots', 'Eggplant', 'Rice', 'Lentils'):
	    self.vert.add(text)

    def callback(self, tag):
	# This is called whenever the user clicks on a button
	# in the single select RadioSelect widget.
	print 'Button', tag, 'was pressed.'

    def multcallback(self, tag, state):
	# This is called whenever the user clicks on a button
	# in the multiple select RadioSelect widget.
        if state:
           action = 'pressed.'
        else:
           action = 'released.'

        print 'Button', tag, 'was', action, \
		'Selection:', self.vert.getcurselection()
           
######################################################################

# Create demo in root window for testing.
if __name__ == '__main__':
    root = Tkinter.Tk()
    Pmw.initialise(root, fontScheme = 'pmw1')
    root.title('Pmw RadioSelect demonstration')

    exitButton = Tkinter.Button(root, text = 'Exit', command = root.destroy)
    exitButton.pack(side = 'bottom')
    widget = Demo(root)
    root.mainloop()
