/* Startup code for Alpha/ELF.
   Copyright (C) 1993, 1995, 1996, 1997, 1998 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Richard Henderson <rth@tamu.edu>

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#include <sysdep.h>

	.text
	.align 3
	.globl _start
	.ent _start, 0
_start:
	.frame fp, 0, zero
	mov	zero, fp
	br	gp, 1f
1:	ldgp	gp, 0(gp)
	.prologue 1

  /* Load address of the user's main function.  */
	lda	a0, main

	ldl	a1, 0(sp)	/* get argc */
	lda	a2, 8(sp)	/* get argv */

  /* Load address of our own entry points to .fini and .init.  */
	lda	a3, _init
	lda	a4, _fini

  /* Store address of the shared library termination function.  */
	mov	v0, a5

  /* Call the user's main function, and exit with its value.
     But let the libc call main.    */
	jsr	ra, __libc_start_main
	ldgp	gp, 0(ra)

  /* Die very horribly if exit returns.  Call_pal hlt is callable from
     kernel mode only; this will result in an illegal instruction trap.  */
	call_pal 0
	.end _start

/* For ECOFF backwards compatibility. */
weak_alias(_start, __start)

/* Define a symbol for the first piece of initialized data.  */
	.data
	.globl __data_start
__data_start:
	.long 0

#ifdef __ELF__
	.size __data_start, 4
	.type __data_start, @object
#endif

weak_alias(__data_start, data_start)
