/*
** Generated by X-Designer 
*/
/*
**LIBS: -lXm -lXt -lX11
*/

#include <X11/Xatom.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <X11/StringDefs.h>
#include <Xm/DialogS.h>
#include <Xm/DrawingA.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/ScrollBar.h>
#include <stdio.h>

extern void da_expose ();
Widget shell = (Widget) NULL;
Widget form = (Widget) NULL;
Widget list1_sw = (Widget) NULL;
Widget list1 = (Widget) NULL;
Widget da = (Widget) NULL;

static _xd_initialised = 0;

typedef struct FontResources_s { 
	XmFontList f1;
} FontResources_t, *FontResources_p;

static FontResources_t font_resources;


static GC       gc = 0;
static void     create_gc();
static XmString string_append();

void
da_expose(w, client_data, call_data)
	Widget          w;
	XtPointer       client_data;
	XtPointer       call_data;
{
	XExposeEvent   *e = &((XmDrawingAreaCallbackStruct *) call_data)
	->event->xexpose;
	XmString       *items, *selected_items, out_string, tmp_string;
	Boolean         underline;
	int             item_count, selected_count;
	Widget          list = (Widget) client_data;
	Dimension       width, height, extent, item_extent, string_height;
	int             i;
	XmFontList      font_list;
	XRectangle      clip;

	/* Extract items, selected items and font from XmList */
	XtVaGetValues(list, XmNitems, &items, XmNitemCount, &item_count,
		      XmNselectedItems, &selected_items,
		      XmNselectedItemCount, &selected_count,
		      XmNfontList, &font_list,
		      0);
	XtVaGetValues(w, XmNwidth, &width, XmNheight, &height, 0);
	underline = (selected_count > 0);
	create_gc(w, font_list);
	extent = 0;
	out_string = NULL;
	/*
	 * Form list items into a single compound string, inserting
	 * separators where needed to avoid drawing outside the XmDrawingArea
	 */
	for (i = 0; i < item_count; i++) {
		item_extent = XmStringWidth(font_list, items[i]);
		if (out_string != NULL && (extent + item_extent > width)) {
			extent = 0;
			out_string = string_append(out_string,
						 XmStringSeparatorCreate());
		}
		tmp_string = XmStringConcat(out_string, items[i]);
		XmStringFree(out_string);
		out_string = tmp_string;
		extent = extent + item_extent;
	}
	string_height = XmStringHeight(font_list, out_string);
	clip.x = e->x;
	clip.y = e->y;
	clip.width = e->width;
	clip.height = e->height;
	XSetClipRectangles(XtDisplay(w), gc, 0, 0, &clip, 1, YXBanded);
	/* Draw compound string, underlining the selected item if any */
	if (underline)
		XmStringDrawUnderline(XtDisplay(w), XtWindow(w), font_list,
		     out_string, gc, 0, (height - string_height) / 2, width,
				      XmALIGNMENT_CENTER,
				      XmSTRING_DIRECTION_L_TO_R, NULL,
				      selected_items[0]);
	else
		XmStringDraw(XtDisplay(w), XtWindow(w), font_list, out_string, gc,
			     0, (height - string_height) / 2, width,
			     XmALIGNMENT_CENTER,
			     XmSTRING_DIRECTION_L_TO_R, NULL);
	XmStringFree(out_string);
}

static          XmString
string_append(s1, s2)
	XmString        s1, s2;
{
	XmString        s3 = XmStringConcat(s1, s2);
	XmStringFree(s1);
	XmStringFree(s2);
	return (s3);
}


static void 
create_gc(w)
	Widget          w;
{
	XmFontList      fontlist;
	XGCValues       values;
	XFontStruct    *font, **font_struct_list;
	XFontSet        fontset;
	char          **font_name_list, *tag;
	XtPointer       t;
	XmFontContext   context;
	XmFontListEntry first_entry, entry;
	XmFontType      font_type;
	int             font_count;

	if (gc)
		return;

	/* Assume parent is Shell or BulletinBoard */
	XtVaGetValues(XtParent(w), XmNlabelFontList, &fontlist, 0);
	if (fontlist)
		if (XmFontListInitFontContext(&context, fontlist)) {
			/* Get first entry */
			entry = XmFontListNextEntry(context);
			first_entry = entry;
			/* Walk down list looking for "Drawing" */
			while (entry) {
				tag = XmFontListEntryGetTag(entry);
				if (strcmp(tag, "Drawing") == 0) {
					XtFree(tag);
					break;
				}
				XtFree(tag);
				entry = XmFontListNextEntry(context);
			}
			XmFontListFreeFontContext(context);
			/* If we didn't find it use first entry */
			if (!entry)
				entry = first_entry;
			/* Get the font */
			t = XmFontListEntryGetFont(entry, &font_type);
			if (font_type == XmFONT_IS_FONT)
				font = (XFontStruct *) t;
			else {
				/*
				 * It's a font set - use the first one in the
				 * set
				 */
				fontset = (XFontSet) t;
				font_count = XFontsOfFontSet(fontset, &font_struct_list,
							   &font_name_list);
				font = font_struct_list[0];
			}
			values.font = font->fid;
			values.foreground = BlackPixelOfScreen(XtScreen(w));
			gc = XCreateGC(XtDisplay(w), XtWindow(w),
				       GCFont | GCForeground, &values);
		}
}
static void initialise_objects( parent )
	Widget parent;
{
	char *from_s;                  /* For conversions */
	XrmValue from_value, to_value; /* Ditto */

	if ( _xd_initialised ) return;
	_xd_initialised = 1;
	from_s = "-*-fixed-*-*-*-*-24-*-*-*-*-*-*-*=japanese,-*-lucidabright-medium-i-*-*-24-*-*-*-*-*-*-*=large_italic,-*-lucidabright-demibold-r-*-*-24-*-*-*-*-*-*-*=large_bold,-*-lucidabright-demibold-i-*-*-14-*-*-*-*-*-*-*=small_italic,-*-lucidabright-demibold-r-*-*-14-*-*-*-*-*-*-*=small_bold";
	from_value.size = strlen(from_s)+1;
	from_value.addr = (char *) XtMalloc ( from_value.size );
	(void) strcpy ( from_value.addr, from_s );
	XtConvert( parent, XmRString, &from_value, XmRFontList, &to_value);
	XtFree ( from_value.addr );
	font_resources.f1 = *(XmFontList*)to_value.addr;
}

void create_shell (display, app_name, app_argc, app_argv)
Display *display;
char *app_name;
int app_argc;
char **app_argv;
{
	Arg al[64];                    /* Arg List */
	register int ac = 0;           /* Arg Count */
	XmString *list_items;          /* For list items */
	int list_item;                 /* Index for list_items */

	XtSetArg(al[ac], XmNallowShellResize, TRUE); ac++;
	XtSetArg(al[ac], XmNargc, app_argc); ac++;
	XtSetArg(al[ac], XmNargv, app_argv); ac++;
	shell = XtAppCreateShell ( app_name, "XApplication", applicationShellWidgetClass, display, al, ac );
	ac = 0;
	initialise_objects ( shell );
	XtSetArg(al[ac], XmNautoUnmanage, FALSE); ac++;
	XtSetArg(al[ac], XmNlabelFontList, font_resources.f1); ac++;
	XtSetArg(al[ac], XmNheight, 400); ac++;
	form = XmCreateForm ( shell, "form", al, ac );
	ac = 0;
	XtSetArg(al[ac], XmNfontList, font_resources.f1); ac++;
	XtSetArg(al[ac], XmNselectionPolicy, XmSINGLE_SELECT); ac++;
	XtSetArg(al[ac], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE); ac++;
	XtSetArg(al[ac], XmNitemCount, 5); ac++;
	list_items = (XmString *) XtMalloc ( sizeof (XmString) * 5 );
	list_items[0] = XmStringCreateLtoR("The", "large_italic");
	list_items[1] = XmStringCreateLtoR("Quick", "small_bold");
	/*list_items[2] = XmStringCreateLtoR("\033$BF|\033(B\033$BK\\\033(B", "japanese" );*/
	list_items[2] = XmStringCreateLtoR("F|  K\\", "japanese" );
	list_items[3] = XmStringCreateLtoR("Brown", "small_italic");
	list_items[4] = XmStringCreateLtoR("Fox", "large_bold");
	XtSetArg(al[ac], XmNitems, list_items); ac++;
	list1 = XmCreateScrolledList ( form, "list1", al, ac );
	ac = 0;
	list1_sw = XtParent ( list1 );

	for (list_item = 0; list_item < 5; list_item++ )
		XmStringFree (list_items [list_item]);
	XtFree ( (char *) list_items ); 
	da = XmCreateDrawingArea ( form, "da", al, ac );

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNbottomPosition, 65); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;

	XtSetValues ( list1_sw,al, ac );
	ac = 0;

	XtSetArg(al[ac], XmNtopAttachment, XmATTACH_POSITION); ac++;
	XtSetArg(al[ac], XmNtopPosition, 65); ac++;
	XtSetArg(al[ac], XmNbottomAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNleftAttachment, XmATTACH_FORM); ac++;
	XtSetArg(al[ac], XmNrightAttachment, XmATTACH_FORM); ac++;
	XtSetValues ( da,al, ac );
	ac = 0;
	XtManageChild(list1);
	XtAddCallback (da, XmNexposeCallback, da_expose, list1);
	XtManageChild(da);
	ac = 0;
	XtManageChild ( form);
}



XtAppContext app_context;
Display *display;       /*  Display             */

int main (argc,argv)
int    argc;
char            **argv;
{
	XtSetLanguageProc ( (XtAppContext) NULL, (XtLanguageProc) NULL, (XtPointer) NULL );
	XtToolkitInitialize ();
	app_context = XtCreateApplicationContext ();
	display = XtOpenDisplay (app_context, NULL, argv[0], "XApplication",
				 NULL, 0, &argc, argv);
	if (!display)
	{
	    printf("%s: can't open display, exiting...\n", argv[0]);
	    exit (-1);
	}
	create_shell ( display, argv[0], argc, argv );
	XtRealizeWidget (shell);
	XtAppMainLoop (app_context);
	exit (0);
}

