/*								-*- C++ -*-
 * $Id: DLG_colour.cpp,v 1.4 1997-02-28 16:03:59+01 mho Exp $
 *
 * Purpose: colour dialog box
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1996, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1996, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "DLG_colour.h"
#endif

#define  Uses_wxButton
#define  Uses_wxColourDialog
#define  Uses_wxSlider
#include "wx.h"

/*
 * wxColourData
 */

IMPLEMENT_DYNAMIC_CLASS(wxColourData, wxObject)

wxColourData::wxColourData(void)
{
  int i;
  for (i = 0; i < 16; i++)
    custColours[i].Set(255, 255, 255);

  chooseFull = FALSE;
  dataColour.Set(0,0,0);
} 

wxColourData::~wxColourData(void)
{
}

void wxColourData::SetCustomColour(int i, wxColour& colour)
{
  if (i > 15 || i < 0)
    return;

  custColours[i] = colour;
}

wxColour wxColourData::GetCustomColour(int i)
{
  if (i > 15 || i < 0)
    return wxColour(0,0,0);

  return custColours[i];
}

void wxColourData::operator=(const wxColourData& data)
{
  int i;
  for (i = 0; i < 16; i++)
    custColours[i] = (wxColour&)data.custColours[i];

  dataColour = (wxColour&)data.dataColour;
  chooseFull = data.chooseFull;
}

/*
 * Generic wxColourDialog
 */

int NUM_COLS = 48;
char *wxColourDialogNames[] = {
    "ORANGE", "GOLDENROD", "WHEAT", "SPRING GREEN", "SKY BLUE", "SLATE BLUE", "MEDIUM VIOLET RED", "PURPLE",
    "RED", "YELLOW", "MEDIUM SPRING GREEN", "PALE GREEN", "CYAN", "LIGHT STEEL BLUE", "ORCHID", "LIGHT MAGENTA",
    "BROWN", "YELLOW", "GREEN", "CADET BLUE", "MEDIUM BLUE", "MAGENTA", "MAROON", "ORANGE RED",
    "FIREBRICK", "CORAL", "FOREST GREEN", "AQUAMARINE", "BLUE", "NAVY", "THISTLE", "MEDIUM VIOLET RED",
    "INDIAN RED", "GOLD", "MEDIUM SEA GREEN", "MEDIUM BLUE", "MIDNIGHT BLUE", "GREY", "PURPLE", "KHAKI",
    "BLACK", "MEDIUM FOREST GREEN", "KHAKI", "DARK GREY", "SEA GREEN", "LIGHT GREY", "MEDIUM SLATE BLUE", "WHITE"
};

Bool wxGenericColourDialog::colourDialogCancelled = FALSE;
 
IMPLEMENT_DYNAMIC_CLASS(wxGenericColourDialog, wxDialogBox)

wxGenericColourDialog::wxGenericColourDialog(void)
{
  dialogParent = NULL;
  colourDialogCancelled = FALSE;
  whichKind = 1;
  colourSelection = 0;
}

wxGenericColourDialog::wxGenericColourDialog(wxWindow *parent, wxColourData *data):
  wxDialogBox(parent, "Colour", TRUE, 0, 0, 900, 900)
{
  colourDialogCancelled = FALSE;
  whichKind = 1;
  colourSelection = 0;
  Create(parent, data);
}

wxGenericColourDialog::~wxGenericColourDialog(void)
{
}

Bool wxGenericColourDialog::OnClose(void)
{
  colourDialogCancelled = TRUE;
  Show(FALSE);
  return FALSE;
}
 
Bool wxGenericColourDialog::OnCharHook(wxKeyEvent& event)
{
  if (event.KeyCode() == WXK_ESCAPE)
  {
    colourDialogCancelled = TRUE;
    Show(FALSE);
    return TRUE;
  }
  else return FALSE;
}

Bool wxGenericColourDialog::Create(wxWindow *parent, wxColourData *data)
{
  dialogParent = parent;
  
  if (data)
    colourData = *data;

  InitializeColours();
  CalculateMeasurements();
  CreateWidgets();
  
  return TRUE;
}

Bool wxGenericColourDialog::Show(Bool flag)
{
  //wxBeginBusyCursor();
  wxDialogBox::Show(flag);
  //wxEndBusyCursor();
  if (flag)
  {
    if (colourDialogCancelled)
      return FALSE;
    else
      return TRUE;
  }
  return TRUE;
}


// Internal functions
void wxGenericColourDialog::OnEvent(wxMouseEvent& event)
{
  if (event.ButtonDown(1))
  {
    int x = (int)event.x;
    int y = (int)event.y;

    if ((x >= standardColoursRect.x && x <= (standardColoursRect.x + standardColoursRect.width)) &&
        (y >= standardColoursRect.y && y <= (standardColoursRect.y + standardColoursRect.height)))
    {
      int selX = (int)(x - standardColoursRect.x)/(smallRectangleSize.x + gridSpacing);
      int selY = (int)(y - standardColoursRect.y)/(smallRectangleSize.y + gridSpacing);
      int ptr = (int)(selX + selY*8);
      OnBasicColourClick(ptr);
    }
    else if ((x >= customColoursRect.x && x <= (customColoursRect.x + customColoursRect.width)) &&
        (y >= customColoursRect.y && y <= (customColoursRect.y + customColoursRect.height)))
    {
      int selX = (int)(x - customColoursRect.x)/(smallRectangleSize.x + gridSpacing);
      int selY = (int)(y - customColoursRect.y)/(smallRectangleSize.y + gridSpacing);
      int ptr = (int)(selX + selY*8);
      OnCustomColourClick(ptr);
    }
  }
}

void wxGenericColourDialog::OnPaint(void)
{
  wxDialogBox::OnPaint();
  PaintBasicColours();
  PaintCustomColours();
  PaintCustomColour();
  PaintHighlight(TRUE);
}

void wxGenericColourDialog::CalculateMeasurements(void)
{
  smallRectangleSize.x = 18;
  smallRectangleSize.y = 14;
  customRectangleSize.x = 40;
  customRectangleSize.y = 40;

  gridSpacing = 6;
  sectionSpacing = 15;

  standardColoursRect.x = 10;
  standardColoursRect.y = 15;
  standardColoursRect.width = (8*smallRectangleSize.x) + (7*gridSpacing);
  standardColoursRect.height = (6*smallRectangleSize.y) + (5*gridSpacing);

  customColoursRect.x = standardColoursRect.x;
  customColoursRect.y = standardColoursRect.y + standardColoursRect.height  + 20;
  customColoursRect.width = (8*smallRectangleSize.x) + (7*gridSpacing);
  customColoursRect.height = (2*smallRectangleSize.y) + (1*gridSpacing);

  singleCustomColourRect.x = customColoursRect.x + customColoursRect.width + sectionSpacing;
  singleCustomColourRect.y = customColoursRect.y;
  singleCustomColourRect.width = customRectangleSize.x = customColoursRect.height;
  singleCustomColourRect.height = customRectangleSize.y = customColoursRect.height;

//   singleCustomColourRect.x = customColoursRect.width + customColoursRect.x + sectionSpacing;
//   singleCustomColourRect.y = 80;
//   singleCustomColourRect.width = customRectangleSize.x;
//   singleCustomColourRect.height = customRectangleSize.y;

  okButtonX = 10;
  customButtonX = singleCustomColourRect.x ;
  buttonY = customColoursRect.y + customColoursRect.height + 10;
}

static void wxGenericColourOk(wxButton& but, wxCommandEvent& WXUNUSED(event))
{
  wxGenericColourDialog *dialog = (wxGenericColourDialog *)but.GetParent();
  dialog->OnOk();
}

static void wxGenericColourCancel(wxButton& but, wxCommandEvent& WXUNUSED(event))
{
  wxGenericColourDialog *dialog = (wxGenericColourDialog *)but.GetParent();
  dialog->OnCancel();
}

static void wxGenericColourAddCustom(wxButton& but, wxCommandEvent& WXUNUSED(event))
{
  wxGenericColourDialog *dialog = (wxGenericColourDialog *)but.GetParent();
  dialog->OnAddCustom();
}

static void wxGenericColourRed(wxSlider& but, wxCommandEvent& event)
{
  wxGenericColourDialog *dialog = (wxGenericColourDialog *)but.GetParent();
  dialog->OnRedSlider(event);
}

static void wxGenericColourGreen(wxSlider& but, wxCommandEvent& event)
{
  wxGenericColourDialog *dialog = (wxGenericColourDialog *)but.GetParent();
  dialog->OnGreenSlider(event);
}

static void wxGenericColourBlue(wxSlider& but, wxCommandEvent& event)
{
  wxGenericColourDialog *dialog = (wxGenericColourDialog *)but.GetParent();
  dialog->OnBlueSlider(event);
}

void wxGenericColourDialog::CreateWidgets(void)
{
  wxBeginBusyCursor();
  
  int sliderX = singleCustomColourRect.x; // + singleCustomColourRect.width + sectionSpacing;
  int sliderY = standardColoursRect.y;
  int sliderSpacing = 55;
  int sliderHeight = standardColoursRect.height;

  redSlider = new wxSlider(this, (wxFunction)wxGenericColourRed, "Red", 0, 0, 255,
			   sliderHeight, sliderX, sliderY, wxVERTICAL);
  greenSlider = new wxSlider(this, (wxFunction)wxGenericColourGreen, "Green", 0, 0, 255,
			     sliderHeight, sliderX + sliderSpacing, -1, wxVERTICAL);
  blueSlider = new wxSlider(this, (wxFunction)wxGenericColourBlue, "Blue", 0, 0, 255,
			    sliderHeight, sliderX + 2*sliderSpacing, -1, wxVERTICAL);

  int ww, hh; blueSlider->GetSize(&ww, &hh);
  singleCustomColourRect.width = customRectangleSize.x = 2*sliderSpacing + ww;

  wxButton *okButton
      = new wxButton(this, (wxFunction)wxGenericColourOk, "OK", okButtonX-2, buttonY,
		     (customColoursRect.width-10) / 2 + 2);
  (void)new wxButton(this, (wxFunction)wxGenericColourCancel, "Cancel", -1, -1,
		     (customColoursRect.width-10) / 2 + 2);
  (void)new wxButton(this, (wxFunction)wxGenericColourAddCustom, "Add to custom colours",
		     sliderX, buttonY, singleCustomColourRect.width);

  SetClientSize(sliderX + singleCustomColourRect.width+10, buttonY + 30);
  okButton->SetDefault();
  Centre(wxBOTH);

  wxEndBusyCursor();
}

void wxGenericColourDialog::InitializeColours(void)
{
  // Need some decent way of doing this
  int i;
  for (i = 0; i < 48; i++)
  {
    wxColour *col = wxTheColourDatabase->FindColour(wxColourDialogNames[i]);
    if (col)
      standardColours[i].Set(col->Red(), col->Green(), col->Blue());
    else
      standardColours[i].Set(0, 0, 0);
  }

  for (i = 0; i < 16; i++)
    customColours[i] = colourData.GetCustomColour(i);

  singleCustomColour.Set(0, 0, 0);
}

void wxGenericColourDialog::PaintBasicColours(void)
{
  wxDC *dc = GetDC();

  dc->BeginDrawing();

  int i;
  for (i = 0; i < 6; i++)
  {
    int j;
    for (j = 0; j < 8; j++)
    {
      int ptr = i*8 + j;
      
      int x = (j*(smallRectangleSize.x+gridSpacing) + standardColoursRect.x);
      int y = (i*(smallRectangleSize.y+gridSpacing) + standardColoursRect.y);

      dc->SetPen(wxBLACK_PEN);
      wxBrush *brush = wxTheBrushList->FindOrCreateBrush(&(standardColours[ptr]), wxSOLID);
      dc->SetBrush(brush);

      dc->DrawRectangle(x, y, smallRectangleSize.x, smallRectangleSize.y);
    }
  }
  dc->EndDrawing();
}

void wxGenericColourDialog::PaintCustomColours(void)
{
  wxDC *dc = GetDC();
  dc->BeginDrawing();

  int i;
  for (i = 0; i < 2; i++)
  {
    int j;
    for (j = 0; j < 8; j++)
    {
      int ptr = i*8 + j;
      
      int x = (j*(smallRectangleSize.x+gridSpacing)) + customColoursRect.x;
      int y = (i*(smallRectangleSize.y+gridSpacing)) + customColoursRect.y;

      dc->SetPen(wxBLACK_PEN);
      wxBrush *brush = wxTheBrushList->FindOrCreateBrush(&(customColours[ptr]), wxSOLID);
      dc->SetBrush(brush);

      dc->DrawRectangle(x, y, smallRectangleSize.x, smallRectangleSize.y);
    }
  }
  dc->EndDrawing();
}

void wxGenericColourDialog::PaintHighlight(Bool draw)
{
  wxDC *dc = GetDC();
  dc->BeginDrawing();

  // Number of pixels bigger than the standard rectangle size
  // for drawing a highlight
  int deltaX = 2;
  int deltaY = 2;

  if (whichKind == 1)
  {
    // Standard colours
    int y = (int)(colourSelection / 8);
    int x = (int)(colourSelection - (y*8));

    x = (x*(smallRectangleSize.x + gridSpacing) + standardColoursRect.x) - deltaX;
    y = (y*(smallRectangleSize.y + gridSpacing) + standardColoursRect.y) - deltaY;

    if (draw)
      dc->SetPen(wxBLACK_PEN);
    else
      dc->SetPen(wxLIGHT_GREY_PEN);

    dc->SetBrush(wxTRANSPARENT_BRUSH);
//    dc->SetBrush(wxRED_BRUSH);
    dc->DrawRectangle(x, y, smallRectangleSize.x + (2*deltaX), smallRectangleSize.y + (2*deltaY));
  }
  else
  {
    // User-defined colours
    int y = (int)(colourSelection / 8);
    int x = (int)(colourSelection - (y*8));

    x = (x*(smallRectangleSize.x + gridSpacing) + customColoursRect.x) - deltaX;
    y = (y*(smallRectangleSize.y + gridSpacing) + customColoursRect.y) - deltaY;

    if (draw)
      dc->SetPen(wxBLACK_PEN);
    else
      dc->SetPen(wxLIGHT_GREY_PEN);
      
    dc->SetBrush(wxTRANSPARENT_BRUSH);
    dc->DrawRectangle(x, y, smallRectangleSize.x + (2*deltaX), smallRectangleSize.y + (2*deltaY));
  }
  
  dc->EndDrawing();
}

void wxGenericColourDialog::PaintCustomColour(void)
{
  wxDC *dc = GetDC();
  dc->BeginDrawing();
  
  dc->SetPen(wxBLACK_PEN);

  wxBrush *brush = new wxBrush(singleCustomColour, wxSOLID);
  dc->SetBrush(brush);

  dc->DrawRectangle(singleCustomColourRect.x, singleCustomColourRect.y, customRectangleSize.x, customRectangleSize.y);

  dc->SetBrush(NULL);
  delete brush;

  dc->EndDrawing();
}

void wxGenericColourDialog::OnBasicColourClick(int which)
{
  PaintHighlight(FALSE);
  whichKind = 1;
  colourSelection = which;
  colourData.SetColour(standardColours[colourSelection]);

  PaintHighlight(TRUE);
}

void wxGenericColourDialog::OnCustomColourClick(int which)
{
  PaintHighlight(FALSE);
  whichKind = 2;
  colourSelection = which;
  colourData.SetColour(customColours[colourSelection]);

  PaintHighlight(TRUE);
}

void wxGenericColourDialog::OnOk(void)
{
  Show(FALSE);
}

void wxGenericColourDialog::OnCancel(void)
{
  colourDialogCancelled = TRUE;
  Show(FALSE);
}

void wxGenericColourDialog::OnAddCustom(void)
{
  if (whichKind != 2)
  {
    PaintHighlight(FALSE);
    whichKind = 2;
    colourSelection = 0;
    PaintHighlight(TRUE);
  }

  customColours[colourSelection].Set(singleCustomColour.Red(), singleCustomColour.Green(), singleCustomColour.Blue());
  colourData.SetColour(customColours[colourSelection]);
  colourData.SetCustomColour(colourSelection, customColours[colourSelection]);
  
  PaintCustomColours();
}

void wxGenericColourDialog::OnRedSlider(wxCommandEvent& WXUNUSED(event))
{
  if (!redSlider)
    return;
    
  singleCustomColour.Set(redSlider->GetValue(), singleCustomColour.Green(), singleCustomColour.Blue());
  PaintCustomColour();
}

void wxGenericColourDialog::OnGreenSlider(wxCommandEvent& WXUNUSED(event))
{
  if (!greenSlider)
    return;

  singleCustomColour.Set(singleCustomColour.Red(), greenSlider->GetValue(), singleCustomColour.Blue());
  PaintCustomColour();
}

void wxGenericColourDialog::OnBlueSlider(wxCommandEvent& WXUNUSED(event))
{
  if (!blueSlider)
    return;

  singleCustomColour.Set(singleCustomColour.Red(), singleCustomColour.Green(), blueSlider->GetValue());
  PaintCustomColour();
}
