/*								-*- C++ -*-
 * $Id: UTL_misc.cpp,v 1.1 1996-09-25 11:31:58+02 mho Exp $
 *
 * Purpose: miscellaneous utilities
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#define  Uses_XLib
#define  Uses_wxFrame
#define  Uses_wxItem
#define  Uses_wxList
#define  Uses_wxMenuBar
#define  Uses_wxPanel
#define  Uses_wxWindow
#include "wx.h"

void wxBell(void)
{
    XBell(wxAPP_DISPLAY, 0);
}

long wxGetFreeMemory(void)
{
    return -1; // cannot determine amount (UNIX)
}

int wxGetOsVersion(int *majorVsn, int *minorVsn)
{
    if (majorVsn)  *majorVsn = X_PROTOCOL;
    if (minorVsn)  *minorVsn = XlibSpecificationRelease;
    return wxXT_X;
}

/*
 * informal routine about windows hierarchy
 */

void wxPrintChildren(wxWindow *window, int level)
{
    int	i;
    wxNode *node;

    fprintf(stderr, "wxWindows window hierarchy\n"
	            "--------------------------\n");
    for (i = 0; i < level; i++) fprintf(stderr,"  "); // insert for level
    fprintf(stderr, "%s\n", window->GetName());       // print name
    fflush(stderr);
    ++level;
    // print children
    for (node = window->GetChildren()->First(); node; node = node->Next())
        wxPrintChildren((wxWindow *)(node->Data()), level);
}

/*
 * wxWindows search function utilities
 */

static wxWindow *wxFindWindowByLabel1(char *title, wxWindow *parent);

wxWindow *wxFindWindowByLabel(char *title, wxWindow *parent)
{
    if (parent) {
	return wxFindWindowByLabel1(title, parent);
    } else {
	for (wxNode* node=wxTopLevelFrames.First(); node; node=node->Next()) {
	    wxWindow *win = (wxWindow*)node->Data();
	    wxWindow *retwin = wxFindWindowByLabel1(title, win);
	    if (retwin)
		return retwin;
	}
    }
    return NULL;
}

static wxWindow *wxFindWindowByLabel1(char *title, wxWindow *parent)
{
    if (parent) {
	char *lab = parent->GetLabel();
	if (lab && StringMatch(title, lab))
	    return parent;
    }
    if (parent) {
	for (wxNode *node=parent->GetChildren()->First(); node; node=node->Next()) {
	    wxWindow *win = (wxWindow*)node->Data();
	    wxWindow *retwin = wxFindWindowByLabel1(title, win);
	    if (retwin)
		return retwin;
	}
    }
    return NULL;
}

static wxWindow *wxFindWindowByName1(char *title, wxWindow *parent);

wxWindow *wxFindWindowByName(char *title, wxWindow *parent)
{
    if (parent) {
	return wxFindWindowByName1(title, parent);
    } else {
	for (wxNode *node=wxTopLevelFrames.First(); node; node=node->Next()) {
	    wxWindow *win = (wxWindow*)node->Data();
	    wxWindow *retwin = wxFindWindowByName1(title, win);
	    if (retwin)
		return retwin;
	}
    }
    // Failed? Try by label instead.
    return wxFindWindowByLabel(title, parent);
}

static wxWindow *wxFindWindowByName1(char *title, wxWindow *parent)
{
    if (parent) {
	char *lab = parent->GetName ();
	if (lab && StringMatch(title, lab))
	    return parent;
    }
    if (parent) {
	for (wxNode *node=parent->GetChildren()->First(); node; node=node->Next()) {
	    wxWindow *win = (wxWindow*)node->Data();
	    wxWindow *retwin = wxFindWindowByName1(title, win);
	    if (retwin)
		return retwin;
	}
    }
    return NULL;
}

int wxFindMenuItemId(wxFrame *frame, char *menuString, char *itemString)
{
    wxMenuBar *menuBar = frame->GetMenuBar();
    if (!menuBar)
	return -1;
    return menuBar->FindMenuItem(menuString, itemString);
}

wxWindow *wxGetActiveWindow(void)
{
    return wxAPP_ACTIVE_WINDOW;
}

Bool wxIsFrame(wxWindow *win)
{
    return (win && win->IsKindOf(CLASSINFO(wxFrame)));
}

Bool wxIsItem(wxWindow *win)
{
    return (win && win->IsKindOf(CLASSINFO(wxItem)));
}

Bool wxIsPanel(wxWindow *win)
{
    return (win && win->IsKindOf(CLASSINFO(wxPanel)));
}

wxWindow* wxFindFrame(wxWindow *win)
{
    /* find frame */
    for ( ; win; win = win->GetParent())
	if (wxIsFrame(win))
	    break;

    return win;
}

wxWindow* wxFindPanel(wxWindow *win)
{
    /* find panel */
    for ( ; win; win = win->GetParent())
	if (wxIsPanel(win))
	    break;

    return win;
}
