/*								-*- C++ -*-
 * $Id: WIN_text.cpp,v 1.3 1997-02-28 16:04:12+01 mho Exp $
 *
 * Purpose: text panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_text.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxText
#include "wx.h"
#define  Uses_EnforcerWidget
#define  Uses_ScrollTextWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy text
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxText, wxItem)
    
wxText::wxText(void) : wxItem()
{
    __type = wxTYPE_TEXT;

    quoted = FALSE;
}

wxText::~wxText(void)
{
}

wxText::wxText(wxPanel *panel, wxFunction function, Const char *label,
	       Constdata char *value, int x, int y, int width, int height,
	       long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_TEXT;

    quoted = FALSE;

    Create(panel, function, label, value, x, y, width, height, style, name);
}

Bool wxText::Create(wxPanel *panel, wxFunction function, Const char *label,
		    Constdata char *value, int x, int y, int width, int height,
		    long style, Constdata char *name)
{
    ChainToPanel(panel, style, name);

    // create frame
    FWidget() = XtVaCreateManagedWidget
	(name, xfwfEnforcerWidgetClass, GetParentWidget(parent),
	 XtNlabel,         label,
	 XtNalignment,     (label_position == wxVERTICAL) ? XfwfTop : XfwfLeft,
	 XtNbackground,    bg.GetPixel(&cmap),
	 XtNforeground,    label_fg.GetPixel(&cmap),
	 XtNfont,          label_font.GetInternalFont(),
	 XtNframeType,     XfwfSunken,
	 XtNframeWidth,    2,
// 	 XtNinnerVOffset,  2,
	 XtNshrinkToFit,   TRUE,
	 XtNtraversalKeys, XfwfTraverseKeyAll & (~(  XfwfTraverseKeyLeft | XfwfTraverseKeyRight | XfwfTraverseKeyHome)),
	 NULL);
    // create text widget
    HWidget() = XtVaCreateManagedWidget(name, scrollingTextWidgetClass, FWidget(),
					XtNborderWidth, 0,
					NULL);
    //  scrollingText- is a porthole containing a asciiText-Widget
    XtVaGetValues(HWidget(), XtNtextWidget, &(HWidget()), NULL);
    XtVaSetValues(HWidget(),
		  XtNbackground, bg.GetPixel(&cmap),
		  XtNforeground, fg.GetPixel(&cmap),
		  XtNfont,       font.GetInternalFont(),
		  XtNresize,     XawtextResizeBoth,
		  XtNstring,     value,
		  XtNeditType,   style & wxREADONLY ? XawtextRead : XawtextEdit,
		  XtNecho,       style & wxPASSWORD ? FALSE : TRUE,
		  NULL);
    // propagate key events from frame to text widget
    XtVaSetValues(FWidget(), XtNpropagateTarget, HWidget(), NULL);
    // callback
    callback = function;
    XtAddCallback(XawTextGetSource(HWidget()), XtNcallback,
		  wxText::EventCallback, (XtPointer)this);
    // position (and possibly resize) item
    if (width < 0) {
	width = wxTEXT_WIDTH;
	if (!(label_position == wxVERTICAL) && label) { // leave space for label
	    float lw, lh; GetTextExtent(label, &lw, &lh, NULL, NULL, &label_font);
	    width += int(lw);
	}
    }
    panel->PositionItem(this, x, y, width, height);
    // redisplay textfield
    XEvent dummy;
    memset(&dummy, 0, sizeof(dummy));
    XtCallActionProc(HWidget(), "redraw-display", &dummy, NULL, 0);
    AddEventHandlers();
    return TRUE;
}

//-----------------------------------------------------------------------------
// methods to set and get the value of wxText
//-----------------------------------------------------------------------------

char *wxText::GetValue(void)
{
    char *value;

    XtVaGetValues(HWidget(), XtNstring, &value, NULL);
    return value;
}

void wxText::SetValue(char *value)
{
    XtVaSetValues(HWidget(), XtNstring, value, NULL);
    ShowEnd();
}

void wxText::ShowEnd(void)
{
    XEvent event;
    memset(&event, 0, sizeof(event));
    XtCallActionProc(HWidget(), "end-of-file", (XEvent*)&event, NULL, 0);
}

//-----------------------------------------------------------------------------
// change editable mode for text item
//-----------------------------------------------------------------------------

void wxText::SetEditable(Bool editable)
{
    XtVaSetValues(HWidget(),
		  XtNeditType, (editable ? XawtextEdit : XawtextRead),
		  NULL);
}

//-----------------------------------------------------------------------------
// Handling for ENTER inside OnChar
//-----------------------------------------------------------------------------

void wxText::OnChar(wxKeyEvent &event)
{
    if (quoted) { // quoted keys are processed immediately
	quoted = FALSE;
	wxItem::OnChar(event);
	return;
    }

    // Clipboard accelarators
    XawTextPosition beginSel, endSel;
    XawTextGetSelectionPos(HWidget(), &beginSel, &endSel);

    if (event.keyCode == 'x' && event.MetaDown()) {
	Cut();
	return;
    } else if (event.keyCode == 'c' && event.MetaDown()) {
	Copy();
	return;
    } else if (event.keyCode == 'v' && event.MetaDown()) {
	Paste();
	return;
    } else if (event.keyCode == WXK_BACK) {
	if (beginSel != endSel) {
	    Delete();
	    return;
	}
    }

    switch (event.keyCode) {
    case 'q': case 'Q':
	if (event.ControlDown()) { // next character shall be printed as is
	    quoted = TRUE;
	    return;
	}
	break;
    case WXK_DELETE:
	if (beginSel != endSel)
	    Delete();
	else
	    XtCallActionProc(HWidget(), "delete-next-character",
			     (XEvent*)event.eventHandle, NULL, 0);		
	return;
    case WXK_HOME:
	XtCallActionProc(HWidget(), "beginning-of-line",
			 (XEvent*)event.eventHandle, NULL, 0);
	return;
    case WXK_END:
	XtCallActionProc(HWidget(), "end-of-line",
			 (XEvent*)event.eventHandle, NULL, 0);
	return;
    case WXK_RETURN:
	if (style & wxPROCESS_ENTER) {
	    // process enter to callback function
	    wxCommandEvent cevent(wxEVENT_TYPE_TEXT_ENTER_COMMAND);
	    cevent.eventObject   = this;
	    cevent.commandString = GetValue();
	    ProcessCommand(cevent);
	    return;
	} else { // if (style & wxPROCESS_ENTER_TO_PANEL) {
	    // pressing enter should invoke the default action
	    parent->GetEventHandler()->OnDefaultAction(this);
	    return;
	}
	break;
    case WXK_TAB:
	if (event.ShiftDown()) TravPrev(&event);
	else                   TravNext(&event);
	return;
    case WXK_UP:
	TravUp(&event);
	return;
    case WXK_DOWN:
	TravDown(&event);
	return;
    }
    wxItem::OnChar(event); // chain to parent method
}

//-----------------------------------------------------------------------------
// callbacks for textWidgetClass
//-----------------------------------------------------------------------------

void wxText::EventCallback(Widget WXUNUSED(w),
			   XtPointer clientData, XtPointer WXUNUSED(ptr))
{
    wxText         *text = (wxText*)clientData;
    wxCommandEvent event(wxEVENT_TYPE_TEXT_COMMAND);

    event.eventObject   = text;
    event.commandString = text->GetValue();

    text->ProcessCommand(event);
    
}

char* wxText::theClipBoard = NULL;

void wxText::Cut(void)
{
    Copy();
    Delete();
}

void wxText::Delete(void)
{
    XawTextPosition beginSel, endSel;
    XawTextGetSelectionPos(HWidget(),&beginSel,&endSel);
    if (beginSel == endSel)
	return;
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = 0;
    text_block.ptr = NULL;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), beginSel, endSel, &text_block);
    XawTextSetInsertionPoint(HWidget(), beginSel);
}

void wxText::Copy(void)
{
    XawTextPosition beginSel, endSel;
    XawTextGetSelectionPos(HWidget(),&beginSel,&endSel);
    if (beginSel == endSel) {
	wxMessageBox("error:No text selected!");
	return;
    }
    long length = endSel-beginSel;
	
    Widget src = XawTextGetSource(HWidget());
    XawTextBlock text_block;
    text_block.ptr = NULL;
    text_block.format = FMT8BIT;
    if(theClipBoard) {
	delete[] theClipBoard;
	theClipBoard=NULL;
    }
    theClipBoard = new char[length+1];
    XawTextSourceRead(src, beginSel, &text_block, length+1);
    strncpy(theClipBoard,text_block.ptr,length);
    theClipBoard[length]='\0';
}

void wxText::Paste(void)
{
    XawTextPosition beginSel, endSel;
    XawTextGetSelectionPos(HWidget(),&beginSel,&endSel);
    if (beginSel == endSel) { //in this case the above gives nonsense
	beginSel = XawTextGetInsertionPoint(HWidget());
	endSel = beginSel;
    }
    if (!theClipBoard)
	return;
    XawTextBlock text_block;
    text_block.firstPos = 0;
    text_block.length = strlen(theClipBoard);
    text_block.ptr = theClipBoard;
    text_block.format = FMT8BIT;
    XawTextReplace(HWidget(), beginSel, endSel, &text_block);
    XawTextPosition newSel = beginSel+strlen(theClipBoard);
    XawTextSetInsertionPoint(HWidget(), newSel);
}
