/*								-*- C++ -*-
 * $Id: WIN_panel.h,v 1.3 1997-01-30 09:55:28+01 mho Exp $
 *
 * Purpose: base class for all panels
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Panel_h
#define Panel_h

#ifdef __GNUG__
#pragma interface
#endif

class wxButton;
class wxColour;
class wxCommandEvent;
class wxFont;
class wxItem;
class wxItemResource;
class wxResourceTable;
class wxStaticItem;

class wxPanel : public wxWindow {
DECLARE_DYNAMIC_CLASS(wxPanel)
public:
    wxPanel(void); 
    wxPanel(wxWindow *parent, int x=-1, int y=-1, int width=-1, int height=-1,
	    int style=0, Constdata char *name=wxPanelNameStr);
    // panel creation
    Bool  Create(wxWindow *parent, 
		 int x=-1, int y=-1, int width=-1, int height=-1,
		 int style=0, Constdata char *name=wxPanelNameStr);
    // fit panel around items
    void  Fit(void);
    // override resize methods
    void  SetClientSize(int x, int y, int width, int height);
    void  SetClientSize(int width, int height)
	{ SetClientSize(-1, -1, width, height); }
    // data retrieved from wxItem and it's children
    wxColour  *GetButtonColour(void)	{ return &button_colour; }
    wxFont    *GetButtonFont(void)      { return &font; }
    wxColour  *GetLabelColour(void)     { return &label_colour; }
    wxFont    *GetLabelFont(void)       { return &label_font; }
    void      SetBackgroundColour(wxColour &col);
    void      SetButtonColour(wxColour &col)   { button_colour = col; }
    void      SetButtonFont(wxFont *font)      { wxWindow::SetFont(font); }
    void      SetLabelColour(wxColour &col)    { label_colour = col; }
    void      SetLabelFont(wxFont *font)       { label_font = font; }
    // position of labels
    int   GetLabelPosition(void)           { return label_pos; }
    void  SetLabelPosition(int position)   { label_pos = position; }
    // positioning of items
    void  GetCursor(int *x, int *y);
    Bool  GetFitOneChild(void) { return fit_one_child; }
    void  NewLine(void);
    void  NewLine(int pixels);
    void  PositionItem(wxWindow *win, int x, int y, int width, int height);
    void  Tab(void);
    void  Tab(int pixels);
    void  SetFitOneChild(Bool fit = TRUE) { fit_one_child = fit; }
    // margins and spacing
    int   GetHorizontalMargin(void)     { return h_margin; }
    int   GetHorizontalSpacing(void)    { return h_space; }
    int   GetVerticalMargin(void)       { return v_margin; }
    int   GetVerticalSpacing(void)      { return v_space; }
    void  SetHorizontalMargin(int m);
    void  SetHorizontalSpacing(int sp)  { h_space  = sp; }
    void  SetVerticalMargin(int m);
    void  SetVerticalSpacing(int sp)    { v_space  = sp; }
    // default item handling
    wxButton* GetDefaultItem(void)      { return default_item; }
    void      SetDefaultItem(wxButton *button);
    // drawing  of static items
    wxList& GetStaticItems(void) { return static_items; }
    void    AddStaticItem(wxStaticItem *the_item);
    void    RemoveStaticItem(wxStaticItem *the_item);
    void    DestroyStaticItem(wxStaticItem *the_item);
    void    DrawAllStaticItems(void);
    // wxXt specific
    void    DrawStaticLine(int x, int y, int length, Bool vertical = FALSE);
    void    DrawStaticBox(int x, int y, int w, int h);
    // methods for panel item placement
    void DoDragStart(wxItem *item, int x, int y, int keys, int handle);
    void DoDragContinue(wxItem *item, int x, int y, int keys, int handle);
    void DoDragEnd(wxItem *item, int x, int y, int keys, int handle);
    void OnEvent(wxMouseEvent& event);
    void OnItemEvent(wxItem *item, wxMouseEvent &event);
    void ProcessItemEvent(wxItem *item, wxMouseEvent &event,
			  int x, int y, int keys, int handle);
    void PaintSelectionHandles(Bool erase=FALSE);
    // slow dragging ... (default --> unused)
    Bool GetSlowDrag(void)		{ return TRUE; }
    void SetSlowDrag(Bool WXUNUSED(sl))	{ /**/ }
    // drawing
    wxPanelDC* GetPanelDC(void) { return (wxPanelDC*)GetDC(); }
    // event handling
    void OnDefaultAction(wxItem *item);
    Bool OnHotKey(wxKeyEvent& event);
    void OnPaint(void);
#if USE_WX_RESOURCES
    // resource loading facility
    Bool    LoadFromResource(wxWindow *parent, char *resourceName,
			     wxResourceTable *table = NULL);
    wxItem* CreateItem(wxItemResource *childResource, wxResourceTable *table = NULL);
#endif
protected:
    // resize before calls of OnMove and OnSize
    void PreResize(int x=-1, int y=-1, int width=-1, int height=-1);
protected:
    wxButton  *default_item;	// executed on default action
    wxColour  button_colour;    // colour for buttons
    wxColour  label_colour;     // colour for labels
    wxFont    label_font;	// font for labels
    int       label_pos;	// where to put the label
    int       orientation;	// add new items horizontally or vertically
    // for item positioning, if items are added without fixed positions
    int  cursor_x, cursor_y,
	 h_space, v_space, h_margin, v_margin,
	 line_extent;
    Bool fit_one_child;
    // static items to be drawn by the panel
    wxList static_items;
    // for panel item placement. since only ONE move/resize may be handled
    // at ONE time, I handle the variables as static.
    static int     drag_startx, drag_starty, drag_startw, drag_starth;
    static int     drag_rectx, drag_recty, drag_rectw, drag_recth;
    static int     drag_startcx, drag_startcy;
    static wxItem* drag_item;
    static int     drag_handle;
    static Bool    drag_moved;
};

#endif // Panel_h
