/* $Id: reapchld.inc,v 1.1 1997/10/23 03:42:44 mff Exp mff $ */
/*
 * Common part of SIGCHLD handling for diff.parts of binkd
 * Should be included in chld()
 */
{
  int old_errno = errno;
  int status;
  int pid;

#ifdef HAVE_WAITPID
  while ((pid = waitpid (-1, &status, WNOHANG)) > 0)	/* NO ";" !!! */
#else
  pid = (int) wait (&status);
#endif
  if (pid > 0)
  {
    Log (4, "rc(%i)=%i", pid, status);
  }

#ifdef SYS5SIGNALS
  signal (SIGCHLD, chld);
#endif
#ifdef EMXSIGNALS
  signal (SIGCHLD, SIG_ACK);
#endif
  errno = old_errno;
}
