#
# @(#)hexwin.tcl	1.1 97/06/05	steven@dante.org.uk (Steven Bakker)
#
# HExwin.tcl: Horizontal Exwin
#
# Source this file from User_Init in user.tcl.
# Based on exwin.tcl from the exmh-2.0gamma distribution.
#
# Main window layout for the application.
# This places the FToc and Message windows horizontally within
# the main exmh window.
#
# 19970605, SB: Layout FToc and Msg horizontally by replacing
#		Exwin_Layout with our own.
#
## First make sure the original stuff is loaded
auto_load Exwin_Init
#
# redefine Exwin_Layout
#
# This is roughly the same as the original routine, except:
#
#	(1) FToc and Message are put in separate frames.
#	(2) The two frames are re-packed with "-side right"
#
# Note that "detaching" either the FToc or Message window from
# the main window is now trivial:
#
#	(1) Change the Widget_Frame call(s) to Widget_Toplevel
#
proc Exwin_Layout {} {
    global exwin exmh

    set fixed {top fill}
    set expand {top fill expand}
    set exwin(grab) {}

    wm minsize . 100 100
    Flag_Init

    # Top row of buttons for global ops and version string
    set exwin(mainButtons) [Widget_Frame . main Main $fixed]
    Buttons_Main $exwin(mainButtons)
    Label_MainSetup $exwin(mainButtons)

    # Folders with unread messages
    Fdisp_Window [Widget_Frame . flist Fdisp $fixed]

 ## Create a frame for FToc stuff.
 ## The folder buttons and Ftoc display are put in here

    set exwin(ftocframe) [Widget_Frame . ftocframe Ftoc $expand]
    #set exwin(ftocframe) [Widget_Toplevel .ftocframe "Folder ToC"]
    pack propagate $exwin(ftocframe) 0

    # Second row of buttons for folder ops and current folder label
    set exwin(fopButtons) [Widget_Frame .ftocframe fops Fops $fixed]
    Buttons_Folder $exwin(fopButtons)
    Label_FolderSetup $exwin(fopButtons)

    # Folder display (Ftoc)
    set exwin(ftext) [Widget_Text [Widget_Frame .ftocframe ftoc Ftoc $expand] \
				$exwin(ftextLines)]
    Ftoc_Bindings $exwin(ftext)
    Ftoc_ColorConfigure $exwin(ftext)

 ## FTOC/MSG boundary changer
    # ExwinFtocMsgHBoundary $exwin(ftocframe)
    ExwinFtocMsgHBoundary . $exwin(ftocframe) 1 0

 ## Create a frame for Message stuff.
 ## The message buttons and display are put in here

    # Frame for faces, status, message buttons
    set exwin(msgframe) [Widget_Frame . msgframe Msg $expand]
    #set exwin(msgframe) [Widget_Toplevel .msgframe "Message Display"]
    pack propagate $exwin(msgframe) 0

    set mid     [Widget_Frame .msgframe mid Mid $fixed]
    Widget_SplitFrameR $mid Face Right
    Faces_Create $mid.left

    # Status line + MsgID
    set right $mid.right
    Widget_SplitFrameV $right Status Mops

    set exwin(status) [Widget_Entry $right.top msg {right expand fill}]
    set statusConfig [option get .msgframe statusConfig StatusConfig]
    if {[string length $statusConfig] > 0} {
        catch [concat $exwin(status) configure $statusConfig]
    }
    Label_MessageSetup $right.top
    # Status line does double-duty for folder/msg selection typein
    Select_EntryBind $exwin(status)

    # Buttons for message ops, plus display of current message id
    set exwin(mopButtons) $right.bot
    Buttons_Message $exwin(mopButtons)

    # Message display
    set exwin(mtext) [Widget_Text [Widget_Frame .msgframe msg Msg $expand] \
				$exwin(mtextLines)]
    Msg_Setup $exwin(mtext)
    Bindings_Main $exwin(mtext)

 ## Re-pack the two frames if necessary.  If one or both of them are
 ## Toplevel windows, there's no need to repack.
    if {([winfo toplevel .ftocframe] == ".") &&
	([winfo toplevel .msgframe] == ".")} {
	$exwin(mtext) configure -width 80
	$exwin(ftext) configure -width 40
	set exwin(mtextLines) $exwin(ftextLines);
	pack forget .ftocframe .msgframe
	pack .msgframe .ftocframe -side right \
		-fill both -anchor center -expand 1
    }

    #
    # Focus handling.  The message display is the default focus
    # because all the command keys are bound there.
    # The <FocusIn> binding is for when the user has "focus-follows-mouse"
    # and moves the mouse into the main window from, say, the sedit window.

    global tk_version
    if {$tk_version < 4.0} {
	focus default $exwin(mtext)
	bind . <FocusIn> [list focus $exwin(mtext)]
    } else {
	focus $exwin(mtext)
    }
}

proc ExwinFtocMsgHBoundary {root atframe {x 1.0} {y .5} {anchor center}} {
    global exwin

    # set w [frame $atframe.hboundary -width 10 -height 10 -borderwidth 2 -relief raised -cursor crosshair]
    # pack $w -side left

    set w [frame $root.hboundary -width 10 -height 10 -borderwidth 2 -relief raised -cursor crosshair]
    place $w -in $atframe -relx $x -rely $y -anchor $anchor
    set exwin(boundary) $w

    bind $w <ButtonPress-1> {ExwinFtocMsgHScroll %W %x %y}
    bind $w <B1-Motion> {ExwinFtocMsgHMove %W %x %y}
    bind $w <ButtonRelease-1> {ExwinFtocMsgHStop %W %x %y}
    return
}

proc ExwinTopX {w x} {
    # Find X hit relative to toplevel window
    set top [winfo toplevel $w]
    while {[string compare $w $top] != 0} {
	incr x [winfo x $w]
	set w [winfo parent $w]
    }
    incr x 2
    return $x
}

proc ExwinFtocMsgHScroll {grip x y} {
    global exwin
    $grip configure -relief sunken
    grab $grip
	
    set top [winfo toplevel $grip]
    if {$top == "."} {
	set exwin(sep) .sep
    } else {
	set exwin(sep) $top.sep
    }
    frame $exwin(sep) -width 4 -height 1 -borderwidth 2 -relief ridge
    place $exwin(sep) -x [ExwinTopX $grip $x] -y 0 -relheight 1 -anchor ne

    global fdisp
    Exmh_Status "Adjust FTOC and MSG subwindow boundaries"

    # Record x coordinate of right edge of each subwindow
    set exwin(xftoc) [ExwinTopX $exwin(ftext) [winfo width $exwin(ftext)]]
    if [info exists fdisp(cache)] {
	set exwin(xfcache) \
	    [ExwinTopX $fdisp(cache) [winfo width $fdisp(cache)]]
    } else {
	catch {unset exwin(xfcache)}
    }
    if {!$fdisp(toplevel)} {
	set exwin(xfdisp) \
	    [ExwinTopX $fdisp(canvas) [winfo width $fdisp(canvas)]]
    } else {
	catch {unset exwin(xfdisp)}
    }
}

proc ExwinFtocMsgHMove {grip x y} {
    global exwin
    place $exwin(sep) -x [ExwinTopX $grip $x]
}

proc ExwinFtocMsgHStop {grip x y} {
    global exwin
    $grip configure -relief raised
    grab release $grip

    catch {destroy $exwin(sep)}
    set dx [expr [ExwinTopX $grip $x] - $exwin(xftoc)]

    $exwin(ftocframe) configure -width [expr [winfo width $exwin(ftocframe)] + $dx]
    $exwin(msgframe)  configure -width [expr [winfo width $exwin(msgframe)] - $dx]

    Exmh_Debug "dx $dx"
    Exmh_Status ok
}

