## Copyright (C) 1996, 1997  Kurt Hornik
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## usage:  assoc (KEY, ALIST)
##
## If ALIST is a structure and KEY an existing index string, return the
## corresponding value;  otherwise, return an empty `list'.

## Author:  KH <Kurt.Hornik@ci.tuwien.ac.at>
## Description:  Look up key in an alist (structure)

function y = assoc (KEY, ALIST)

  if (nargin != 2)
    usage ("assoc (KEY, ALIST)");
  endif
    
  if !is_struct (ALIST)
    error ("assoc:  ALIST must be a structure");
  elseif !isstr (KEY)
    error ("assoc:  KEY must be a string");
  endif

  if (eval (sprintf ("struct_contains (ALIST, \"%s\");", KEY)))
    y = eval (sprintf ("ALIST.%s;", KEY));
  else
    y = [];
  endif

endfunction
