\name{fisher.test}
\title{Fisher's Exact Test for Count Data}
\usage{
fisher.test(x, y, alternative = "two.sided")
}
\alias{fisher.test}
\arguments{
  \item{x}{either a two-dimensional contingency table in matrix form, or
    a factor object.}
  \item{y}{a factor object; ignored if \code{x} is a matrix.} 
  \item{alternative}{indicates the alternative hypothesis and must be
    one of \code{"two.sided"}, \code{"greater"} or \code{"less"}.  You
    can specify just the initial letter.  Only used in the 2 by 2 case.}
}
\description{
  \code{fisher.test} performs Fisher's exact test for testing the null
  of independence of rows and columns in a contingency table with fixed
  marginals.

  If \code{x} is a matrix, it is taken as a two-dimensional contingency
  table, and hence its entries should be nonnegative integers.
  Otherwise, both \code{x} and \code{y} must be vectors of the same
  length.  Incomplete cases are removed, the vectors are coerced into
  factor objects, and the contingency table is computed from these.

  Currently, only 2 by 2 tables can be tested.
}
\value{
  A list with class \code{"htest"} containing the following components:
  \item{p.value}{the p-value of the test.}
  \item{alternative}{a character string describing the alternative
    hypothesis.} 
  \item{method}{the string \code{"Fisher's Exact Test for Count Data"}.}
  \item{data.name}{a character string giving the names of the data.}
}
