.TH SIAG 1 LOCAL

.SH NAME
siag \- Scheme In A Grid

.SH SYNOPSIS
.B siag
[X-options] [siod-options] [filename...]

.SH DESCRIPTION
.I Siag
is an X-based spreadsheet for Linux.
It uses Scheme both for expressions and as a macro language,
which makes it easy to create new functions. The Scheme interpreter
is 
.I Siod
written by George Carrette. 

Siag stands for Scheme In A Grid. 

.SH COMMAND LINE OPTIONS
.TP
.BI X-options
See on-line documentation.
.TP
.BI Siod-options
See on-line documentation.

.SH ENVIRONMENT
.TP
.BI HOME
is the name of the user's home directory.
.TP
.BI PRINTER
is the name of the default printer destination.
.TP
.BI SIAGHELP
is the name of Siag's online help browser, normally Chimera although
any HTML browser can be used.
.TP
.BI SIAGHOME
is the name of Siag's "home" directory, normally /usr/local/siag.

.SH FILES
.TP
.BI siag.scm
is automatically read on startup and contains a runtime library
including many of the functions that are necessary for normal
operation. Siag will not work properly without this file, which
should be installed in
.I $SIAGHOME/siag/siag.scm
.TP
.BI .siagrc
contains optional Scheme code which should be loaded after
siag.scm but before any documents. If found, it is loaded from
.I $HOME/.siagrc

.PD
.SH SEE ALSO
On-line documentation, which contains more complete information about the
invocation and usage of Siag.

.SH DIAGNOSTICS
Most error messages come from Siod and are printed on the bottom line.
See Siod source and documentation for interpretation.

.SH LIMITATIONS
Siag can only read and write its own file format. The program
.I txt2siag 
can convert from comma-separated text to Siag format.

The sheet can in theory contain up to 1000 lines with 1000 columns.
All the data is kept in memory, so the amount of virtual memory
limits the real maximum size.

All strings are stored in a statically allocated and pretty cramped
space. Identical strings are only stored once, so this is usually
not a problem.

.SH BUGS
Of course!

.SH VERSION
Current version (17 Jan 1997) is Siag 0.99 by Ulric Eriksson, 
ulric\@edu.stockholm.se. 

The online documentation is probably
more recent than this manpage and is likely to contain more
accurate information.

.SH AUTHOR
Copyright (C) 1996 Ulric Eriksson

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

.SH ACKNOWLEDGEMENTS
Major parts of this program are written by people other than myself.
There is no reason to re-implement stuff that is already freely available.

For copyright information and installation instructions, see the
various packages. The sources are hacked by Yours Truly to give the
programs a uniform look. If you don't approve of that and/or already
have the programs installed, there is no need to install my versions.

These are not the original versions. If my modifications break
anything, complain to me about it, not the original authors.
If the original versions work and mine don't, then don't use mine.
.TP
.BI Siod
The embedded Scheme interpreter is an extremely small interpreter
called Siod, which can be used stand-alone or easily integrated
into a program as an extension language.

Author: George J. Carrette, gjc\@newscorp.com

.TP
.BI Xaw3d
The 3D Athena widget replacement provides a Motif-ish look to
the program without the license cost.

Author: Kaleb S. Keithley, kaleb\@x.org
.TP
.BI Chimera
The html browser Chimera is used by Siag for displaying
help information.

Author: John Kilburg
.TP
.BI Ghostview
Ghostview is used by Siag for previewing the postscript output
prior to printing. It requires Ghostscript to interpret the
postscript code.

Author: Tim Theisen, tim@cs.wisc.edu
.TP
.BI Gnuplot
The plotting utility Gnuplot is used by Siag for plotting graphs
from information in spreadsheets.

Authors: Thomas Williams, Colin Kelley and others.

