/*
   Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the Licence, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/stat.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "xfonts.h"	/* from common */
#ifdef XPM
#include <X11/xpm.h>
#endif

#include "CanvasP.h"

#define offset(field) XtOffsetOf(CanvasRec, canvas.field)
static XtResource resources[] = {
	{
		XtNcanvasExpose,	/* name */
		XtCCanvasExpose,	/* class */
		XtRPointer,		/* type */
		sizeof(XtPointer),	/* size */
		offset(expose),		/* offset */
		XtRImmediate,		/* default_type */
		(XtPointer) NULL	/* default_addr */
	}, {
		XtNcanvasData,
		XtCCanvasData,
		XtRPointer,
		sizeof(XtPointer),
		offset(data),
		XtRImmediate,
		(XtPointer) NULL
	}
};
#undef offset

/* methods */
static void Redisplay();
static Boolean SetValues();

/* actions */
static void CanvasAction(Widget, XEvent *, String *, Cardinal *);

static XtActionsRec actions[] =
{
	{"canvas", CanvasAction},
};

/* translations */
static char translations[] =
"<Key>:		canvas()\n";

CanvasClassRec canvasClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &widgetClassRec,
    /* class_name		*/	"Canvas",
    /* widget_size		*/	sizeof(CanvasRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	NULL,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	translations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
  },
  { /* canvas fields */
    /* empty			*/	0
  }
};

WidgetClass canvasWidgetClass = (WidgetClass)&canvasClassRec;


/* supporting code copied directly from canvas.c */

static void CanvasAction(Widget w, XEvent *event, String *params, Cardinal *n)
{
	;
}

static void Redisplay(Widget w, XExposeEvent *event)
{
	CanvasWidget aw = (CanvasWidget) w;

	if (aw->canvas.expose)
		(*aw->canvas.expose)(w, aw->canvas.data);
}

static Boolean SetValues(Widget current, Widget request, Widget new)
{
	Boolean do_redisplay = True;

	return do_redisplay;
}

