/*
    Copyright (C) 1997  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * fonts.c
 */

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>

#include "../common/cmalloc.h"
#include "xfonts.h"

int font_size[8] = {8, 10, 12, 14, 18, 24, 20, 30};

siag_font fonts[128] = {
  {"Courier",
   "-*-courier-medium-r-*--*-80-75-75-*-*-*-*", NULL},
  {"Courier",
   "-*-courier-medium-r-*--*-100-75-75-*-*-*-*", NULL},
  {"Courier",
   "-*-courier-medium-r-*--*-120-75-75-*-*-*-*", NULL},
  {"Courier",
   "-*-courier-medium-r-*--*-140-75-75-*-*-*-*", NULL},
  {"Courier",
   "-*-courier-medium-r-*--*-180-75-75-*-*-*-*", NULL},
  {"Courier",
   "-*-courier-medium-r-*--*-240-75-75-*-*-*-*", NULL},
  {"Courier",
   "-*-courier-medium-r-*--*-200-75-75-*-*-*-*", NULL},
  {"Courier",
   "-*-courier-medium-r-*--*-300-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-80-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-100-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-120-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-140-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-180-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-240-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-200-75-75-*-*-*-*", NULL},
  {"Courier-Oblique",
   "-*-courier-medium-i-*--*-300-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-80-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-100-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-120-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-140-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-180-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-240-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-200-75-75-*-*-*-*", NULL},
  {"Courier-Bold",
   "-*-courier-bold-r-*--*-300-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-80-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-100-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-120-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-140-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-180-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-240-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-200-75-75-*-*-*-*", NULL},
  {"Courier-BoldOblique",
   "-*-courier-bold-i-*--*-300-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-80-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-100-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-120-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-140-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-180-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-240-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-200-75-75-*-*-*-*", NULL},
  {"Helvetica",
   "-*-helvetica-medium-r-*--*-300-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-80-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-100-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-120-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-140-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-180-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-240-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-200-75-75-*-*-*-*", NULL},
  {"Helvetica-Oblique",
   "-*-helvetica-medium-o-*--*-300-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-80-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-100-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-120-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-140-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-180-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-240-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-200-75-75-*-*-*-*", NULL},
  {"Helvetica-Bold",
   "-*-helvetica-bold-r-*--*-300-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-80-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-100-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-120-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-140-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-180-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-240-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-200-75-75-*-*-*-*", NULL},
  {"Helvetica-BoldOblique",
   "-*-helvetica-bold-o-*--*-300-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-80-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-100-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-120-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-140-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-180-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-240-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-200-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Roman",
   "-*-new century schoolbook-medium-r-*--*-300-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-80-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-100-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-120-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-140-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-180-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-240-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-200-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Italic",
   "-*-new century schoolbook-medium-i-*--*-300-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-80-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-100-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-120-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-140-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-180-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-240-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-200-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-Bold",
   "-*-new century schoolbook-bold-r-*--*-300-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-80-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-100-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-120-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-140-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-180-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-240-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-200-75-75-*-*-*-*", NULL},
  {"NewCenturySchlbk-BoldItalic",
   "-*-new century schoolbook-bold-i-*--*-300-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-80-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-100-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-120-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-140-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-180-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-240-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-200-75-75-*-*-*-*", NULL},
  {"Times-Roman",
   "-*-times-medium-r-*--*-300-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-80-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-100-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-120-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-140-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-180-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-240-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-200-75-75-*-*-*-*", NULL},
  {"Times-Italic",
   "-*-times-medium-i-*--*-300-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-80-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-100-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-120-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-140-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-180-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-240-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-200-75-75-*-*-*-*", NULL},
  {"Times-Bold",
   "-*-times-bold-r-*--*-300-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-80-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-100-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-120-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-140-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-180-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-240-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-200-75-75-*-*-*-*", NULL},
  {"Times-BoldItalic",
   "-*-times-bold-i-*--*-300-75-75-*-*-*-*", NULL}};

Font get_font(Display *display, int index)
{
  if (fonts[index].font != NULL) return fonts[index].font->fid;
  fonts[index].font = XLoadQueryFont(display, fonts[index].name);
  if ((fonts[index].font)) {
    return fonts[index].font->fid;
  }
  fonts[index].font = XLoadQueryFont(display, "*helvetica-medium-r*10*");
  if ((fonts[index].font)) {
    return fonts[index].font->fid;
  }
  fprintf(stderr, "Panic: can't load any fonts!\n");
  exit(1);
}

XFontStruct *font_struct(Display *display, int index)
{
  if (fonts[index].font == NULL) get_font(display, index);
  return fonts[index].font;
}

int font_ascent(Display *display, int index)
{
  return font_struct(display, index)->max_bounds.ascent;
}

int font_descent(Display *display, int index)
{
  return font_struct(display, index)->max_bounds.descent;
}

int font_height(Display *display, int index)
{
  return font_ascent(display, index)+font_descent(display, index);
}

siag_color colors[8] = {
	{"black", 0},
	{"red", 0},
	{"green", 0},
	{"blue", 0},
	{"yellow", 0},
	{"magenta", 0},
	{"cyan", 0},
	{"white", 0}};

void init_color(Display *display)
{
	int i;

	for (i = 0; i < 8; i++) {
		XColor screen_color, exact_color;
		Colormap cmap = DefaultColormap(display, DefaultScreen(display));
		XAllocNamedColor(display, cmap,
			colors[i].name,
			&screen_color, &exact_color);

		/* check status here; 0 means error */
		colors[i].pixel = screen_color.pixel;
	}
}

unsigned long get_color(Display *display, int index)
{
	return colors[index].pixel;
}

