#include "defs.h"
#include "Garmin.h"


Frame      frame, AboutFrame, QuitFrame;
Panel      panel, AboutPanel, QuitPanel;
Canvas     canvas;
Display    *display;
Window     Canvas_window;
Menu       MenuFrom, MenuTo;
GC         gc;
int        screen_num, dsp_width, dsp_height;

/* Define local Constants */
#define FrameSizeX       320
#define FrameSizeY       180


/* Define Icon-Images */
short ImageBits[] = {
#include "gpstrans.icon"
};

short IconBits[] = {
#include "icon.icon"
};




extern void MenuHandleAbout();
extern void MenuHandlePreferences();
extern void MenuHandleFrom();
extern void MenuHandleTo();
extern void CreateBarGraph();
extern void SetPosition();
extern void InitPrefs();
extern char *getGPSVersion();



void SetFrameBusy(int i)
{
  if (i == 0) {
    xv_set(frame, FRAME_BUSY, FALSE, NULL);
    return;
  }
  xv_set(frame, FRAME_BUSY, TRUE, NULL);
}


void NotResponding()
{
  char   temp[255];

  sprintf(temp, "GPS is not responding - make sure it is set to GRMN/GRMN %s",
                "protocol.");
  Message(temp);
}


void CreateAboutWindow()
{
  char           temp[255];
  int            AboutWidth, i;
  Server_image   AboutImage;
  Panel          ab[6];


  sprintf(temp, "About %s", ProgramName);
  AboutFrame = (Frame) xv_create(frame,        FRAME_CMD,
				 XV_WIDTH,     10,
				 XV_HEIGHT,    10,
				 FRAME_LABEL,  temp,
				 FRAME_SHOW_FOOTER, TRUE,
				 NULL);

  AboutPanel = (Panel) xv_create(AboutFrame,   PANEL, NULL);

  AboutImage = (Server_image) xv_create(X_NULL,            SERVER_IMAGE,
					XV_WIDTH,          160,
					XV_HEIGHT,         175,
					SERVER_IMAGE_BITS, ImageBits,
					NULL);

  ab[0] = xv_create(AboutPanel,         PANEL_MESSAGE,
		    XV_X,               10,
		    XV_Y,               10,
		    PANEL_LABEL_IMAGE,  AboutImage,
		    NULL);

  sprintf(temp, "Version %s", ProgramVersion);
  ab[1] = xv_create(AboutPanel,         PANEL_MESSAGE,
		    PANEL_LABEL_BOLD,   TRUE,
		    PANEL_LABEL_STRING, temp,
		    XV_X,                10,
		    XV_Y,               210,
		    NULL);

  sprintf(temp, "Copyright %c %s by", (char)169, ProgramYear);
  ab[2] = xv_create(AboutPanel,         PANEL_MESSAGE,
		    PANEL_LABEL_BOLD,   TRUE,
		    PANEL_LABEL_STRING, temp,
		    XV_X,                10,
		    XV_Y,               250,
		    NULL);

  sprintf(temp, "Carsten Tschach  (tschach@zedat.fu-berlin.de)");
  ab[3] = xv_create(AboutPanel,         PANEL_MESSAGE,
		    PANEL_LABEL_BOLD,   TRUE,
		    PANEL_LABEL_STRING, temp,
		    XV_X,                10,
		    XV_Y,               265,
		    NULL);

  sprintf(temp, "Based on MacGPS by");
  ab[4] = xv_create(AboutPanel,         PANEL_MESSAGE,
		    PANEL_LABEL_BOLD,   FALSE,
		    PANEL_LABEL_STRING, temp,
		    XV_X,                10,
		    XV_Y,               300,
		    NULL);

  sprintf(temp, "John F. Waers  (jfwaers@csn.net)");
  ab[5] = xv_create(AboutPanel,         PANEL_MESSAGE,
		    PANEL_LABEL_BOLD,   FALSE,
		    PANEL_LABEL_STRING, temp,
		    XV_X,                10,
		    XV_Y,               315,
		    NULL);

  window_fit(AboutPanel);
  window_fit(AboutFrame);

  AboutWidth = xv_get(AboutPanel, XV_WIDTH);
  for (i = 0; i <= 5; i++)
    xv_set(ab[i], XV_X, ((AboutWidth - xv_get(ab[i], XV_WIDTH)) / 2), NULL);

  xv_set(AboutFrame, XV_X, (dsp_width - AboutWidth - 30), XV_Y, 20, NULL);
}


void MenuHandleAbout()
{
  char   temp[255];

  if (xv_get(AboutFrame, FRAME_CMD_PUSHPIN_IN) == TRUE) 
    xv_set(AboutFrame, FRAME_CMD_PUSHPIN_IN, FALSE,
                        XV_SHOW,              FALSE,
                        NULL);
  else {
    sprintf(temp, "%s", getGPSVersion());
    xv_set(AboutFrame, FRAME_LEFT_FOOTER, "Connected GPS is:", NULL);
    xv_set(AboutFrame, FRAME_RIGHT_FOOTER, temp, NULL);

    xv_set(AboutFrame, XV_SHOW,              TRUE, 
                        FRAME_CMD_PUSHPIN_IN, TRUE,
                        NULL);
  }
}



void DoReallyQuit()
{
  xv_destroy_safe(frame);
  exit(0);
}

void DoTurnOffQuit()
{
  serialOpen(GARMIN);
  sendGPSMessage(off1, 4);
  serialClose();
  DoReallyQuit();
}

void DoCancelQuit()
{
  xv_set(QuitFrame, FRAME_CMD_PUSHPIN_IN, FALSE,
	            XV_SHOW,              FALSE,
	 NULL);

  xv_set(frame, FRAME_BUSY, FALSE, NULL);
}

/*****************************************************************************/
/* Close the windows and quit.                                               */
/*****************************************************************************/
void CreateQuitWindow()
{
  int   QuitWidth, QuitHeight;


  QuitFrame = (Frame) xv_create(frame,             FRAME_CMD,
				XV_WIDTH,          10,
				XV_HEIGHT,         10,
				FRAME_LABEL,       "Exiting program...",
				NULL);

  QuitPanel = (Panel) xv_create(QuitFrame, PANEL, NULL);

  xv_create(QuitPanel,  PANEL_MESSAGE,
	    XV_X,       60,
	    XV_Y,       10,
	    PANEL_LABEL_BOLD, TRUE,
	    PANEL_LABEL_STRING, "Turn off GPS Receiver?           ",
	    NULL);

  xv_create(QuitPanel,  PANEL_BUTTON,
	    XV_X,       10,
	    XV_Y,       50,
	    PANEL_LABEL_STRING, "Turn off",
	    PANEL_NOTIFY_PROC,  DoTurnOffQuit,
	    NULL);

  xv_create(QuitPanel,  PANEL_BUTTON,
	    XV_X,       105,
	    XV_Y,       50,
	    PANEL_LABEL_STRING, "Just Quit",
	    PANEL_NOTIFY_PROC, DoReallyQuit,
	    NULL);

  xv_create(QuitPanel,  PANEL_BUTTON,
	    XV_X,       200,
	    XV_Y,       50,
	    PANEL_LABEL_STRING, "Cancel",
	    PANEL_NOTIFY_PROC, DoCancelQuit,
	    NULL);

  window_fit(QuitPanel);
  window_fit(QuitFrame);

  QuitWidth  = (int) xv_get(QuitFrame, XV_WIDTH);
  QuitHeight = (int) xv_get(QuitFrame, XV_HEIGHT);

  xv_set(QuitFrame, XV_X, (int) ((dsp_width - QuitWidth) / 2),
                    XV_Y, (int) ((dsp_height / 2) - (QuitHeight / 2)),
	 NULL);
}



void MenuPointQuit() 
{
  xv_set(QuitFrame, FRAME_CMD_PUSHPIN_IN, TRUE,
	            XV_SHOW,              TRUE,
	 NULL);
}

void MenuNoQuit()
{
  xv_set(QuitFrame, FRAME_CMD_PUSHPIN_IN, FALSE,
	            XV_SHOW,              FALSE,
         NULL);
}


/*****************************************************************************/
/* Catch Signals to get grateful death.                                      */
/*****************************************************************************/
void TerminateHandler(sig)
int   sig;
{
  if (sig == SIGINT) {
    fprintf(stderr, "\nDon't touch me...but you've pressed CTRL-C\n");
    fprintf(stderr, "It was you choice....exiting\n");
  } else {
    fprintf(stderr, "\nGotcha...somebody try to shot me...but he missed !\n");
    fprintf(stderr, "\nBut okay, commiting suicide....<argh!>\n");
  }
  exit(0);
}

/*****************************************************************************/
/*                        H a u p t p r o g r a m m                          */
/*****************************************************************************/
main(argc, argv)
int  argc;
char *argv[];
{
  Icon             icon;
  Server_image     MenuPointImage, MainIcon;

  /* Initialisieren und Oeffen des Windows */
  xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
 
  frame = (Frame) xv_create(X_NULL, FRAME,
                            XV_WIDTH,           FrameSizeX,
                            XV_HEIGHT,          FrameSizeY,
                            FRAME_MIN_SIZE,     FrameSizeX, FrameSizeY,
                            FRAME_MAX_SIZE,     FrameSizeX, FrameSizeY,
                            FRAME_LABEL,        MainMenuHeader,
			    NULL);

  /* Erzeugen der Buttons zum redraw und aendern des Wertes */
  panel = (Panel) xv_create(frame, PANEL, NULL);

  /* Anzeigen des Images */
  MenuPointImage = (Server_image) xv_create(X_NULL, SERVER_IMAGE,
                                       XV_WIDTH,          160,
                                       XV_HEIGHT,         175,
                                       SERVER_IMAGE_BITS, ImageBits,
                                       NULL);

  xv_create(panel, PANEL_MESSAGE,
            PANEL_LABEL_IMAGE,    MenuPointImage,
            NULL);


  /* Erzeuge Sub-Menues fuer up- und download */
  MenuFrom = (Menu) xv_create(X_NULL, MENU,
			      MENU_TITLE_ITEM,     "Transfer from GPS...",
		   	      MENU_NOTIFY_PROC,    MenuHandleFrom,
			      MENU_STRINGS,        "Almanac", "Routes", 
			                           "Track Log", "Waypoints",
			                           NULL,
			      NULL);

  MenuTo   = (Menu) xv_create(X_NULL, MENU,
			      MENU_TITLE_ITEM,     "Transfer to GPS...",
		   	      MENU_NOTIFY_PROC,    MenuHandleTo,
			      MENU_STRINGS,        "Routes", 
			                           "Track Log", "Waypoints",
			                           NULL,
			      NULL);


  /* Erzeugen der Menupunkte */
  xv_create(panel, PANEL_BUTTON,
            PANEL_LABEL_STRING,   "Transfer to GPS",
	    PANEL_ITEM_MENU,      MenuTo,
	    PANEL_NOTIFY_PROC,    SetPosition,
            PANEL_LABEL_WIDTH,    110,
            XV_X,                 170,
            XV_Y,                  10,
            NULL);

  xv_create(panel, PANEL_BUTTON,
            PANEL_LABEL_STRING,   "Transfer from GPS",
	    PANEL_ITEM_MENU,      MenuFrom, 
	    PANEL_NOTIFY_PROC,    SetPosition,
            PANEL_LABEL_WIDTH,    110,
            XV_X,                 170,
            XV_Y,                  35,
            NULL);

  xv_create(panel, PANEL_BUTTON,
            PANEL_LABEL_STRING,   "Quit",
	    PANEL_NOTIFY_PROC,    MenuPointQuit, 
	    PANEL_LABEL_WIDTH,    125,
            XV_X,                 170,
            XV_Y,                 150,
            NULL);

  xv_create(panel, PANEL_BUTTON,
            PANEL_LABEL_STRING,   "About",
	    PANEL_NOTIFY_PROC,    MenuHandleAbout,
	    PANEL_LABEL_WIDTH,    125,
            XV_X,                 170,
            XV_Y,                 110,
            NULL);

  xv_create(panel, PANEL_BUTTON,
            PANEL_LABEL_STRING,   "Preferences",
	    PANEL_NOTIFY_PROC,    MenuHandlePreferences,
	    PANEL_LABEL_WIDTH,    125,
            XV_X,                 170,
            XV_Y,                  60,
            NULL);


  /* Initialisieren des Icons */
  MainIcon = (Server_image) xv_create(X_NULL, SERVER_IMAGE,
                                      XV_WIDTH,           64,
                                      XV_HEIGHT,          64,
                                      SERVER_IMAGE_BITS,  IconBits,
				      XV_APP_NAME, "GPStrans",
                                      NULL);

  icon = (Icon) xv_create(frame, ICON,
                          ICON_TRANSPARENT,       TRUE,
                          ICON_IMAGE,             MainIcon,
                          XV_X,                   100,
                          XV_Y,                   100,
                          NULL);

  xv_set(frame, FRAME_ICON, icon, NULL);


  /* Initialisieren der Variablen */
  display       = (Display *) xv_get(frame, XV_DISPLAY, NULL);
  gc            = DefaultGC(display, DefaultScreen(display));

  screen_num    = DefaultScreen(display);
  dsp_width     = DisplayWidth (display, screen_num);
  dsp_height    = DisplayHeight(display, screen_num);


  /* Position Main-Window */
  xv_set(frame, XV_X, 20, XV_Y, (dsp_height - FrameSizeY - 50), NULL);

  /* Initialize Signal-Handler */
  signal(SIGTERM, TerminateHandler);
  signal(SIGINT,  TerminateHandler);

  CreateAboutWindow();
  CreateBarGraph(); 
  CreatePrefsWindow();
  CreateQuitWindow();
  InitPrefs();

  xv_main_loop(frame);
} 

