/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@sdsu.edu>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * $Id: sendfont.c,v 2.1 1997/01/05 18:41:45 papowell Exp $
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"


int sendfont(fontfilename)
char *fontfilename;
{
	FILE *ffp;
	int n;
	char buffer[128];

	log(4,"sendfont: sending font '%s'", fontfilename );


	if ((ffp=fopen(fontfilename,"r")) == NULL) {
		logerr(1,"sendfont: cannot open file '%s'",fontfilename);
		return(1);
	}

	log(4,"sendfont: sending ASSIGN string '%s'", ASSIGN );

	write_check(STDOUT, ASSIGN, "sendfont: cannot send ASSIGN font string", DIE);

	while ((n = fread( buffer, 1, sizeof(buffer), ffp)) > 0 ){
		if( writecn( STDOUT, buffer, n ) != n ){
			errorcode = JABORT;
			fatal( "cannot load font file '%s' to printer", fontfilename );
		}
	}
	fclose(ffp);

	write_check(STDOUT, PGRESET, "Cannot send PGRESET font string", DIE);
	write_check(STDOUT, ASSIGN, "Cannot send ASSIGN string", DIE);
	write_check(STDOUT, MKPRIM, "Cannot send MKPRIM string", DIE);
	write_check(STDOUT, MKPERM, "Cannot send MKPERM string", DIE);

	log(4,"sendfont: done");
	return(0); /* success */
};

