/*
 * Here we define how our menus are held
 *
 * @(#)$Id: menu.h,v 1.4 1994/07/02 02:38:10 mrg Exp $
 */

#ifndef _MENU_H_
#define _MENU_H_

#define IRCII_MENU_H
#include "irc_std.h"

#define	SMF_ERASE	0x0001
#define	SMF_NOCURSOR	0x0002
#define	SMF_CURSONLY	0x0004
#define	SMF_CALCONLY	0x0008

struct	MenuOptionTag
{
	char	*Name;
	char	*Arguments;
	void	(*Func) _((char *));
};

typedef	struct	MenuOptionTag	MenuOption;

struct	MenuTag
{
	struct	MenuTag	*next;
	char	*Name;
	int	TotalOptions;
	MenuOption	**Options;
};

typedef struct MenuTag Menu;

struct WindowStru;

/* Below are our known menu functions */
extern	void	menu_previous _((char *));	/* Go to previous menu */
extern	void	menu_submenu _((char *));	/* Invoke a submenu */
extern	void	menu_exit _((char *));		/* Exit the menu */
extern	void	menu_channels _((char *));	/* List of channels menu */
extern	void	menu_command _((char *));	/* Invoke an IRCII command */
extern	void	menu_key _((char));
extern	void	load_menu _((char *));
extern	void	ListMenu _((char *));
extern	int	ShowMenu _((char *));
extern	int	ShowMenuByWindow _((struct WindowStru *, int));
extern	void	enter_menu _((char, char *));

#endif /* _MENU_H_ */
