#
# Information about who is compiling the binary....
# This file is in the public domain, such as it is.
#

info_c_sum=`cksum info.c.sh`
comp_host=`uname -n`
comp_user=$LOGNAME
comp_time=`date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

# Dump the C file...
cat > info.c << __E__O__F__
/*
 * info.c -- info about who compiled this version.
 * This file is auto-magically created.   Changes will be nuked.
 */

#ifdef __STDC__
#define my_paste(x, y, z) x ## y ## z
#else
#define my_paste(x, y, z) x/**/y/**/z
#endif

#include "config.h"
#ifdef ANONYMOUS_COMPILE
#define USER "<anonymous>"
#else
#define USER "$comp_user"
#endif

char *compile_user = "$comp_user";
char *compile_host = "$comp_host";
char *compile_time = "$comp_time";
char *info_c_sum   = "$info_c_sum";
char *compile_info = my_paste("Compiled by ", USER, "@$comp_host on $comp_time");

__E__O__F__
