/***

menurt.c- ncurses-based menu definition module
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997, 1998

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

***/

#include <curses.h>
#include <panel.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include "deskman.h"
#include "attrs.h"
#include "menurt.h"

/* initialize menu system */

void initmenu(struct MENU *menu, int y1, int x1, int y2, int x2)
{
    menu->itemlist = NULL;
    menu->itemcount = 0;
    strcpy(menu->shortcuts, "");
    menu->x1 = x1;
    menu->y1 = y1;
    menu->x2 = x2;
    menu->y2 = y2;
    menu->menuwin = newwin(y1, x1, y2, x2);
    menu->menupanel = new_panel(menu->menuwin);

    keypad(menu->menuwin, 1);
    meta(menu->menuwin, 1);
    noecho();
    wtimeout(menu->menuwin, -1);	/* block until input */
    notimeout(menu->menuwin, 0);	/* disable Esc timer */
    nonl();
    cbreak();
}

/* add menu item */

void additem(struct MENU *menu, char *item, char *desc)
{
    struct ITEM *tnode;
    char cur_option[49];
    char thekey[2];
    tnode = malloc(sizeof(struct ITEM));

    strcpy(tnode->option, item);
    strcpy(tnode->desc, desc);

    if (menu->itemlist == NULL) {
	menu->itemlist = tnode;
    } else {
	menu->lastitem->next = tnode;
	tnode->prev = menu->lastitem;
    }

    menu->itemlist->prev = tnode;
    menu->lastitem = tnode;
    tnode->next = menu->itemlist;
    menu->itemcount++;

    strcpy(cur_option, item);
    strtok(cur_option, "^");
    strcpy(thekey, strtok(NULL, "^"));
    thekey[0] = toupper(thekey[0]);
    strcat(menu->shortcuts, thekey);
}

/* show each individual item */

void showitem(struct MENU *menu, struct ITEM *itemptr, int selected)
{
    int hiattr = 0;
    int loattr = 0;
    int ctr;
    char curoption[49];
    char padding[45];

    switch (selected) {
    case NOTSELECTED:
	hiattr = HIGHATTR;
	loattr = STDATTR;
	break;
    case SELECTED:
	hiattr = BARHIGHATTR;
	loattr = BARSTDATTR;
	break;
    }

    strcpy(curoption, itemptr->option);

    wattrset(menu->menuwin, loattr);
    wprintw(menu->menuwin, "%s", strtok(curoption, "^"));
    wattrset(menu->menuwin, hiattr);
    wprintw(menu->menuwin, "%s", strtok((char *) NULL, "^"));
    wattrset(menu->menuwin, loattr);
    wprintw(menu->menuwin, "%s", strtok((char *) NULL, "^"));

    strcpy(padding, "");

    for (ctr = strlen(itemptr->option); ctr <= menu->x1 - 1; ctr++)
	strcat(padding, " ");

    wprintw(menu->menuwin, "%s", padding);

    update_panels();
    doupdate();
}

/* repeatedly calls showitem to display individual items */

void showmenu(struct MENU *menu)
{
    struct ITEM *itemptr;	/* points to each item in turn */
    int ctr = 1;		/* counts each item */

    wattrset(menu->menuwin, BOXATTR);	/* set to bg+/b */
    colorwin(menu->menuwin);	/* color window */
    box(menu->menuwin, ACS_VLINE, ACS_HLINE);	/* draw border */

    itemptr = menu->itemlist;	/* point to start */

    wattrset(menu->menuwin, STDATTR);

    do {			/* display items */
	wmove(menu->menuwin, ctr, 1);
	showitem(menu, itemptr, NOTSELECTED);	/* show items, initially unselected */
	ctr++;
	itemptr = itemptr->next;
    } while (ctr <= menu->itemcount);

    update_panels();
    doupdate();
}

void menumoveto(struct MENU *menu, struct ITEM **itemptr, unsigned int row)
{
    struct ITEM *tnode;
    unsigned int i;

    tnode = menu->itemlist;
    for (i = 1; i < row; i++)
	tnode = tnode->next;

    *itemptr = tnode;
}

/* actually to the menu operation after all the initialization */

void operatemenu(struct MENU *menu, int *position, int *aborted)
{
    struct ITEM *itemptr;
    int row = *position;
    int exitloop = 0;
    int ch;
    char *keyptr;

    menukeyhelp();
    *aborted = 0;
    menumoveto(menu, &itemptr, row);

    menu->descwin = newwin(1, 80, 23, 0);
    menu->descpanel = new_panel(menu->descwin);

    do {
	wmove(menu->menuwin, row, 1);
	showitem(menu, itemptr, SELECTED);

	/* ---------- describe item ----------- */
	wattrset(menu->descwin, DESCATTR);
	colorwin(menu->descwin);
	wmove(menu->descwin, 0, 0);
	wprintw(menu->descwin, " %s", itemptr->desc);
	update_panels();
	doupdate();
	/* -------- end description ----------- */

	wmove(menu->menuwin, row, 2);
	ch = wgetch(menu->menuwin);
	wmove(menu->menuwin, row, 1);
	showitem(menu, itemptr, NOTSELECTED);

	switch (ch) {
	case KEY_UP:
	    if (row == 1)
		row = menu->itemcount;
	    else
		row--;

	    itemptr = itemptr->prev;
	    break;
	case KEY_DOWN:
	    if (row == menu->itemcount)
		row = 1;
	    else
		row++;

	    itemptr = itemptr->next;
	    break;
	case 13:
	    exitloop = 1;
	    break;
	    /* case 27: exitloop = 1;*aborted = 1;row=menu->itemcount;break; */
	default:
	    keyptr = strchr(menu->shortcuts, toupper(ch));
	    if ((keyptr != NULL) && keyptr - menu->shortcuts < menu->itemcount) {
		row = keyptr - menu->shortcuts + 1;
		exitloop = 1;
	    }
	}
    } while (!(exitloop));

    *position = row;		/* position of executed option is in *position */
    del_panel(menu->descpanel);
    delwin(menu->descwin);
    update_panels();
    doupdate();
}


void destroymenu(struct MENU *menu)
{
    struct ITEM *tnode;
    struct ITEM *tnextnode;

    if (menu->itemlist != NULL) {
	tnode = menu->itemlist;
	tnextnode = menu->itemlist->next;

	tnode->prev->next = NULL;

	while (tnode != NULL) {
	    free(tnode);
	    tnode = tnextnode;

	    if (tnextnode != NULL)
		tnextnode = tnextnode->next;
	}
    }
    del_panel(menu->menupanel);
    delwin(menu->menuwin);
    update_panels();
    doupdate();
}
