/***

utfdefs.h - declarations for the UDP/TCP filter module
Written by Gerard Paul Java
Copyright (c) Gerard Paul Java 1997

***/

#define F_TCP 0
#define F_UDP 1

struct filterfileent {
    char desc[35];
    char filename[40];
};

struct hostparams {
    char s_fqdn[25];
    char d_fqdn[25];
    char s_mask[20];
    char d_mask[20];
    unsigned int sport;
    unsigned int dport;
};

struct filterent {
    struct hostparams hp;
    unsigned long saddr;
    unsigned long daddr;
    unsigned long smask;
    unsigned long dmask;
    unsigned int index;
    struct filterent *next_entry;
    struct filterent *prev_entry;
};

struct filterlist {
    struct filterent *head;
    struct filterent *tail;
    unsigned int lastpos;

    WINDOW *borderwin;
    PANEL *borderpanel;
    WINDOW *filterwin;
    PANEL *filterpanel;
};

struct ffnode {
    struct filterfileent ffe;
    struct ffnode *next_entry;
    struct ffnode *prev_entry;
};
