/*
 * lftp and utils
 *
 * Copyright (c) 1996-1997 by Alexander V. Lukyanov (lav@yars.free.net)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <config.h>
#include "SignalHook.h"

int  SignalHook::counts[256];
void (*(SignalHook::old_handlers[256]))(int);

void SignalHook::cnt_handler(int sig)
{
   counts[sig]++;
   signal(sig,cnt_handler);
}

void SignalHook::set_signal(int sig,void (*handler)(int))
{
   void (*old)(int);
   old=signal(sig,SIG_IGN);
   if(old!=(void(*)(int))SIG_IGN)
      signal(sig,handler);
   if(old_handlers[sig]==0)
      old_handlers[sig]=old;
}

void SignalHook::Restore(int i)
{
   if(old_handlers[i]!=0)
      signal(i,old_handlers[i]);
}

void SignalHook::RestoreAll()
{
   for(int i=0; i<256; i++)
      Restore(i);
}
