.COMMENT SccsID: @(#) Xp.man 1.1 92/03/18 11:17:08
.TH "Xp" 1 "1 March 1992"
.SH NAME
Xp \- Xt and Athena Public Library
.SH SYNOPSIS
.ta 1.5i 2.5i
.nf
.ft B
#include <X11/Intrinsic.h>
#include <X11/Wc/WcCreate.h>
#include <X11/Xp/Xp.h>

/* All Wcl applications should provide at least the Wcl options:
*/
static XrmOptionDescRec options[] = {
    ... application specific command line options ...
    WCL_XRM_OPTIONS
};

main ( argc, argv )
    int    argc;
    char*  argv[];
{
    /*  -- Intialize Toolkit creating the application shell
    */
    Widget appShell = XtInitialize (
        argv[0], WcAppClass( argc, argv ),      /* app name & class  */
        options, XtNumber(options),             /* argv option descr */
        &argc, argv
    );
    XtAppContext app = XtWidgetToApplicationContext(appShell);

    /*  -- Register application specific callbacks and widget classes
    */
    RegisterApplication ( app );

    /*  -- Register all widget classes and constructors
    */
    XpRegisterAthena( app );

    /*  -- Create widget tree below toplevel shell using Xrm database
    */
    if ( WcWidgetCreation ( appShell ) )
        exit(1);

    /*  -- Realize the widget tree
    */
    XtRealizeWidget ( appShell );

    /*  -- and finally, enter the main application loop
    */
    XtMainLoop ( );
}
.fi
.ft R

.SH LINK BY
.RS
.nf
.ft B
example% ld -o prog prog.o -lXp -lXaw -lWc <dynLinkLib> -lXmu -lXt -lX11 -lm
.ft R
.RE
.LP 
On SunOS or SVR4 machines, the <dynLinkLib> is named -ldl.
Other architectures cannot use the dynamic linking capabilites of
Wcl, and therefore do not need any dynamic link library.
.SH DESCRIPTION
.LP
.I Xp
is intended to be used with
.I Wcl
and the Athena widget set.  Xp provides a procedure for registering all
Athena widgets, and includes the XpTable widget.
.SH REGISTRATION PROCEDURES
.LP
.I Wcl
must be told the names of all widgets and widget constructors before
it can create widgets as specified in the resource file of client
applications.
.I Xp
provides a registration procedure for registering all Athena widgets.
For backward compatibility with previous releases of Wcl, this
registration procedure has three names: AriRegisterAthena(), 
XpRegisterAll(), and XpRegisterAthena().  These procedures
are exactly equivalent.
.TP
.B void XpRegisterAthena( XtAppContext )
This procedure registers all of the Athena widget class pointer names,
widget class names, and widget constructor function names with Wcl.
It also registers all Xp converters and action procedures with Xt,
and all Xp callback procedures with Wcl.
.SH CONVERTERS
.LP
.I Xp
does not provide any converters itself, but it does attempt to ensure
that WcCvtStringToWidget is used rather than XmuNewStringToWidget.
.SH "SEE ALSO"
.BI XpTable (3),
.BI Ari (1),	
.BI Wcl (3),
.BI X (1)
.SH AUTHOR
David E. Smyth (David.Smyth@sniap.mchp.sni.de) at Siemens Nixdorf
Informationssysteme AG, Munich Germany.
