/*
 * makerom.h  -  Main include file for makerom program
 *
 * Copyright (C) 1997,1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MAKEROM_H_
#define _MAKEROM_H_


/*
 * Include version information
 */
#include "version.h"



/*
 * Size of I/O buffers
 */
#define BLKSIZE		512



/*
 * Definitions used for reading configuration files
 */

/* Packet driver options */
#define HW_IRQ		0x01
#define IO_ADDR		0x02
#define BASE_MEM	0x04
#define AUI_TYPE	0x08
#define DMA_NUM		0x10

/* Kernel options */
#define K_MINIMAL	0x01
#define K_X86		0x02

/* List for program descriptions */
struct desclist {
	char            *progname;
	char            *descript;
	int              options;
	struct desclist *next;
};



/*
 * Structure used to hold all definitions for one bootrom specification
 */
#define MAXDRIVERS	8		/* maximum number of driver programs */
#define MAXLOADERS	3		/* maximum number of loader programs */

struct bootdef {
	char *name;			/* name of bootrom description */
	char *kernelname;		/* name of kernel file */
	char *loadernames[MAXLOADERS];	/* names of loader binaries */
	char *outnames[MAXLOADERS];	/* names of output files */
	int flashflags[MAXLOADERS];	/* flag if out file gets flash header */
	int loadernum;			/* number of loader programs */
	char *drivernames[MAXDRIVERS];	/* names of driver programs */
	char *driverargs[MAXDRIVERS];	/* command lines of driver programs */
	int drivernum;			/* number of driver programs */
	int use_int18;			/* nonzero if we should use int 18h */
};



/*
 * Global variables
 */
extern char *progname;			/* program name */
extern char *netbootdir;		/* netboot directory */
extern char *dbname;			/* database file name */
extern char *kerneldir;			/* directory with kernel binaries */
extern char *loaderdir;			/* directory with loader binaries */
extern char *pktdrvdir;			/* directory with packet drivers */
extern char *utilsdir;			/* directory with utility binaries */
extern int verbose;			/* verbosity flag */
extern unsigned short chksum;		/* output file checksum */
extern struct desclist *kerneldesc;	/* list of kernel descriptions */
extern struct desclist *pktdrvdesc;	/* list of packet driver descriptions */



/*
 * Data area which holds the EXE program loader
 */
extern unsigned char execom_data[];
extern unsigned int execom_data_size;



/*
 * External routines
 */
extern int doread __P((unsigned char *buf, unsigned int bufsize, int infile));
extern int dowrite __P((unsigned char *buf, unsigned int bufsize, int outfile));
extern void readconfig __P((char *fname));
extern struct bootdef *getdb __P((char *name));
extern struct bootdef *getuser __P((void));
extern void pass1 __P((struct bootdef *bp, int tempfile));
extern void pass2 __P((struct bootdef *bp, int kernfile, int loader));
extern void makeflash __P((char *outname, int tempfile));
extern unsigned long freeze __P((int infile, int outfile));


#endif

