.\" @(#)makerom.8
.\"
.\" Copyright (C) 1997,1998 Gero Kuhlmann   <gero@gkminix.han.de>
.\"
.\"  This program is free software; you can redistribute it and/or modify
.\"  it under the terms of the GNU General Public License as published by
.\"  the Free Software Foundation; either version 2 of the License, or
.\"  any later version.
.\"
.\"  This program is distributed in the hope that it will be useful,
.\"  but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"  GNU General Public License for more details.
.\"
.\"  You should have received a copy of the GNU General Public License
.\"  along with this program; if not, write to the Free Software
.\"  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.TH MAKEROM 8 "26 Jul 1997"
.SH NAME
makerom \- Make bootrom image

.SH SYNOPSIS
.LP
.B makerom
[\-b <batch name>] [\-c <config file>] [\-n <netboot directory>] [\-x]
.LP
.B makerom
\-h
.LP
.B makerom
\-v

.SH DESCRIPTION
.B makerom
generates an IP
.SM Boot-Rom
either interactively or in batch mode. It works by first concatenating
the bootrom kernel file with the program driver files (like packet driver
etc.), then compressing the resulting image and concatenating it with
either the floppy or the rom loader stubs.

.SH OPTIONS
.TP
.B \-b
Lets
.B makerom
operate in batch mode. It will look up the given batch name in a
database file and generates a bootrom according to the specifications
given in the database entry. See below for further information regarding
the format of this database file.
.TP
.B \-c
Specifies a configuration file. See below for how this file has to look
like.
.TP
.B \-n
Specifies the netboot directory where
.B makerom
looks for the files required for generating a new bootrom. If this option
is given, it will override the corresponding environment and configuration
file settings.
.TP
.B \-h
Output short usage information.
.TP
.B \-v
Output version information.
.TP
.B \-x
Increase verbosity level.

.SH ENVIRONMENT
.TP
.B MAKEROM
Specifies the directory where
.B makerom
looks for the files necessary to create a new bootrom image. This
environment variable setting can be overriden by the
.B \-n
command line option or the
.B netbootdir
configuration file entry.
.TP
.B MAKEROMCONFIG
Specifies the name of the configuration file. This environment variable
setting can be overriden by the
.B \-c
command line option.

.SH CONFIGURATION FILE
The configuration file used by
.B makerom
is organized into different sections. Each section is introduced by an
identifying tag in square brackets. The format between these tags is
different for each section. See below for a further description. Everything
from a # character up to the end of the line is ignored as a comment. Also
empty lines are ignored. If no configuration file is given either on the
command line or by an environment variable, the default
.B /usr/local/lib/netboot/makerom.config
will be used.
.TP
.B [makerom]
This section contains general definitions for
.B makerom
to work properly. All lines in this section have to be
formatted as a variable name followed by an equal sign followed by
the variable value. Blanks around the equal sign are ignored, so the
value of a variable starts at the first non-blank character after the
equal sign and continues up to the last non-blank character in the
line excluding any optional comment. The following variables are
recognized:
.RS
.TP
.B netbootdir
Specifies the directory where
.B makerom
looks for all the files required to build a bootrom. If not specified,
the default
.B /usr/local/lib/netboot
will be used. This variable can be overriden by the
.B \-n
command line switch.
.TP
.B database
Specifies the name of the database file to be used when operating in
batch mode. This entry is not used when
.B makerom
works in interactive mode.
.TP
.B kerneldir
Specifies the directory where
.B makerom
looks for kernel files to generate a list of usable kernels in interactive
mode.
.TP
.B pktdrvdir
Specifies the directory where
.B makerom
looks for packet driver binaries in interactive mode.
.TP
.B utilsdir
Specifies the directory where
.B makerom
looks for the utility files
.BR ansidrv.com ,
the bootrom ANSI display driver, and
.BR pktwatch.com ,
a program to debug the bootrom packet driver interface.
.LP
For all variables except
.B netbootdir
two leading slashes in the value get replaced by the value of the
.B netbootdir
variable. Therefore,
.IR //makerom.db
gets expanded to
.IR /usr/local/lib/netboot/makerom.db
provided
.B netbootdir
contains the default value.
.RE
.TP
.B [kernel]
This section contains descriptions for the bootrom kernels
.B makerom
uses to actually create the final bootrom image. Each line contains the
description for one kernel image and is divided into three fields. All
fields are separated by blanks. This section is only used when
.B makerom
operates in interactive mode!
.RS
.TP
.B Kernel name
This field specifies the name of the kernel image file with the
.B .bin
extension stripped.
.B makerom
always looks in the directory specified by the
.B kerneldir
variable for kernel images.
.TP
.B Kernel description
This field contains a short description string of the kernel image. The
string has to be enclosed in double quotes. Between the quotes blanks are
allowed.
.TP
.B Kernel flags
This field contains flags which specify certain features of the kernel
image. All flags have to be separated by a comma, with
.B no
blanks in between. The following flags are recognized (caution: case
matters!):
.RS
.TP
.B MINIMAL
specifies a minimal kernel, for which there is no need to include the
ANSI display driver.
.TP
.B X86
specifies a kernel for a 16 bit x86 processor. If this kernel is
selected in interactive mode,
.B makerom
automatically selects the corresponding 16 bit rom loader.
.RE
.RE
.TP
.B [pktdrv]
Like the
.B [kernel]
section this one describes the packet driver binaries usable by
.B makerom
to create the bootrom image. It is also formatted in three fields separated
by blanks, and also only used in interactive mode. The fields are defined
as follows:
.RS
.TP
.B Packet driver name
This field contains the file name of the packet driver image with the
.BR .com
extension stripped.
.B makerom
always looks for packet drivers in the directory specified by the
.B pktdrvdir
variable.
.TP
.B Packet driver description
This field contains a short description of the packet driver enclosed
in double quotes.
.TP
.B Packet driver flags
This field contains flags which describe what packet driver command line
options
.B makerom
should ask for. It assumes that the packet driver accepts it's command
line options in the way the Crynwr packet drivers usually do. If the
flags field is empty, the packet driver doesn't require any command
line options except the software interface interrupt, which gets set by
.B makerom
automatically. The following flags are recognized:
.RS
.TP
.B HW_IRQ
The packet driver requires specifying the hardware interrupt of the network
card.
.TP
.B IO_ADDR
The packet driver requires specifying the I/O address of the network card.
.TP
.B BASE_MEM
If the network card uses shared memory, this flag tells
.B makerom
to ask the user for the base segment address of the shared memory.
.TP
.B DMA_NUM
Some network cards use a DMA line, which has to be specified to the
packet driver.
.TP
.B AUI_TYPE
If the network card supports different ethernet interfaces, this flag tells
.B bootrom
to ask for the type to be used.
.RE

.SH DATABASE FILE
The database file is organized into tag separated sections like the
configuration file. However, the tags are the names of individual system's
configurations. If you give the
.B \-b
option on the command line to
.BR makerom ,
it will take the name following the
.B \-b
switch and look up a section in the database file which has a tag with
this name, followed by a colon and the name of the program, i.e. "makerom".
All tags have to be enclosed in square brackets. A sample tag for a
system named
.B myclient
would therefore look like
.BR [myclient:makerom] .
Within each section you can define how
.B makerom
should assemble the bootrom using variables similar to those given in the
.B [makerom]
section of the configuration file. Each line in a section consists of
a variable name followed by an equal sign followed by the variable value.
The following variables are recognized:
.TP
.B kernel
Specifies the name of the kernel file to be used. If the name starts with
two slashes these get replaced by the
.B netbootdir
value.
.TP
.B useint18
This is a boolean variable which can only have the values
.BR true
or
.BR false .
If it's
.BR true ,
the bootrom will use interrupt 18h for startup which is the
old BASIC startup vector on old PC's. This interrupt gets called by the
BIOS when it can't find a bootable floppy or hard disk partition. If the
value of this variable is set to
.BR false ,
the bootrom will use interrupt 19h instead, which is the PC bootstrap
interrupt. In this case, the system will not seek any hard disks in the
system for a bootable partition (but will still check the first floppy
drive), but immediately start the netboot process. The default for this
variable is
.BR false .
.TP
.B loaderX
Specifies the file names of all bootrom loaders.
.B makerom
will create a bootrom image file for each rom loader specified. The
.B X
in the variable name can be a number from 1 to 3. For each
.B loaderX
variable there has to be a corresponding
.B outnameX
variable as well. If the file name starts with two slashes these get
substituted with the
.B netbootdir
value.
.TP
.B outnameX
Specifies the names of the bootrom image files created with the rom loaders.
.TP
.B flashX
This boolean flag can have a value of either
.B true
or
.BR false ,
and specifies whether the output file number
.B X
will be used for remote programming a FlashCard. If
.B flashX
is missing for a particular output file name, the default
.B false
is assumed. It is ignored for a floppy boot loader. When this flag is set,
.B makerom
will add a boot file image header and a program into the output file, which
allow it to be loaded by a boot rom via TFTP and then program a FlashCard
with the newly created boot rom.
.TP
.B driverX
Specifies the file names of all driver programs (like packet driver, ANSI
display driver etc.) to be loaded into the bootrom. The
.B X
in the variable name can be a number from 1 to 8. For each
.B driverX
variable there has to be a corresponding
.B argumentX
variable as well. If the file name starts with two slashes these get
substituted with the
.B netbootdir
value.
.TP
.B argumentX
Specifies the command lines which have to passed to each of the drivers. The
value of an argument variable can be empty. Everything following the equal
sign up to the last non-blank character is used for the command line,
including any blanks in between.

.SH BUGS
None known yet.

.SH AUTHOR
.B makerom
was written by
.SM Gero Kuhlmann <gero@gkminix.han.de>.

