/*
 * $Id: trafshow.h,v 1.2 1997/08/12 19:17:13 begemot Exp begemot $
 * $Log: trafshow.h,v $
 * Revision 1.2  1997/08/12 19:17:13  begemot
 * New modes, new options (show speed, sort).
 *
 * Revision 1.1  1997/08/12 16:37:50  begemot
 * Initial revision
 *
 * Revision 1.25  1995/02/26  19:21:02  begemot
 * Nothing important
 *
 * Revision 1.24  1995/02/26  18:59:25  begemot
 * Added RCS Id & Log entries into the all source files.
 *
 */

/*
 * Copyright (C) 1994-1997 D.Gorodchanin. See COPYING for more info.
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <limits.h>
#include <strings.h>
#include <signal.h>
#include <netdb.h>
#include <unistd.h>
#include <curses.h>
#include <pwd.h>
#include <resolv.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <linux/if_arp.h>
#include <linux/if_ether.h>
#include <linux/if_packet.h>
#include <linux/if.h>
#include <linux/ip.h>

/* Start of user defines section */

#define SCREEN_UPDATE   3	       /* Screen update interval (sec) */
#define CHANNEL_REMOVE  10	       /* Inactive channel remove from screen (sec) */
#define CHANNEL_FORGET  180            /* Inactive channel drop time (sec) */
#define CHANNELS_COUNT  512	       /* Max. channels in cash  */
#define HOSTS_COUNT     512	       /* Max. hostnames in cash */
#define FRAGS_COUNT     512	       /* Max. hostnames in cash */
#define MIN_LINES	3	       /* Min. lines on terminal */
#define MIN_RAWS	80	       /* Min. columns on terminal */
#define MAX_PACKET_LEN	8192	       /* Max of MTU for all devices */
#define SPEED_INTRVLS	{5, 10, 30, 120} /* Speed calculation intervals */
#define SPEED_COUNT	4	       /* No. of speed intervals */

/* End of user defines section */

#define _PATH_TCP_INFO "/proc/net/tcp"
#define _PATH_UDP_INFO "/proc/net/udp"

#define MAX_IF_NAME    14  /* size of spkt_device in linux/if_packet.h */
#define MAX_SERV_NAME	6
#define MAX_USER_NAME   8
#define MAX_PROT_NAME	4
#define MAX_DATA_SIZE   10			 
#define MAX_HOST_NAME   ((MIN_RAWS - 2 * \
			  (MAX_DATA_SIZE + 1 + MAX_SERV_NAME + 1) \
			  - MAX_PROT_NAME - 1 - 1) / 2 )  

struct channel_entry  {
	unsigned long saddr;
	unsigned long daddr;
	unsigned long sport;
	unsigned long dport;
	double        ispeed[SPEED_COUNT+1];
	double        ospeed[SPEED_COUNT+1];
	unsigned long in;
	unsigned long out;
	unsigned long scr_seq;
	struct timeval tm;
	unsigned short next;
	unsigned char proto;
	unsigned char line;
	unsigned char sserv[MAX_SERV_NAME+1];
	unsigned char dserv[MAX_SERV_NAME+1];
	unsigned char suser[MAX_USER_NAME+1];
	unsigned char duser[MAX_USER_NAME+1];
	unsigned char ifname[MAX_IF_NAME+1];
	unsigned char get_user_try;
};

extern int update_interval;
extern int remove_interval;
extern int forget_interval;
extern int dont_resolve;
extern int force_mono;
extern int show_speed;		/* 0 => no ; 1 - SPEED_COUNT => show */
extern int sort_mode;
extern unsigned char iface[MAX_IF_NAME+1];
extern struct timeval start;
extern struct timeval now;
extern struct timeval next;

enum {
	TOTAL = 0,
	ILL,
	NONIP,
	TCP,
	UDP,
	ICMP,
	UNKN,
	MAX_STATS,
};

extern double stats[MAX_STATS][SPEED_COUNT + 1];

/* table.c */
void calc_speed(double array[], int size, struct timeval * last);
void update_channels (unsigned long const saddr,
		      unsigned long const daddr,
		      unsigned short const sport,
		      unsigned short const dport,
		      unsigned char const proto,
		      int const size,
		      unsigned char const * const ifname);

int get_channels_list(struct channel_entry * * const list,
		      int const size);

void init_channels_table(void);

/* host.c */
unsigned short ip_fast_csum(unsigned char const * const buff, int const wlen);
char const * get_host_name(unsigned long const addr);

/* screen.c */
void screen_open(void);
void screen_update(void);
void screen_close(void);

/* frag.c */
int handle_fragment(struct iphdr * iph, int len);

