/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include <sys/wait.h>
#include "connect.h"
#include "main.h"

extern void accs(void);
extern void handler(int);
extern void sending(struct client_type *);
extern void client_filter_programm(void *);
extern void set_filter(short);
extern void free_memory(void);

/*
 * Client--This is the client part of pftp.
 */
void Client(int portn, int argc, char **argv)
{
   FILE *fp=NULL;
   int i, pid=0, optval=BUFSIZE;
   struct client_type *clientstr;
   struct hostent *hp=(struct hostent *)NULL;
   struct sockaddr_in sin;
   int sinlen;
#ifdef USE_POSIX_THREAD
   pthread_t thr;
#endif

   MEM_CHECK((clientstr = (struct client_type *)calloc(1, sizeof(struct client_type))));
   sinlen = sizeof(sin);
   memset((char *)&sin, 0, sinlen);
   argc -= ((int) (*statstr)->_OPTIONS_ - (int) (*statstr)->_STANDARD_INPUT_);
   i = (int) (*statstr)->_OPTIONS_;
   /*
    * Set signals SIGPIPE and SIGINT.
    */
   signal(SIGPIPE, handler);
   signal(SIGINT, handler);

   /*
    * Next, we need to look up the network
    * address of our host.
    */
   if (!(*statstr)->_HOSTNAME_) (*statstr)->_HOSTNAME_ = argv[i];
   if ((hp = (struct hostent *)gethostbyname((*statstr)->_HOSTNAME_)) != NULL) {
      memcpy(&sin.sin_addr, hp->h_addr, hp->h_length);
   }
   else if (!(sin.sin_addr.s_addr = inet_addr((*statstr)->_HOSTNAME_))) {
      fprintf(stderr, "** %s: unknown host.\n", (*statstr)->_HOSTNAME_);
      exit(1);
   }
   if (hp) (*statstr)->_HOSTNAME_ = hp->h_name;

   fprintf(stderr, "\n*** %s is contacting %s ", *argv, (*statstr)->_HOSTNAME_);
   fprintf(stderr, "on port %d ***\n\n", portn);
   
   /*
    * Set client filter if '-f' was given on cmdline.
    */
   if ((*statstr)->usefilter) set_filter(0);

   /*
    * Get a socket and set options on it.
    */
   accs();   
   if (!(*statstr)->_STANDARD_INPUT_) {
      setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&optval, sizeof(optval));
   }
   else if ((*statstr)->_SET_STDIN_BUF_) {
      setsockopt(s, SOL_SOCKET, SO_SNDBUF, (char *)&((*statstr)->_STDIN_BUFSIZ_), \
      sizeof((*statstr)->_STDIN_BUFSIZ_));
   }

   if (s) {
      /*
       * Create the address we will be connecting to.
       */
      sin.sin_family = AF_INET;
      sin.sin_port = htons(portn);

      /*
       * Try to connect to the address, For this to
       * succeed, the server already have bound
       * this address, and must have issued a listen()
       * request.
       * First send file name.
       */
      if (connect(s, (struct sockaddr *)&sin, sinlen) < 0) {
         fprintf(stderr, "** connect: %s\n", _PFTP_ERROR_ARRAY_);
         if (pftplog) {
            if ((fp = fopen(pftplog, "a")) != NULL) {
               fprintf(fp, "** connect: %s\n", _PFTP_ERROR_ARRAY_);
               fclose(fp);
            }
         }
         exit(1);
      }

#if !defined HP_UX
      fcntl(s, F_SETFL, FASYNC);
#endif

      /*
       * Set file pointer.
       */
      pid = 0;
      argv += i + 1;
      clientstr->argc = argc;
      clientstr->argv = argv;
      if (*filter) {
#ifdef USE_POSIX_THREAD
         if ((pid = pthread_create(&thr, NULL, (void *)&client_filter_programm, (void *)clientstr)) != 0) {
            fprintf(stderr, "** pthread_create: %s\n", _PFTP_ERROR_ARRAY_PID_);
            exit(1);
         }
         if ((pid = pthread_join(thr, NULL)) != 0) {
            fprintf(stderr, "** pthread_join: %s\n", _PFTP_ERROR_ARRAY_PID_);
            exit(1);
         }
#else
         /*
          * Spawn a new process for the filter programm.
          */
         if ((pid = fork()) < 0) {
            fprintf(fp, "** fork: %s\n", _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         /*
          * Here starts the filter process.
          */
         if (!pid) {
            /*
             * Reset the signals to its defaults behavoir.
             */
            signal(SIGPIPE, SIG_DFL);
            signal(SIGINT, SIG_DFL);

            client_filter_programm((void *)clientstr);
         }
         else {
#ifdef NEXTSTEP
            while (wait((union wait *)0) != pid);
#else
            while (wait((int *)0) != pid);
#endif
         }
#endif
      }
      else {
         (*statstr)->fp = fdopen(s, "w");
         fflush((*statstr)->fp);
         if ((*statstr)->_STANDARD_INPUT_) {
            setvbuf((*statstr)->fp, \
            (*statstr)->_STDIN_BUFFER_, \
            (*statstr)->_STDIN_BUFFER_ ?  _IOFBF : _IONBF, \
            (*statstr)->_SET_STDIN_BUF_ ? (*statstr)->_STDIN_BUFSIZ_: BUFSIZ);
         }

         /*
          * Actually send the files.
          */
         sending(clientstr);
         fclose((*statstr)->fp);
      }
   }
   shutdown(s, 2);
   if (clientstr) free(clientstr);
   free_memory();
   fputc('\n', stderr);
}
