/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#ifdef FreeBSD
#include <sys/errno.h>
#endif
#include "main.h"
#include <ctype.h>

extern void set_tty(int);

void shost(int num, int *portn, char *home)
{
   char *name, str[SONAME];
   FILE *fp;
   int i, port=0, ISVARIABLE=1;

   if ((fp = fopen(home, "r")) == NULL) {
      fprintf(stderr, "**\n** There is no .pftprc file in your home directory. Please, rtfm!\n**\n");
      exit(1);
   }
   fgets(str, sizeof(str), fp);
   while (ISVARIABLE) {
      ISVARIABLE = 0;
      fgets(str, sizeof(str), fp);
      if (*str == '\n' || *str == '#') {
         ISVARIABLE = 1;
         continue;
      }
      if (!strncmp("PFTPCLIENTS", str, 11)) ISVARIABLE = 1;
      else if (!strncmp("PFTPSFILTER", str, 11)) ISVARIABLE = 1;
      else if (!strncmp("PFTPCFILTER", str, 11)) ISVARIABLE = 1;
      else if (!strncmp("PFTPLOG", str, 7)) ISVARIABLE = 1;
      else if (*str == '\n') ISVARIABLE = 1;
   }

   for (i=1; i < num && fgets(str, sizeof(str), fp); i++) {
      if (*str == '\n' || *str == '#') i--;
   }
   name = NULL;
   MEM_CHECK((name = (char *) calloc(SONAME, sizeof(*name))));
   if (i == num) {
      if (feof(fp)) {
         fclose(fp);
         fprintf(stderr, "** You entered an invalid number!\n");
         exit(1);
      }
      sscanf(str, "%s %d", name, &port);
   }

   if (name) {
      if ((*statstr)->_HOSTNAME_) free((*statstr)->_HOSTNAME_);
      MEM_CHECK(((*statstr)->_HOSTNAME_ = (char *) calloc(SONAME, sizeof(*name))));
      strcpy((*statstr)->_HOSTNAME_, name);
   }
   if (port) *portn = port;
   free(name);
   fclose(fp);
}


void lhost(char *name, int *portn)
{
   FILE *fp;
   char c=0, home[SONAME], str[SONAME];
   int tmp, num=0, varnum=0;
   long position=0;

   strcpy(home, getenv("HOME"));
   strcat(home, PFTPRESOURCE);
    
   if ((fp = fopen(home, "r")) == NULL) {
      fprintf(stderr, "**\n** There is no .pftprc file in your home directory. Please, rtfm!\n**\n");
      exit(1);
   }

   /*
    * Read first line.
    */
   *str = '\0';
   fgets(str, sizeof(str), fp);
   if (isdigit(*str)) sscanf(str, "%d", &tmp);
   else {
         fprintf(stderr, "**\n** `%s' contains no default portnumber.\n**\n", home);
         fclose(fp);
         exit(1);
   }
   if (*portn < 0) {
      *portn = tmp ? tmp : 0;
      return;
   }
   else if (tmp && *portn <= 0) *portn = tmp;

   /*
    * Get variables from file.
    */
   while (!c) {
      position = ftell(fp);
      if (!fgets(str, sizeof(str), fp)) break;
      if (*str == '\n' || *str == '#') continue;
      varnum++;
      if (!strncmp("PFTPCLIENTS", str, 11));
      else if (!strncmp("PFTPSFILTER", str, 11));
      else if (!strncmp("PFTPCFILTER", str, 11));
      else if (!(pftplog = getenv("PFTPLOG")) && !strncmp("PFTPLOG", str, 7)) {
         if (!pftplog) {
            char *tu=NULL;
            MEM_CHECK((pftplog = (char *) calloc(SONAME, sizeof(char))));
            for (num=0; *(str+num) && *(str+num) != ' ' && *(str+num) != '\t'; num++);
            for (; *(str+num) && (*(str+num) == ' ' || *(str+num) == '\t'); num++);
            tu = str+num;
            for (; *(str+num) && (*(str+num)) != '\n'; num++);
            *(str+num) = '\0';
            if (*tu) strcpy(pftplog, tu);
            else free(pftplog);
         } 
      }
      else {
         if (fseek(fp, position, 0)) {
            fprintf(stderr, "** %s: %s\n", home, _PFTP_ERROR_ARRAY_);
            exit(1);
         }
         break;
      }
   }

   /*
    * Create host name list.
    */
   if (name) {
      while (*name) {
         if (*name == 'l') { 
            char hn[14];
            int i=0, j, h;
            c = '0';
            num = 0;

            /*
             * Set _WINROWS_.
             */
            set_tty(1);
            set_tty(0);

            MEM_CHECK((name = (char *) calloc(SONAME, sizeof(*name))));
            /*
             * Print list on screen.
             */
            while (c != 'q') {
               for (j=0; j < (_WINROWS_ - 4); j++) {
                  if (!fgets(str, sizeof(str), fp)) {
                     if (j) for (; j < (_WINROWS_ - 4); j++) fputc('\n', stderr);
                     fprintf(stderr, "** End of file reached.\n");
                     break;
                  }
                  if (!j) fprintf(stderr, "[H[J\n******* Host name(s) ****************** Port number(s) [%d] ***\n",*portn);
                  tmp = *portn;
                  *name = '\0';
                  sscanf(str, "%s %d", name, &tmp);
                  if (!*name || *str == '#') {
                     j--;
                     continue;
                  }
                  fprintf(stderr, " %4d) %-36.36s %6d\n", ++num, name, tmp);
               }
               if (!feof(fp)) fputc('\n', stderr);
               fprintf(stderr, "*** <q> quit, <space> more, <b> back, <NUM> select host[1]: ");

               c = '0'; i = 0; *hn = '\0';

               while (isdigit(c) || c == '' || c == '') {
                  set_tty(2);
                  c = fgetc(stdin);
                  set_tty(0);
                  switch(c) {
                     case 'q':
                        fclose(fp);
                        fputs("quit", stderr);
                        fputc('\n', stderr);
                        exit(0);
                        break;
                     case 'b':
                        if (num > _WINROWS_ - 4) {
                           if (fseek(fp, position, 0)) {
                              fprintf(stderr, "** %s: %s\n", home, _PFTP_ERROR_ARRAY_);
                              exit(1);
                           }
                           for (j=0; j < 60 + _WINCOLS_ + i; j++) fputs("\b \b", stderr);
                           if (num > 2 * (_WINROWS_ - 4)) {
                              for (j=1; j <= (num - (2 * (_WINROWS_ - 4))); j++) {
                                 fgets(str, sizeof(str), fp);
                                 if (*str == '\n' || *str == '#') j--;
                              }
                              num -= 2 * (_WINROWS_ - 4);
                           }
                           else num = 0;
                        }
                        else c = '0';
                        break;
                     case ' ':
                        if (!feof(fp)) for (j=0; j < 60 + _WINCOLS_ + i; j++) fputs("\b \b", stderr); 
                        else c = '0';
                        break;
                     case '': case '':
                        if (i > 0) {
                           fputs("\b \b", stderr); 
                           hn[--i] = '\0';
                        }
                        break;
                     case '\n':
                        fclose(fp);
                        for (j=0; j < (int) (60 + strlen(hn)); j++) fputs("\b \b", stderr); 
                        h = atoi(hn) ? atoi(hn) : 1;
                        shost(h, portn, home);
                        return;
                     default:
                        if (isdigit(c) && i < 13) {
                           fputc(c, stderr);
                           hn[i++] = c;
                           hn[i] = '\0';
                        }
                        else c = '0';
                        break;
                  }
               }
            }
            fclose(fp);
            exit(0);
         }
         else if (isdigit(*name)) {
               num = atoi(name);
               shost(num, portn, home);
               return;
         }
         name++;
      }
   }

   fclose(fp);
}


short get_var_from_pftprc(const char *name, char *value)
{
   FILE *fp=NULL;
   char *home=NULL, *str=NULL;
   int num=0;
   *value = '\0';

   MEM_CHECK((str = (char *)calloc(SONAME, sizeof(char))));
   /*
    * Get name of resource file.
    */
   MEM_CHECK((home = (char *)calloc(SONAME, sizeof(char))));
   strcpy(home, getenv("HOME"));
   strcat(home, PFTPRESOURCE);

   if ((fp = fopen(home, "r")) == NULL) {
      fprintf(stderr, "**\n** There is no .pftprc file in your home directory. Please, rtfm!\n**\n");
      exit(1);
   }

   while (!*value) {
      if (!fgets(str, SONAME, fp)) break;
      if (*str == '\n') continue;
      for (num=0; *(str+num) && *(str+num) != ' ' && *(str+num) != '\t'; num++);
      for (;*(str+num) == ' ' || *(str+num) == '\t'; num++);
      if (!strncmp(name, str, strlen(name)) && (*(str+num))) {
         if (!getenv(name)) {
            strcpy(value, str+num);
            for (; *value != '\n' && *value; value++);
            *value = '\0';
            fclose(fp);
            return 1;
         }
      }
   }
   fclose(fp);
   return 0;
}
