/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996, 1997 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    bhor0533@lehr.chem.TU-Berlin.DE
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include <time.h>
#include "main.h"

/*
 * Get Client's hostname.
 */
void import(char *filename, unsigned long filesize, unsigned long ci, int strnum)
{
#ifdef USE_POSIX_THREAD
   if (!ci) {
      OUTPUT++;
      (*statstr+strnum)->output = OUTPUT;
      (*statstr)->RECEIVING = 1;
   }
#endif

#ifdef USE_POSIX_THREAD
   if ((*(statstr+strnum))->lol) {
      if ((*statstr+strnum)->output == OUTPUT) fputc('\r', stderr);
      else if ((*statstr)->RECEIVING) fputc('\n', stderr);
      (*statstr)->RECEIVING = 0;
   }
#else
   if ((*(statstr+strnum))->lol) fputc('\r', stderr);
#endif
   fflush(stderr);

   if ((*(statstr+strnum))->REMOTEHOSTNAME) {
      if (ci > 0) fprintf(stderr, "+ %s (%ld bytes) %s from %s.\n", filename, ci, (*(statstr+strnum))->_SKIP_ > 1 ? "skipped": "received", (*(statstr+strnum))->REMOTEHOSTNAME);
      else if (!ci && (*(statstr+strnum))->lol) {
         fprintf(stderr, "\n** Receiving %s from %s failed.\n", filename, (*(statstr+strnum))->REMOTEHOSTNAME);
         if (pftplog) {
            FILE *fe=stderr;
            if ((fe = fopen(pftplog, "a")) != NULL) {
               fprintf(fe, "\n** Receiving %s from %s failed.\n", filename, (*(statstr+strnum))->REMOTEHOSTNAME);
               fclose(fe);
            }
         }
      }
      else {
         if (!(*(statstr+strnum))->_STANDARD_INPUT_ || *filename != '|') (*(statstr+strnum))->lol = 1;
         if (filesize) fprintf(stderr, "* %s %s (%ld bytes) from %s", (*(statstr+strnum))->_SKIP_ > 1 ? "Skipping": "Receiving", filename, filesize, (*(statstr+strnum))->REMOTEHOSTNAME);
         else fprintf(stderr, "* %s %s from %s", (*(statstr+strnum))->_SKIP_ > 1 ? "Skipping": "Receiving", filename, (*(statstr+strnum))->REMOTEHOSTNAME);
      }
   }
   else {
      if (ci > 0) fprintf(stderr, "+ %s (%ld bytes) %s.\n", filename, ci, (*(statstr+strnum))->_SKIP_ > 1 ? "skipped": "received");
      else if (!ci && (*(statstr+strnum))->lol) {
         fprintf(stderr, "\n** Receiving %s failed.\n", filename);
         if (pftplog) {
            FILE *fe=stderr;
            if ((fe = fopen(pftplog, "a")) != NULL) {
               fprintf(fe, "\n** Receiving %s failed.\n", filename);
               fclose(fe);
            }
         }
      }
      else {
         if (!(*(statstr+strnum))->_STANDARD_INPUT_ || *filename != '|') (*(statstr+strnum))->lol = 1;
         fprintf(stderr, "* %s %s (%ld bytes)", (*(statstr+strnum))->_SKIP_ > 1 ? "Skipping": "Receiving", filename, filesize);
      }
   }
   if (!ci && (*(statstr+strnum))->_STANDARD_INPUT_ && !filesize) fprintf(stderr, "\n");
   fflush(stderr);
}

void timing(int strnum, double *sum_bytes)
{
#ifdef USE_POSIX_THREAD
   double start;
#else
   static double start;
#endif
   double diff=0;
   double rate=0;
   struct {
      long tv_sec;
      long tv_usec;
   } tv;

   if (!*sum_bytes) {
      tv.tv_sec  = 1;
      tv.tv_usec = 1;
      gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
      start = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
#ifdef USE_POSIX_THREAD
      (*(statstr+strnum))->start = start;
#endif
   }
   else {
#ifdef USE_POSIX_THREAD
      start = (*(statstr+strnum))->start;
#endif
      gettimeofday((struct timeval *)&tv, (struct timezone *)NULL);
      diff  = (double) tv.tv_sec + ((double) tv.tv_usec / 1000000.0F);
      diff -= start;
      rate  = *sum_bytes / diff;
      rate /= (double)1024;
      fprintf(stderr, " (%ldb %.2fs %.2fKb/s) closed.\n", (unsigned long)*sum_bytes, diff, rate);
   }
}
