/*================================================================
 * external control via pipe interface
 *================================================================*/

#ifndef EXT_C_H_DEF
#define EXT_C_H_DEF

#include "channel.h"

/* shared memory record */
typedef struct {
	int reset_panel;
	int multi_part;
	int curcs;
	int vel[MAX_MIDI_CHANNELS];
	int maxvel[MAX_MIDI_CHANNELS];
	ChannelStat channels[MAX_MIDI_CHANNELS];
} PanelInfo;

extern PanelInfo *extpanel;
extern int pipe_in, pipe_out;
extern int shmid;
extern int child_pid;

int ext_control_init(int write_pipe, int read_pipe, int do_shmid,
		     int redirect, int argc, char **argv);
void ext_control_end(void);
void ext_pipe_printf(char *fmt, ...);
void ext_pipe_puts(char *str);
void ext_control_load(char *name);
void ext_control_next(void);
void ext_control_prev(void);
void ext_control_restart(void);
void ext_control_stop(void);
void ext_control_pause(void);
void ext_control_kill(void);
void ext_control_jump(int csec);
void ext_control_move(int csec);
void ext_control_chorus(int mode);
void ext_control_reverb(int mode);
void ext_control_volume(int vol);
void ext_control_bass(int vol);
void ext_control_treble(int vol);
void ext_control_keychange(int offset);

#endif
