/*================================================================
 * get name of presets
 *================================================================*/

static char *gmvoices[256] = {
/* 000 */ "acpiano",
/* 001 */ "brtpian",
/* 002 */ "synpian",
/* 003 */ "honky",
/* 004 */ "epiano1",
/* 005 */ "epiano2",
/* 006 */ "hrpscrd",
/* 007 */ "clavint",
/* 008 */ "celeste",
/* 009 */ "glocken",
/* 010 */ "musicbx",
/* 011 */ "vibes",
/* 012 */ "marimba",
/* 013 */ "xylphon",
/* 014 */ "tubebel",
/* 015 */ "santur",
/* 016 */ "homeorg",
/* 017 */ "percorg",
/* 018 */ "rockorg",
/* 019 */ "church",
/* 020 */ "reedorg",
/* 021 */ "accordn",
/* 022 */ "harmnca",
/* 023 */ "cncrtna",
/* 024 */ "nylngtr",
/* 025 */ "acguitr",
/* 026 */ "jazzgtr",
/* 027 */ "clengtr",
/* 028 */ "mutegtr",
/* 029 */ "odguitr",
/* 030 */ "distgtr",
/* 031 */ "gtrharm",
/* 032 */ "acbass",
/* 033 */ "fngrbas",
/* 034 */ "pickbas",
/* 035 */ "fretles",
/* 036 */ "slpbas1",
/* 037 */ "slpbas2",
/* 038 */ "synbas1",
/* 039 */ "synbas2",
/* 040 */ "violin",
/* 041 */ "viola",
/* 042 */ "cello",
/* 043 */ "cntraba",
/* 044 */ "marcato",
/* 045 */ "pizzcat",
/* 046 */ "harp",
/* 047 */ "timpani",
/* 048 */ "marcato",
/* 049 */ "slowstr",
/* 050 */ "synstr1",
/* 051 */ "synstr2",
/* 052 */ "choir",
/* 053 */ "doo",
/* 054 */ "voices",
/* 055 */ "orchhit",
/* 056 */ "trumpet",
/* 057 */ "trombon",
/* 058 */ "tuba",
/* 059 */ "mutetrm",
/* 060 */ "frchhrn",
/* 061 */ "hitbras",
/* 062 */ "synbrs1",
/* 063 */ "synbrs2",
/* 064 */ "sprnsax",
/* 065 */ "altosax",
/* 066 */ "tenrsax",
/* 067 */ "barisax",
/* 068 */ "oboe",
/* 069 */ "englhrn",
/* 070 */ "bassoon",
/* 071 */ "clarint",
/* 072 */ "piccolo",
/* 073 */ "flute",
/* 074 */ "recordr",
/* 075 */ "woodflt",
/* 076 */ "bottle",
/* 077 */ "shakazl",
/* 078 */ "whistle",
/* 079 */ "ocarina",
/* 080 */ "sqrwave",
/* 081 */ "sawwave",
/* 082 */ "calliop",
/* 083 */ "chflead",
/* 084 */ "charang",
/* 085 */ "voxlead",
/* 086 */ "lead5th",
/* 087 */ "baslead",
/* 088 */ "fantasi",
/* 089 */ "warmpad",
/* 090 */ "polysyn",
/* 091 */ "ghostie",
/* 092 */ "bowglss",
/* 093 */ "metalpd",
/* 094 */ "halopad",
/* 095 */ "sweeper",
/* 096 */ "aurora",
/* 097 */ "sndtrk",
/* 098 */ "crystal",
/* 099 */ "atmsphr",
/* 100 */ "frshair",
/* 101 */ "unicorn",
/* 102 */ "sweeper",
/* 103 */ "startrk",
/* 104 */ "sitar",
/* 105 */ "banjo",
/* 106 */ "shamisn",
/* 107 */ "koto",
/* 108 */ "kalimba",
/* 109 */ "bagpipe",
/* 110 */ "fiddle",
/* 111 */ "shannai",
/* 112 */ "carillo",
/* 113 */ "agogo",
/* 114 */ "steldrm",
/* 115 */ "woodblk",
/* 116 */ "taiko",
/* 117 */ "toms",
/* 118 */ "syntom",
/* 119 */ "revcym",
/* 120 */ "fx-fret",
/* 121 */ "fx-blow",
/* 122 */ "seashor",
/* 123 */ "jungle",
/* 124 */ "telephn",
/* 125 */ "helicpt",
/* 126 */ "applaus",
/* 127 */ "rngwhsl",
};

char *inst_name(int preset)
{
	return gmvoices[preset];
}

struct drum_name_list {
	int preset;
	char *name;
};

static struct drum_name_list drums[] = {
	{8, "room"},
	{16, "power"},
	{24, "electrc"},
	{25, "tr-808"},
	{32, "jazz"},
	{40, "brush"},
	{48, "orchest"},
	{56, "soundfx"},
	{127, "mt-32"},
};

char *drum_name(int preset)
{
	int i;
	for (i = 0; i < sizeof(drums)/sizeof(drums[0]); i++) {
		if (preset == drums[i].preset)
			return drums[i].name;
	}
	return "standrd";
}
