/* 
   CAM - Cpu's Audio Mixer for Linux 
   (c) 1994-1996 
   AUTHOR: Jan 'TWP' VANDENBERGHE (jvdbergh@uia.ua.ac.be) 
 
*/ 
 
/* 
     This program is free software; you can redistribute it and/or 
     modify it under the terms of the GNU General Public License 
     as published by the Free Software Foundation; either version 2 
     of the License, or (at your option) any later version. 
 
     This program is distributed in the hope that it will be useful, 
     but WITHOUT ANY WARRANTY; without even the implied warranty of 
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
     GNU General Public License for more details. 
 
     You should have received a copy of the GNU General Public License 
     along with this program; if not, write to the Free Software 
     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/ 
 
 
#include "cam.h" 

#include <strings.h>

void finish(int sig)
{
    close_mixer();
    echo();
    endwin();
    clear();
    refresh();
    if (sig != 0)
       exit(1);
}
            
   
void set_screen(void)
{
   char dummy[COLS];
   int left, right;

   left = ( COLS - 15 - strlen(VERSION_HIGH) - strlen(VERSION_LOW) ) / 2;
   right = COLS - 15 - strlen(VERSION_HIGH) - strlen(VERSION_LOW) - left; 
   clear();
   leaveok(stdscr ,TRUE);
   attrset(COLOR_PAIR( COLOR_SCREEN ) | A_BOLD);
   sprintf(dummy,"%*cCAM %s.%s for Linux%*c",left,' ',VERSION_HIGH,VERSION_LOW,right,' ');
   mvaddstr(0,0,dummy);
   sprintf(dummy," Cpu's Audio Mixer %s.%s%*cauthor : Jan 'TWP' VANDENBERGHE (c)1994-1996 ",VERSION_HIGH,VERSION_LOW,COLS-20-45-strlen(VERSION_HIGH)-strlen(VERSION_LOW),' ');
   mvaddstr(LINES-1,0,dummy );
   attrset(A_NORMAL | A_BOLD );
   mvaddstr(LINES-2,4,"Press 'h' for help");
}

/* Draws the sliders */ 
void draw_slider(int Y, int X, char *device) 
{ 
   attrset(COLOR_PAIR(COLOR_SLIDER));
   mvaddnstr(Y+1,X,device,7);
   mvaddstr(Y+1,X+8,"Left"); 
   mvaddstr(Y+2,X+8,"Right"); 
   attrset(COLOR_PAIR(COLOR_SLIDER) | A_ALTCHARSET);
   mvaddstr(Y+1,X+14,""); 
   mvaddstr(Y+2,X+14,""); 
   attrset(COLOR_PAIR(COLOR_VOL1) | A_ALTCHARSET);
   mvaddstr(Y,X+14,"   ");
   mvaddstr(Y+3,X+14,"   ");
   attrset(COLOR_PAIR(COLOR_VOL2) | A_ALTCHARSET);
   mvaddstr(Y,X+22,"   ");
   mvaddstr(Y+3,X+22,"   ");
   attrset(COLOR_PAIR(COLOR_VOL3) | A_ALTCHARSET);
   mvaddstr(Y,X+30,"  ");
   mvaddstr(Y+3,X+30,"  ");
}

/*
   Draws a handle
   1 : left+handle       2 : left + handle + right
   3 : handle + right    4 : handle
   5 : slide
*/
void draw_handle(int Y, int X,int active, int level)
{
   if ((level == 1 ) || ( level == 2 )) { 
      attrset(A_NORMAL  | A_ALTCHARSET); 
      mvaddch(Y,X++,205); 
   } 
   if ( level != 5) { 
      #define ACT_HANDLE COLOR_PAIR(COLOR_HANDLE) | A_BOLD | A_ALTCHARSET
      #define NACT_HANDLE COLOR_PAIR(COLOR_HANDLE) | A_DIM | A_ALTCHARSET    
      attrset(( active == TRUE  ? ACT_HANDLE : NACT_HANDLE)); 
      mvaddch(Y,X++,178); 
   } 
   if ((level == 3) || (level == 2)) { 
      attrset(A_NORMAL | A_ALTCHARSET); 
      mvaddch(Y,X++,205); 
   } 
   if ( level  == 5 ) { 
      attrset(A_NORMAL | A_ALTCHARSET); 
      mvaddch(Y,X++,205); 
   }    
}

void init_screen(void)
{
     stdscr = initscr();
     if ( (COLS < 80) || (LINES < 25) ) {
        finish(0);
        fprintf(stderr,"The screensize has to be minimum 80x25\n");
        exit(1);
     }
     make_colors();
}

/* gives status */ 
void status(char *status_line) 
{ 
   char line[20] = "";
   
   strncpy(line,status_line,20);
   attrset(A_NORMAL);
   mvaddstr(LINES-2,(COLS - 20 )/ 2,"                    "); 
   attrset(COLOR_PAIR(COLOR_STATUS) | A_BOLD ); 
   mvaddstr(LINES-2,(COLS - strlen(line)) / 2,line); 
   attrset(A_NORMAL); 
} 
 
/* Sends a message to the user */ 
void message(char *message_line) 
{ 
   char line[25];
   
   strncpy(line,message_line,25);   
   attrset(A_NORMAL); 
   move(LINES-2,COLS-26); 
   clrtoeol(); 
   attrset( COLOR_PAIR(COLOR_MSG) ); 
   mvaddstr(LINES-2,COLS-26,line); 
   attrset(A_NORMAL); 
} 


/* initializes the colors */
void make_colors(void)
{
     start_color();
     if ( has_colors() ) {
        init_pair( COLOR_SCREEN, COLOR_YELLOW, COLOR_BLUE);
        init_pair( COLOR_SLIDER, COLOR_WHITE, COLOR_BLACK);
        init_pair( COLOR_VOL1, COLOR_GREEN, COLOR_BLACK); 
        init_pair( COLOR_VOL2, COLOR_YELLOW, COLOR_BLACK); 
        init_pair( COLOR_VOL3, COLOR_RED, COLOR_BLACK);                
        init_pair( COLOR_HANDLE, COLOR_BLUE , COLOR_BLACK);
        init_pair( COLOR_HELP, COLOR_YELLOW, COLOR_BLUE);
        init_pair( COLOR_STATUS, COLOR_WHITE, COLOR_RED);
        init_pair( COLOR_MSG, COLOR_YELLOW, COLOR_BLACK);        
        
     } else {
        init_pair( COLOR_SCREEN, COLOR_BLACK, COLOR_WHITE);
        init_pair( COLOR_SLIDER, COLOR_WHITE, COLOR_BLACK);                                        
        init_pair( COLOR_VOL1, COLOR_WHITE, COLOR_BLACK); 
        init_pair( COLOR_VOL2, COLOR_WHITE, COLOR_BLACK); 
        init_pair( COLOR_VOL3, COLOR_WHITE, COLOR_BLACK);                
        init_pair( COLOR_HANDLE, COLOR_WHITE , COLOR_BLACK);
        init_pair( COLOR_HELP, COLOR_WHITE , COLOR_BLACK);
        init_pair( COLOR_STATUS, COLOR_BLACK, COLOR_WHITE);
        init_pair( COLOR_MSG, COLOR_WHITE, COLOR_BLACK);
                    
       }
     
}

/* displays the help screen */
void help(void) 
{ 
   WINDOW *help_win; 
   char ch; 
   touchwin(stdscr); 
   help_win = newwin(15,50,(LINES - 15) / 2,(COLS - 50) / 2);
   wattrset(help_win, COLOR_PAIR( COLOR_HELP) | A_BOLD | A_ALTCHARSET); 
   leaveok(help_win,TRUE); 
   wborder(help_win,179,179,196,196,218, 191,192,217); 
   wattrset(help_win, A_NORMAL | A_BOLD);
   mvwaddstr(help_win,2,2," Left/Right : Lower/Higher "); 
   mvwaddstr(help_win,3,2," Up/Down    : Previous/Next "); 
   mvwaddstr(help_win,5,2," l : Lock/Unlock "); 
   mvwaddstr(help_win,7,2," s : Save settings "); 
   mvwaddstr(help_win,8,2," g : Load settings "); 
   mvwaddstr(help_win,9,2," h : help "); 
   mvwaddstr(help_win,11,2," ESC/q : exit "); 
   mvwaddstr(help_win,13,8," Press key to leave help screen "); 
   ch = wgetch(help_win); 
   delwin(help_win); 
} 

/* displays help at command line */ 
void comm_help(void) 
{ 
   fprintf(stderr,"\nUsage: cam [OPTIONS]\n\n"); 
   fprintf(stderr,"OPTIONS\n"); 
   fprintf(stderr,"-v,  --volume  x,y : Set 'volume' to x (left) and y (right)\n"); 
   fprintf(stderr,"-b,  --bass    x,y : Set 'bass' to x (left) and y (right)\n"); 
   fprintf(stderr,"-t,  --treble  x,y : Set 'treble' to x (left) and y (right)\n"); 
   fprintf(stderr,"-s,  --synth   x,y : Set 'synth' to x (left) and y (right)\n"); 
   fprintf(stderr,"-p,  --pcm     x,y : Set 'pcm' to x (left) and y (right)\n"); 
   fprintf(stderr,"-S,  --speaker x,y : Set 'speaker' to x (left) and y (right)\n"); 
   fprintf(stderr,"-l,  --line    x,y : Set 'line in' to x (left) and y (right)\n"); 
   fprintf(stderr,"-m,  --mic     x,y : Set 'microphone' to x (left) and y (right)\n"); 
   fprintf(stderr,"-c,  --cd      x,y : Set 'cd in' to x (left) and y (right)\n"); 
   fprintf(stderr,"-I,  --imix    x,y : Set 'mixer' to x (left) and y (right)\n"); 
   fprintf(stderr,"-a,  --altpcm  x,y : Set 'altpcm' to x (left) and y (right)\n"); 
   fprintf(stderr,"-r,  --reclev  x,y : Set 'record level' to x (left) and y (right)\n"); 
   fprintf(stderr,"-i,  --igain   x,y : Set 'input gain' to x (left) and y (right)\n");    
   fprintf(stderr,"-o,  --ogain   x,y : Set 'output gain' to x (left) and y (right)\n");       
   fprintf(stderr,"-l1, --line1   x,y : Set 'input source 1' to x (left) and y (right)\n"); 
   fprintf(stderr,"-l2, --line2   x,y : Set 'input source 2' to x (left) and y (right)\n"); 
   fprintf(stderr,"-l3, --line3   x,y : Set 'input source 3' to x (left) and y (right)\n\n");    
  
   fprintf(stderr,"-get  : restore the saved values\n"); 
   fprintf(stderr,"-save : save the current values\n");    
   fprintf(stderr,"-getfile filename  : restore the saved values from file 'filename'\n"); 
   fprintf(stderr,"-savefile filename : save the current values from file 'filename'\n"); 
   fprintf(stderr,"-h, -?, --help : display's this help\n"); 
   fprintf(stderr,"\nNOTE : x and y are in range from 0 to 20\n"); 
} 
