#ifndef MYBYTE_ORDER
#define MYBYTE_ORDER 1
/* supply the byte order macros */

#if defined (WORDS_BIGENDIAN)
# define MY_BIG_ENDIAN 1
# define MY_LITTLE_ENDIAN 0
#else
# define MY_BIG_ENDIAN 0
# define MY_LITTLE_ENDIAN 1
#endif

# undef cpu_to_le32
# undef cpu_to_le16
# undef cpu_to_be32
# undef cpu_to_be16
# undef le32_to_cpu
# undef le16_to_cpu
# undef be32_to_cpu
# undef be16_to_cpu

#if    MY_BIG_ENDIAN == 1
#  define cpu_to_le32(x) \
        ((unsigned long int)((((unsigned long int)(x) & 0x000000ffU) << 24) | \
                             (((unsigned long int)(x) & 0x0000ff00U) <<  8) | \
                             (((unsigned long int)(x) & 0x00ff0000U) >>  8) | \
                             (((unsigned long int)(x) & 0xff000000U) >> 24)))
#  define cpu_to_le16(x) \
        ((unsigned short int)((((unsigned short int)(x) & 0x00ffU) <<  8) | \
                              (((unsigned short int)(x) & 0xff00U) >>  8)))
#  define le32_to_cpu(x) cpu_to_le32(x)
#  define le16_to_cpu(x) cpu_to_le16(x)
#  define cpu_to_be32(x) (x)
#  define cpu_to_be16(x) (x)
#  define be32_to_cpu(x) (x)
#  define be16_to_cpu(x) (x)
#else
#  define cpu_to_be32(x) \
        ((unsigned long int)((((unsigned long int)(x) & 0x000000ffU) << 24) | \
                             (((unsigned long int)(x) & 0x0000ff00U) <<  8) | \
                             (((unsigned long int)(x) & 0x00ff0000U) >>  8) | \
                             (((unsigned long int)(x) & 0xff000000U) >> 24)))
#  define cpu_to_be16(x) \
        ((unsigned short int)((((unsigned short int)(x) & 0x00ffU) <<  8) | \
                              (((unsigned short int)(x) & 0xff00U) >>  8)))
#  define be32_to_cpu(x) cpu_to_be32(x)
#  define be16_to_cpu(x) cpu_to_be16(x)
#  define cpu_to_le32(x) (x)
#  define cpu_to_le16(x) (x)
#  define le32_to_cpu(x) (x)
#  define le16_to_cpu(x) (x)
#endif

#define GET_UINT_FROM_CHARP(p) ((unsigned int)((*(p+3))<<24)|((*(p+2))<<16)|((*(p+1))<<8)|(*(p)))

#endif /* ifndef MYBYTE_ORDER */
